/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.navigator.resources;

import com.indy.environment.tool.URINode;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ZipFileStructureCreator;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InternalCompareEditorInput
extends CompareEditorInput {
    private static final boolean NORMALIZE_CASE = true;
    private Object fRoot;
    private IStructureComparator fLeft;
    private IStructureComparator fRight;
    private IResource fLeftResource;
    private URI fRightURI;
    private DiffTreeViewer fDiffViewer;
    private IAction fOpenAction;

    public InternalCompareEditorInput(CompareConfiguration config) {
        super(config);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                IStructuredSelection ss;
                if (InternalCompareEditorInput.this.fOpenAction == null) {
                    InternalCompareEditorInput.this.fOpenAction = new Action(){

                        public void run() {
                            this.handleOpen(null);
                        }
                    };
                    Utilities.initAction((IAction)InternalCompareEditorInput.this.fOpenAction, (ResourceBundle)this.getBundle(), (String)"action.CompareContents.");
                }
                boolean enable = false;
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof MyDiffNode) {
                        ITypedElement te = ((MyDiffNode)((Object)element)).getId();
                        if (te != null) {
                            enable = !"FOLDER".equals(te.getType());
                        }
                    } else {
                        enable = true;
                    }
                }
                InternalCompareEditorInput.this.fOpenAction.setEnabled(enable);
                manager.add(InternalCompareEditorInput.this.fOpenAction);
                super.fillContextMenu(manager);
            }
        };
        return this.fDiffViewer;
    }

    boolean setSelection(ISelection s, Shell shell) {
        URI uri;
        IResource[] selection = Utilities.getResources((ISelection)s);
        this.fLeftResource = selection[0];
        IOverrideService service = (IOverrideService)PlatformUI.getWorkbench().getService(IOverrideService.class);
        this.fRightURI = uri = service.getOverridenURI(Util.convertIFileToEMFURI((IFile)((IFile)this.fLeftResource)));
        this.fLeft = this.getStructure(this.fLeftResource);
        this.fRight = new URINode(this.fRightURI);
        return true;
    }

    private boolean checkSelection(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(ISelection s) {
        boolean threeWay;
        IResource[] selection = Utilities.getResources((ISelection)s);
        if (selection.length < 2 || selection.length > 3) {
            return false;
        }
        boolean bl = threeWay = selection.length == 3;
        if (threeWay) {
            return this.comparable(selection[0], selection[1]) && this.comparable(selection[0], selection[2]) && this.comparable(selection[1], selection[2]);
        }
        return this.comparable(selection[0], selection[1]);
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fLeftResource != null) {
            cc.setLeftLabel(this.buildLabel(this.fLeftResource));
            cc.setLeftImage(CompareUIPlugin.getImage((IAdaptable)this.fLeftResource));
        }
        if (this.fRightURI != null) {
            cc.setRightLabel(this.fRightURI.toString());
            cc.setRightImage(null);
        }
        cc.setRightEditable(false);
    }

    private boolean comparable(IResource c1, IResource c2) {
        return this.hasStructure(c1) == this.hasStructure(c2);
    }

    private boolean hasStructure(IResource input) {
        IFile file;
        String type;
        if (input instanceof IContainer) {
            return true;
        }
        if (input instanceof IFile && (type = (file = (IFile)input).getFileExtension()) != null) {
            return "JAR".equals(type = InternalCompareEditorInput.normalizeCase(type)) || "ZIP".equals(type);
        }
        return false;
    }

    private IStructureComparator getStructure(IResource input) {
        if (input instanceof IContainer) {
            return new FilteredBufferedResourceNode(input);
        }
        if (input instanceof IFile) {
            FilteredBufferedResourceNode rn = new FilteredBufferedResourceNode(input);
            IFile file = (IFile)input;
            String type = InternalCompareEditorInput.normalizeCase(file.getFileExtension());
            if ("JAR".equals(type) || "ZIP".equals(type)) {
                return new ZipFileStructureCreator().getStructure((Object)rn);
            }
            return rn;
        }
        return null;
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        try {
            this.fLeftResource.refreshLocal(2, pm);
            pm.beginTask(Utilities.getString((String)"ResourceCompare.taskName"), -1);
            String leftLabel = this.fLeftResource.getName();
            String rightLabel = this.fRightURI.trimFileExtension().lastSegment();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.title");
            String title = leftLabel + rightLabel;
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(false, pm, null, null, (Object)this.fLeft, (Object)this.fRight);
            return object;
        }
        catch (CoreException ex) {
            throw new InvocationTargetException(ex);
        }
        finally {
            pm.done();
        }
    }

    public String getToolTipText() {
        if (this.fLeftResource != null && this.fRightURI != null) {
            String leftLabel = this.fLeftResource.getFullPath().makeRelative().toString();
            String rightLabel = this.fRightURI.toString();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.tooltip");
            return leftLabel + rightLabel;
        }
        return super.getToolTipText();
    }

    private String buildLabel(IResource r) {
        if (r.isLinked() && r.getProject().isHidden()) {
            return r.getLocation().toString();
        }
        String n = r.getFullPath().toString();
        if (n.charAt(0) == '/') {
            return n.substring(1);
        }
        return n;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                InternalCompareEditorInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                if (this.fDiffViewer != null) {
                    this.fDiffViewer.refresh();
                }
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    InternalCompareEditorInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            NullProgressMonitor pm = new NullProgressMonitor();
            IFile[] files = (IFile[])this.getAdapter(IFile[].class);
            if (files != null && files.length > 0) {
                return files[0];
            }
            return null;
        }
        if (IFile[].class.equals((Object)adapter)) {
            HashSet collector = new HashSet();
            this.collectDirtyResources(this.fRoot, collector);
            return collector.toArray(new IFile[collector.size()]);
        }
        return super.getAdapter(adapter);
    }

    private void collectDirtyResources(Object o, Set collector) {
        if (o instanceof DiffNode) {
            IDiffElement[] children;
            IResource resource;
            BufferedResourceNode bn;
            ITypedElement right;
            IResource resource2;
            BufferedResourceNode bn2;
            DiffNode node = (DiffNode)o;
            ITypedElement left = node.getLeft();
            if (left instanceof BufferedResourceNode && (bn2 = (BufferedResourceNode)left).isDirty() && (resource2 = bn2.getResource()) instanceof IFile) {
                collector.add(resource2);
            }
            if ((right = node.getRight()) instanceof BufferedResourceNode && (bn = (BufferedResourceNode)right).isDirty() && (resource = bn.getResource()) instanceof IFile) {
                collector.add(resource);
            }
            if ((children = node.getChildren()) != null) {
                int i = 0;
                while (i < children.length) {
                    IDiffElement element = children[i];
                    if (element instanceof DiffNode) {
                        this.collectDirtyResources(element, collector);
                    }
                    ++i;
                }
            }
        }
    }

    private static String normalizeCase(String s) {
        if (s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected boolean isRightSaveNeeded() {
        return false;
    }

    static class FilteredBufferedResourceNode
    extends BufferedResourceNode {
        FilteredBufferedResourceNode(IResource resource) {
            super(resource);
        }

        protected IStructureComparator createChild(IResource child) {
            String name = child.getName();
            if (CompareUIPlugin.getDefault().filter(name, child instanceof IContainer, false)) {
                return null;
            }
            return new FilteredBufferedResourceNode(child);
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
            this.fDirty = false;
        }

        public void fireChange() {
            super.fireChange();
            InternalCompareEditorInput.this.setDirty(true);
            this.fDirty = true;
            if (InternalCompareEditorInput.this.fDiffViewer != null) {
                InternalCompareEditorInput.this.fDiffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return "<" + this.fLastName + ">";
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }

    class SelectAncestorDialog
    extends MessageDialog {
        private IResource[] theResources;
        IResource ancestorResource;
        IResource leftResource;
        IResource rightResource;
        private Button[] buttons;
        private SelectionListener selectionListener;

        public SelectAncestorDialog(Shell parentShell, IResource[] theResources) {
            super(parentShell, CompareMessages.SelectAncestorDialog_title, null, CompareMessages.SelectAncestorDialog_message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button selectedButton = (Button)e.widget;
                    if (!selectedButton.getSelection()) {
                        return;
                    }
                    int i = 0;
                    while (i < 3) {
                        if (selectedButton == SelectAncestorDialog.this.buttons[i]) {
                            SelectAncestorDialog.this.pickAncestor(i);
                        }
                        ++i;
                    }
                }
            };
            this.theResources = theResources;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.buttons = new Button[3];
            int i = 0;
            while (i < 3) {
                this.buttons[i] = new Button(composite, 16);
                this.buttons[i].addSelectionListener(this.selectionListener);
                this.buttons[i].setText(NLS.bind((String)CompareMessages.SelectAncestorDialog_option, (Object)this.theResources[i].getFullPath().toPortableString()));
                this.buttons[i].setFont(parent.getFont());
                this.buttons[i].setSelection(i == 0);
                ++i;
            }
            this.pickAncestor(0);
            return composite;
        }

        private void pickAncestor(int i) {
            this.ancestorResource = this.theResources[i];
            this.leftResource = this.theResources[i == 0 ? 1 : 0];
            this.rightResource = this.theResources[i == 2 ? 1 : 2];
        }
    }
}

