/*
 * Decompiled with CFR 0.152.
 */
package com.indy.environment.navigator.resources;

import com.indy.environment.EnvironmentPlugin;
import com.indy.environment.Messages;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class InternalResourceLabelProvider
extends LabelProvider
implements ILabelProvider,
IStateListener {
    private static Image folderImage;
    private static Image projectImage;
    private static Image mdImage;
    private static Image techImage;
    private static Image importedImage;
    private static Image procImage;
    private static Image tpcImage;
    private static Image techExtImage;
    private static CustomCompositeImageDescriptor decoratorDescriptor;
    private boolean treeMode = false;

    static {
        try {
            projectImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/prj_obj.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            folderImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/folder.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mdImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.md.ui.editor/icons/full/obj16/MdModelFile.gif")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            techImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.tech.editor/icons/full/obj16/Tech16x16.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            procImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.editor/icons/full/obj16/ProcModelFile.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            tpcImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.ui.conf.editor/icons/full/obj16/TpcModelFile.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            importedImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.environment/icons/full/19.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            techExtImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.tech.editor/icons/full/obj16/Tech16x16.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        decoratorDescriptor = new CustomCompositeImageDescriptor();
    }

    public InternalResourceLabelProvider() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand("com.indy.environment.command.internalResourceLayoutList");
            if (cmd != null) {
                State s = cmd.getState("org.eclipse.ui.commands.toggleState");
                this.treeMode = s.getValue() instanceof Boolean ? !((Boolean)s.getValue()).booleanValue() : false;
                s.addListener((IStateListener)this);
            }
        }
        catch (Exception ex) {
            EnvironmentPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.indy.environment", Messages.InternalResourceLabelProvider_9, (Throwable)ex));
        }
    }

    public String getText(Object element) {
        if (element instanceof TreeNode) {
            Object val = ((TreeNode)element).getValue();
            if (val instanceof URI) {
                StringBuilder b = new StringBuilder();
                if (this.treeMode) {
                    b.append(URI.decode((String)((URI)val).trimFragment().lastSegment()));
                } else {
                    int i = 3;
                    while (i < ((URI)val).segmentCount()) {
                        if (b.length() > 0) {
                            b.append("/");
                        }
                        b.append(URI.decode((String)((URI)val).segment(i)));
                        ++i;
                    }
                }
                return b.toString();
            }
            String decodedStr = "";
            try {
                decodedStr = URLDecoder.decode((String)val, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return decodedStr;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof TreeNode) {
            Object val = ((TreeNode)element).getValue();
            if (val instanceof String) {
                image = ((TreeNode)element).getParent() == null ? projectImage : folderImage;
            } else if (val instanceof URI) {
                if ("md".equals(((URI)val).fileExtension())) {
                    image = mdImage;
                } else if ("tech".equals(((URI)val).fileExtension())) {
                    image = techImage;
                } else if ("proc".equals(((URI)val).fileExtension())) {
                    image = procImage;
                } else if ("tpc".equals(((URI)val).fileExtension())) {
                    image = tpcImage;
                } else if ("tech_ext".equals(((URI)val).fileExtension())) {
                    image = techExtImage;
                }
                IOverrideService service = (IOverrideService)PlatformUI.getWorkbench().getService(IOverrideService.class);
                if (service.isOverriden((URI)val)) {
                    decoratorDescriptor.setBaseImage(image);
                    image = decoratorDescriptor.createImage();
                }
            }
        }
        if (image != null) {
            return image;
        }
        return super.getImage(element);
    }

    public void dispose() {
        Command cmd;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null && (cmd = commandService.getCommand("com.indy.environment.command.internalResourceLayoutList")) != null) {
            cmd.getState("org.eclipse.ui.commands.toggleState").removeListener((IStateListener)this);
        }
        super.dispose();
    }

    public void handleStateChange(State state, Object oldValue) {
        if (state.getValue() instanceof Boolean) {
            this.treeMode = (Boolean)state.getValue() == false;
        } else if (state.getValue() == null) {
            this.treeMode = false;
        }
    }

    private static class CustomCompositeImageDescriptor
    extends CompositeImageDescriptor {
        private Image baseImage;
        private Point size;
        private HashMap<Image, Image> createdImages = new HashMap();

        private CustomCompositeImageDescriptor() {
        }

        public void setBaseImage(Image baseImage) {
            this.baseImage = baseImage;
            this.size = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.baseImage.getImageData(), 0, 0);
            ImageData overlayImageData = importedImage.getImageData();
            int xValue = 0;
            int yValue = 0;
            this.drawImage(overlayImageData, xValue, yValue);
        }

        protected Point getSize() {
            return this.size;
        }

        public Image createImage() {
            if (this.createdImages.get(this.baseImage) != null) {
                return this.createdImages.get(this.baseImage);
            }
            Image i = super.createImage();
            this.createdImages.put(this.baseImage, i);
            return i;
        }
    }
}

