/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.decorator.ImageImageDescriptor;
import com.indy.emf.uri.decorator.IndyElementImageDescriptor;
import com.indy.emf.uri.decorator.ProblemMarkerManager;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.navigator.CommonNavigator;

public class CacheDecorator
extends LabelProvider
implements ILabelDecorator,
ProblemMarkerManager.IProblemChangedListener {
    private ListenerList<ILabelProviderListener> fListeners;
    private ImageDescriptorRegistry fRegistry;
    private Logger logger = LogManager.getLogger(CacheDecorator.class);
    public static final Set<CacheDecorator> cacheDecorator = new HashSet<CacheDecorator>();
    ICacheService cacheService;

    public static void refreshProjectExplorer() {
        IViewPart v = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (v instanceof CommonNavigator) {
            CommonNavigator cnf = (CommonNavigator)v;
            cnf.getCommonViewer().refresh();
        }
    }

    public static boolean isHideExtension() {
        ICommandService s = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command c = s.getCommand("com.indy.emf.uri.command.hideFileExtensionDecoration");
        if (c == null) {
            return true;
        }
        State state = c.getState("org.eclipse.ui.commands.toggleState");
        boolean oldValue = (Boolean)state.getValue();
        return oldValue;
    }

    public CacheDecorator() {
        cacheDecorator.add(this);
        Activator.getDefault().getProblemMarkerManager().addListener(this);
        this.cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
    }

    private boolean isElligibleResource(IResource r) {
        return IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(r.getFileExtension());
    }

    private String hideExtensionIfRequired(String text, Object element) {
        if (CacheDecorator.isHideExtension() && element instanceof IFile) {
            IFile f = (IFile)element;
            if (this.cacheService.isInit() && this.isElligibleResource((IResource)f)) {
                return text.replace(f.getFullPath().lastSegment(), f.getFullPath().removeFileExtension().lastSegment());
            }
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String decorateText(String text, Object element) {
        text = this.hideExtensionIfRequired(text, element);
        if (!(element instanceof IResource)) return null;
        IResource file = (IResource)element;
        if (this.cacheService != null && this.cacheService.isInit() && this.isElligibleResource(file)) {
            try {
                Object o;
                IMarker[] marquers = file.findMarkers("com.semarchy.resource.marker.roleRequired", false, 0);
                if (marquers != null && marquers.length > 0 && (o = marquers[0].getAttribute("com.semarchy.resource.marker.roleRequired.role")) instanceof String) {
                    return text + String.format(Messages.CacheDecorator_resource_missing_role_tag, o);
                }
            }
            catch (CoreException e) {
                this.logger.debug("Failed to acces file {} markers", (Object)file, (Object)e);
            }
            URI uri = Util.convertIFileToEMFURI((IFile)((IFile)file));
            ICacheService.SourceState s = this.cacheService.getSourceState(uri);
            if (s == null) return text + Messages.CacheDecorator_resource_not_indexed_tag;
            if (s.isSync()) {
                if (s.getRemark("com.indy.emf.uri.remark.udfActiveId") == null) return text;
                return text + Messages.CacheDecorator_resource_disabled_tag;
            }
            if (!s.isDuplicate()) return null;
            return text + Messages.CacheDecorator_resource_duplicate_tag;
        }
        if (file.getType() != 1 || !IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(file.getFileExtension())) return null;
        return text + Messages.CacheDecorator_resouce_discarded_tag;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private int computeResourceState(IResource file) throws CoreException {
        IMarker[] duplicatedFileMarkers;
        IProject project;
        int state = -1;
        if (!file.exists() || file instanceof IProject && !(project = (IProject)file).isOpen()) {
            return state;
        }
        IMarker[] markers = file.findMarkers("com.stambia.resource.marker", true, 2);
        if (markers.length > 0) {
            return 64;
        }
        markers = file.findMarkers("com.stambia.resource.marker.invalidmodel", true, 2);
        IMarker[] iMarkerArray = duplicatedFileMarkers = file.getType() == 1 ? new IMarker[]{} : file.findMarkers("com.stambia.resource.marker.duplicate", true, 2);
        if (markers.length > 0 || duplicatedFileMarkers.length > 0) {
            state = 32;
            if (Arrays.stream(markers).anyMatch(m -> this.getMarkerSeverity((IMarker)m) != Integer.valueOf(1))) {
                return 64;
            }
        }
        if (state == -1 && file.findMarkers("com.stambia.resource.marker.invalidXML", true, 2).length > 0) {
            return 32;
        }
        return state;
    }

    private Object getMarkerSeverity(IMarker m) {
        try {
            return m.getAttribute("severity");
        }
        catch (CoreException e) {
            return null;
        }
    }

    public Image decorateImage(Image image, Object element) {
        int state = -1;
        URI resourceURI = null;
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            try {
                this.computeResourceState(resource);
            }
            catch (CoreException e) {
                this.logger.debug("Failed to acces file {} markers", (Object)resource, (Object)e);
            }
        }
        int descriptorType = 0;
        if (((IOverrideService)E4InjectorHelper.getService(IOverrideService.class)).isOverrider(resourceURI)) {
            descriptorType = 128;
        }
        ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
        Rectangle bounds = image.getBounds();
        return switch (state) {
            case 64 -> this.getRegistry().get((ImageDescriptor)new IndyElementImageDescriptor(baseImage, descriptorType | 0x40, new Point(bounds.width, bounds.height)));
            case 32 -> this.getRegistry().get((ImageDescriptor)new IndyElementImageDescriptor(baseImage, descriptorType | 0x20, new Point(bounds.width, bounds.height)));
            default -> (descriptorType & 0x80) != -1 ? this.getRegistry().get((ImageDescriptor)new IndyElementImageDescriptor(baseImage, descriptorType, new Point(bounds.width, bounds.height))) : null;
        };
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void fireProblemsChangedPublic(IResource[] changedResources, boolean isMarkerChange) {
        this.fireProblemsChanged(changedResources, isMarkerChange);
    }

    public void dispose() {
        cacheDecorator.remove(this);
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        this.fireProblemsChangedPublic(changedResources, isMarkerChange);
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

