/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.commands;

import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class CrossRefRecoveryHandler
extends AbstractHandler {
    protected static final String REFRENCE_ATTRIBUTE_ID = "com.indy.emf.uri.referenceId";
    protected static final String RESOURCE_MARKER_ID = "com.stambia.resource.marker";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<String> missingCrossRefId = new ArrayList<String>();
        try {
            IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(RESOURCE_MARKER_ID, true, 2);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String refId = (String)marker.getAttribute(REFRENCE_ATTRIBUTE_ID);
                refId = refId.replaceAll("=>.*", "");
                missingCrossRefId.add(refId);
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<IResource> allResource = new ArrayList<IResource>();
        this.detectAllResouce((IResource)ResourcesPlugin.getWorkspace().getRoot(), allResource);
        ResourceSetImpl rs = new ResourceSetImpl();
        HashMap<String, String> missingFragmentMap = new HashMap<String, String>();
        for (IResource _r : allResource) {
            try {
                URI uri = Util.convertIPathToEMFURI2((IPath)_r.getFullPath());
                Resource r = rs.getResource(uri, true);
                Map intrensicIds = ((ResourceImpl)r).getIntrinsicIDToEObjectMap();
                if (intrensicIds != null) {
                    for (String s : intrensicIds.keySet()) {
                        if (!missingCrossRefId.contains(s)) continue;
                        missingFragmentMap.put(s, r.getURIFragment((EObject)intrensicIds.get(s)));
                    }
                }
                r.unload();
                rs.getResources().remove((Object)r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void detectAllResouce(IResource r, List<IResource> allResource) {
        if (r instanceof IContainer) {
            try {
                ((IContainer)r).refreshLocal(1, null);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        if (IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(r.getFileExtension())) {
            allResource.add(r);
        }
        if (r instanceof IContainer && (!(r instanceof IProject) || ((IProject)r).isOpen())) {
            try {
                IResource[] iResourceArray = ((IContainer)r).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource re = iResourceArray[n2];
                    this.detectAllResouce(re, allResource);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

