/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal.workspace;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.internal.workspace.DeleteOperation;
import com.indy.emf.uri.internal.workspace.MoveOperation;
import com.indy.emf.uri.internal.workspace.MoveProjectOperation;
import com.indy.emf.uri.internal.workspace.ResetIdsOperation;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;

public class LinkedFileOperationBuilder {
    @Inject
    XDIModelURIResolver resolver;
    @Inject
    IWorkspace workspace;
    private List<Operation> operations = new ArrayList<Operation>();

    public LinkedFileOperationBuilder() {
        IEclipseContext ctx = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        ContextInjectionFactory.inject((Object)this, (IEclipseContext)ctx);
    }

    private boolean hasDiagram(IPath p) {
        boolean res = false;
        if (p.getFileExtension().equals("proc") && !p.segment(1).equals("indy.build")) {
            res = true;
        }
        if (p.getFileExtension().equals("map")) {
            res = true;
        }
        return res;
    }

    protected List<IPath> getRelatedFiles(IPath resourcePath) {
        if (resourcePath.getFileExtension() == null) {
            return Collections.emptyList();
        }
        ArrayList<IPath> res = new ArrayList<IPath>();
        URI resourceURI = URIUtils.convertIPathToEMFURI2((IPath)resourcePath);
        if (!resourcePath.segment(1).equals("indy.build")) {
            if (resourcePath.getFileExtension().equals("map")) {
                res.addAll(URIUtils.getMappingBuiltFiles((URI)resourceURI, (XDIModelURIResolver)this.resolver, (boolean)false).stream().map(URIUtils::toPath).collect(Collectors.toList()));
                res.add(URIUtils.toPath((URI)URIUtils.getMappingRef((URI)resourceURI)));
            }
            if (resourcePath.getFileExtension().equals("map") || resourcePath.getFileExtension().equals("proc") || resourcePath.getFileExtension().equals("md")) {
                res.add(URIUtils.toPath((URI)URIUtils.getCrossModelURI((URI)resourceURI)));
            }
        }
        if (this.hasDiagram(resourcePath)) {
            URI diagramURI = URIUtils.getDiagramURI((URI)resourceURI);
            res.add(URIUtils.toPath((URI)diagramURI));
        }
        return res;
    }

    public void handleFileMoved(IPath movedFrom, IPath movedTo) {
        if (movedFrom.getFileExtension() == null) {
            return;
        }
        if (movedTo.getFileExtension().equals(movedFrom.getFileExtension())) {
            this.operations.add(new MoveOperation(this.workspace, this.getRelatedFiles(movedFrom), movedTo));
        } else {
            this.operations.add(new DeleteOperation(this.workspace, this.getRelatedFiles(movedFrom)));
        }
    }

    public void handleProjectMoved(IPath movedFrom, IPath movedTo) {
        this.operations.add(new MoveProjectOperation(this.workspace, movedFrom, movedTo));
    }

    public void handleFileDeleted(IPath resourcePath) {
        this.operations.add(new DeleteOperation(this.workspace, this.getRelatedFiles(resourcePath)));
    }

    public void handleFileCopied(Collection<IPath> modelToReinit) {
        this.operations.add(new ResetIdsOperation(this.workspace, modelToReinit));
    }

    public ISchedulingRule computeSchedulingRule() {
        AtomicReference rule = new AtomicReference();
        this.operations.forEach(o -> rule.set(MultiRule.combine((ISchedulingRule)((ISchedulingRule)rule.get()), (ISchedulingRule)o.getRule())));
        return (ISchedulingRule)rule.get();
    }

    public void runOperations(IProgressMonitor monitor) {
        for (Operation o : this.operations) {
            if (monitor.isCanceled()) {
                return;
            }
            o.perform();
        }
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    static interface Operation {
        public void perform();

        public ISchedulingRule getRule();
    }
}

