/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.uberbuilder;

import com.indy.engine.uberbuilder.UberJarConfiguration;
import com.indy.engine.uberbuilder.executor.UberRunner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.logging.Level;

public class UberJarBuilder {
    private UberJarConfiguration configuration;

    public UberJarBuilder(UberJarConfiguration configuration) {
        this.configuration = configuration;
    }

    public void buildUberJAR(File uberJarFile) throws IOException {
        if (uberJarFile.exists()) {
            throw new IOException(String.format("The file %s already exists.", uberJarFile.getAbsolutePath()));
        }
        URI uri = URI.create("jar:" + String.valueOf(uberJarFile.toURI()));
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("create", "true");
        env.put("useTempFile", Boolean.TRUE);
        Path runtimePath = this.configuration.getBaseRuntimeFolder().toPath();
        UberRunner.LOGGER.log(Level.FINEST, String.format("Creating uber jar %s from %s", uberJarFile.getAbsolutePath(), runtimePath));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
                InputStream is;
                Path runtimeRoot = zipfs.getPath("runtime", new String[0]);
                Path enginePropertiesPath = zipfs.getPath("properties", new String[0]);
                Files.createDirectories(runtimeRoot.resolve(enginePropertiesPath), new FileAttribute[0]);
                Files.copy(this.configuration.getEngineParametersFile().toPath(), runtimeRoot.resolve(zipfs.getPath("properties/engineParameters.xml", new String[0])), new CopyOption[0]);
                Files.copy(this.configuration.getLog4jConfigurationFile().toPath(), runtimeRoot.resolve(zipfs.getPath("properties/log4j2.xml", new String[0])), new CopyOption[0]);
                if (this.configuration.getAdditionalConfigurationFolder() != null) {
                    Files.walkFileTree(this.configuration.getAdditionalConfigurationFolder().toPath(), new CopyFileVisitor(runtimeRoot.resolve("user-conf"), this.configuration.getAdditionalConfigurationFolder().toPath()));
                }
                Files.walkFileTree(FileSystems.getDefault().getPath(runtimePath.toString(), "external"), new CopyFileVisitor(runtimeRoot, runtimePath));
                Files.walkFileTree(FileSystems.getDefault().getPath(runtimePath.toString(), "lib"), new CopyFileVisitor(runtimeRoot, runtimePath));
                Files.walkFileTree(FileSystems.getDefault().getPath(runtimePath.toString(), "license"), new CopyFileVisitor(runtimeRoot, runtimePath));
                Files.walkFileTree(FileSystems.getDefault().getPath(runtimePath.toString(), "scripts"), new CopyFileVisitor(runtimeRoot, runtimePath));
                Files.walkFileTree(this.configuration.getModuleFolder().toPath(), new CopyFileVisitor(runtimeRoot.resolve("modules"), this.configuration.getModuleFolder().toPath()));
                Path deliveriesPath = zipfs.getPath("build/deliveries", new String[0]);
                Files.createDirectories(runtimeRoot.resolve(deliveriesPath), new FileAttribute[0]);
                for (File d : this.configuration.getDeliveriesFile()) {
                    Files.copy(d.toPath(), runtimeRoot.resolve(String.valueOf(deliveriesPath) + "/" + d.getName()), new CopyOption[0]);
                }
                Path manifestPath = zipfs.getPath("META-INF/MANIFEST.MF", new String[0]);
                Files.createDirectories(zipfs.getPath("META-INF/", new String[0]), new FileAttribute[0]);
                Object object = null;
                Throwable throwable2 = null;
                try (InputStream is2 = this.createManifest();){
                    Files.copy(is2, manifestPath, new CopyOption[0]);
                }
                catch (Throwable throwable3) {
                    if (object == null) {
                        object = throwable3;
                    } else if (object != throwable3) {
                        ((Throwable)object).addSuppressed(throwable3);
                    }
                    throw object;
                }
                String uberFilePath = UberRunner.class.getName().replace(".", "/") + ".class";
                Files.createDirectories(zipfs.getPath(uberFilePath.substring(0, uberFilePath.lastIndexOf("/")), new String[0]), new FileAttribute[0]);
                throwable2 = null;
                Object var14_22 = null;
                try {
                    is = UberJarBuilder.class.getClassLoader().getResourceAsStream(uberFilePath);
                    try {
                        Files.copy(is, zipfs.getPath(uberFilePath, new String[0]), new CopyOption[0]);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                uberFilePath = UberRunner.Operation.class.getName().replace(".", "/") + ".class";
                throwable2 = null;
                var14_22 = null;
                try {
                    is = UberJarBuilder.class.getClassLoader().getResourceAsStream(uberFilePath);
                    try {
                        Files.copy(is, zipfs.getPath(uberFilePath, new String[0]), new CopyOption[0]);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                uberFilePath = UberRunner.Executor.class.getName().replace(".", "/") + ".class";
                throwable2 = null;
                var14_22 = null;
                try {
                    is = UberJarBuilder.class.getClassLoader().getResourceAsStream(uberFilePath);
                    try {
                        Files.copy(is, zipfs.getPath(uberFilePath, new String[0]), new CopyOption[0]);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable2 == null) {
                        throwable2 = throwable6;
                    } else if (throwable2 != throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            uberJarFile.delete();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Unexpected error during uberJar creation", t);
        }
        UberRunner.LOGGER.log(Level.FINEST, String.format("Uber jar %s created", uberJarFile.getAbsolutePath()));
    }

    private InputStream createManifest() throws Exception {
        ManifestWriter writer = new ManifestWriter();
        writer.write("Manifest-Version", "1.0");
        writer.write("Created-by", UberJarBuilder.class.getName() + " " + this.getBundleVersion());
        writer.write("Main-Class", UberRunner.class.getName());
        return writer.getStream();
    }

    /*
     * Loose catch block
     */
    private String getBundleVersion() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                BufferedReader br;
                InputStream is;
                block20: {
                    block19: {
                        is = UberJarBuilder.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
                        br = new BufferedReader(new InputStreamReader(is));
                        String buf = null;
                        String res = null;
                        while ((buf = br.readLine()) != null) {
                            if (!buf.startsWith("Bundle-Version:")) continue;
                            res = buf.replace("Bundle-Version:", "");
                            break;
                        }
                        if (res == null) {
                            throw new Exception("Missing bundle version in its manifest");
                        }
                        string = res;
                        if (br == null) break block19;
                        br.close();
                    }
                    if (is == null) break block20;
                    is.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new Exception("Failed to read bundle manifest", ex);
        }
    }

    private class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private final Path sourcePath;

        CopyFileVisitor(Path targetPath, Path sourcePath) {
            this.targetPath = targetPath;
            this.sourcePath = sourcePath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir).toString()), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }
    }

    private class ManifestWriter {
        StringBuffer buf = new StringBuffer();

        private ManifestWriter() {
        }

        public void write(String header, String ... values) {
            this.buf.append(header);
            this.buf.append(":");
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    this.buf.append(",");
                    this.buf.append("\n");
                }
                this.buf.append(" ");
                this.buf.append(values[i]);
                ++i;
            }
            this.buf.append("\n");
        }

        InputStream getStream() throws UnsupportedEncodingException {
            return new ByteArrayInputStream(this.buf.toString().getBytes("UTF-8"));
        }
    }
}

