/*
 * Decompiled with CFR 0.152.
 */
package com.indy.administration;

import com.indy.administration.AdministrationListener;
import com.indy.administration.AdministrationService;
import com.semarchy.xdi.designer.core.services.IComponentService;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AdministrationHelper {
    private static AdministrationService instance;
    private static ServiceReference<AdministrationService> serviceRef;

    private AdministrationHelper() {
    }

    public static void releaseService(AdministrationService service) {
        if (service == instance) {
            instance = null;
            BundleContext ctx = Platform.getBundle((String)"com.indy.administration").getBundleContext();
            if (serviceRef != null) {
                ctx.ungetService(serviceRef);
            }
        }
    }

    public static boolean supportTechModelFromWorkspace() {
        return AdministrationHelper.getInstance().isAllowed("com.indy.administration.permission.tech.fromWorkspace");
    }

    public static boolean supportRuntimeSelection() {
        return AdministrationHelper.getInstance().isAllowed("com.indy.administration.permission.chooseRuntime");
    }

    public static boolean componentAuthorized(IComponentService.IComponent component) {
        if (component.getLicensePermission() == null) {
            return true;
        }
        return AdministrationHelper.getInstance().isAllowed("com.indy.administration.permission.component." + component.getLicensePermission());
    }

    public static void addListener(AdministrationListener listener) {
        AdministrationHelper.getInstance().addListener(listener);
    }

    public static void removeListener(AdministrationListener listener) {
        AdministrationHelper.getInstance().removeListener(listener);
    }

    private static synchronized AdministrationService getInstance() {
        if (instance == null) {
            BundleContext ctx = Platform.getBundle((String)"com.indy.administration").getBundleContext();
            serviceRef = ctx.getServiceReference(AdministrationService.class);
            instance = (AdministrationService)ctx.getService(serviceRef);
        }
        return instance;
    }

    public static boolean supportWebServicePublication() {
        return AdministrationHelper.getInstance().isAllowed("com.indy.administration.permission.publishWebService");
    }

    public static boolean supportScheduler() {
        return AdministrationHelper.getInstance().isAllowed("com.indy.administration.permission.scheduler");
    }
}

