/*
 * Decompiled with CFR 0.152.
 */
package com.indy.administration.impl;

import com.indy.administration.Permission;
import com.indy.administration.Role;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class BaseRole
implements Role {
    private String name;
    private Collection<Permission> permissions = new HashSet<Permission>();
    private HashMap<String, Boolean> _cachedResult = new HashMap();

    public BaseRole(String name) {
        this.name = name;
    }

    public void addPermission(Permission p) {
        this.permissions.add(p);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allow(String permissionName) {
        Boolean res = this._cachedResult.get(permissionName);
        if (res != null) {
            return res;
        }
        res = false;
        for (Permission p : this.permissions) {
            if (!p.matches(permissionName) || !p.isAllowed()) continue;
            this._cachedResult.put(permissionName, Boolean.TRUE);
            return true;
        }
        this._cachedResult.put(permissionName, Boolean.FALSE);
        return false;
    }
}

