/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventDispatcher {
    List<RuntimeListener> runtimeListeners = Collections.synchronizedList(new ArrayList());

    public void addRuntimeListeners(RuntimeListener listener) {
        this.runtimeListeners.add(listener);
    }

    public void removeRuntimeListeners(RuntimeListener listener) {
        this.runtimeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(RuntimeEvent re) {
        List<RuntimeListener> list = this.runtimeListeners;
        synchronized (list) {
            for (RuntimeListener rl : this.runtimeListeners) {
                rl.handleEvent(re);
            }
        }
    }

    public static class RuntimeEvent {
        public String host;
        public String port;
        public String name;
        public String user;
        public String password;
        public RuntimeEventType type;
    }

    public static enum RuntimeEventType {
        connect,
        open,
        disconnect;

    }

    public static interface RuntimeListener {
        public void handleEvent(RuntimeEvent var1);
    }
}

