/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.ui.engine.session.ISessionListViewer;
import com.indy.ui.engine.session.SessionList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SessionContentProvider
implements ITreeContentProvider,
ISessionListViewer {
    private SessionList list;
    private TreeViewer tblViewer;
    Map<String, TreePath> map = new HashMap<String, TreePath>();

    public SessionContentProvider(SessionList list, TreeViewer tblViewer) {
        this.list = list;
        this.tblViewer = tblViewer;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput != null) {
            ((SessionList)newInput).addChangeListener(this);
        }
        if (oldInput != null) {
            ((SessionList)oldInput).removeChangeListener(this);
        }
    }

    public void dispose() {
        this.list.removeChangeListener(this);
    }

    @Override
    public void addSessions(Object[] sessions) {
        this.tblViewer.add((Object)"", sessions);
    }

    TreePath getTreePath(ISessionDataExchange session) {
        TreePath tp = this.map.get(session.getId());
        if (tp == null) {
            ISessionDataExchange parent;
            String parentId = session.getParentSessionId();
            if (parentId != null && (parent = this.list.getAllSessionsMap().get(parentId)) != null) {
                tp = this.getTreePath(parent).createChildPath((Object)session);
                this.map.put(session.getId(), tp);
                return tp;
            }
            tp = new TreePath(new Object[]{session});
            this.map.put(session.getId(), tp);
        }
        return tp;
    }

    @Override
    public void removeSessions(Object[] sessions) {
        this.tblViewer.remove(sessions);
    }

    @Override
    public void updateSessions(Object[] sessions) {
        this.tblViewer.update(sessions, null);
    }

    @Override
    public void removeAllSessions() {
        this.tblViewer.refresh();
    }

    @Override
    public void setSelection(final ISessionDataExchange session) {
        this.tblViewer.setSelection((ISelection)new IStructuredSelection(){

            public Object getFirstElement() {
                return session;
            }

            public Iterator iterator() {
                return null;
            }

            public int size() {
                return 1;
            }

            public Object[] toArray() {
                return new Object[]{session};
            }

            public List toList() {
                return null;
            }

            public boolean isEmpty() {
                return false;
            }
        });
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof SessionList) {
            return this.list.getRootSessions().toArray();
        }
        ArrayList<ISessionDataExchange> _list = new ArrayList<ISessionDataExchange>();
        Set<String> set = this.list.getChildrenSession().get(((ISessionDataExchange)parentElement).getId());
        if (set != null) {
            for (String sessionID : set) {
                ISessionDataExchange child = this.list.getAllSessionsMap().get(sessionID);
                if (child == null) continue;
                _list.add(child);
            }
        }
        return _list.toArray();
    }

    public Object getParent(Object element) {
        String sessionId = ((ISessionDataExchange)element).getParentSessionId();
        if (sessionId != null) {
            return this.list.getAllSessionsMap().get(sessionId);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Set<String> set = this.list.getChildrenSession().get(((ISessionDataExchange)element).getId());
        return set != null && set.size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        Object[] o = this.list.getRootSessions().toArray();
        int i = 0;
        int n = o.length;
        while (i < n) {
            Assert.isNotNull((Object)o[i]);
            ++i;
        }
        return o;
    }

    @Override
    public void refresh() {
        Object[] expandedElements = this.tblViewer.getExpandedElements();
        this.tblViewer.refresh();
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.tblViewer.setExpandedState(element, true);
            ++n2;
        }
    }
}

