/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.ui.engine.api.v1_0.LocalGLobalVar;
import com.indy.ui.engine.util.Functions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SessionLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public String getColumnText(Object element, int columnIndex) {
        Object result = "";
        ISessionDataExchange session = (ISessionDataExchange)element;
        switch (columnIndex + 1) {
            case 1: {
                result = Functions.getFormatDate(session.getBeginDate());
                break;
            }
            case 2: {
                result = session.getName();
                break;
            }
            case 4: {
                if (session.getStatus() == 10 || session.getStatus() == -4) break;
                Date d = session.getBeginDate();
                if (d != null) {
                    long l = d.getTime();
                    long end = session.getEndDate() != null ? session.getEndDate().getTime() : System.currentTimeMillis();
                    long delta = end - l;
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                    result = sdf.format(delta).toString();
                    break;
                }
                result = "";
                break;
            }
            case 3: {
                result = LocalGLobalVar.getStringEngineStatus(session.getStatus());
                break;
            }
            case 6: {
                result = session.getId();
                break;
            }
            case 9: {
                result = session.getLogName();
                break;
            }
            case 10: {
                result = session.getLogType();
                break;
            }
            case 11: {
                if (session.getEngineHost() != null) {
                    result = session.getEngineHost();
                }
                if (session.getEnginePort() == null) break;
                result = (String)result + ":" + String.valueOf(session.getEnginePort());
                break;
            }
            case 12: {
                if (session.getGuestHost() == null) break;
                result = session.getGuestHost();
                break;
            }
            case 7: {
                if (session.getLaunchMode() == null) break;
                result = session.getLaunchMode();
                break;
            }
            case 13: {
                if (session.getExecutionMode() == null) break;
                result = session.getExecutionMode();
                break;
            }
            case 5: {
                if (session.getConfiguration() == null) break;
                result = session.getConfiguration();
                break;
            }
            case 8: {
                if (session.getIter() <= 1) break;
                result = "" + (session.getIter() - 1);
                break;
            }
            case 14: {
                if (session.getLaunchUser() == null) break;
                result = session.getLaunchUser();
                break;
            }
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 2) {
            ISessionDataExchange session = (ISessionDataExchange)element;
            return Functions.getImageSessionStatus(session.getStatus());
        }
        return null;
    }
}

