/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom;

import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.Util;
import com.stambia.md.custom.exception.ReverseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleException;

public class ReverseUtil {
    public static List<String> getChildren(String code, MdNode node, Object connection, String parentName, String filter, String ... typesFilter) throws ReverseException {
        MdReverse reverse = ReverseUtil.retrieveMethod(node);
        reverse.setConnection(connection);
        return reverse.getChildren(code, parentName, filter, typesFilter);
    }

    public static List<MdNode> getMdNodeChildren(String code, MdNode node, Object connection, String parentName, String filter, String ... typesFilter) throws ReverseException {
        MdReverse reverse = ReverseUtil.retrieveMethod(node);
        reverse.setConnection(connection);
        return reverse.getMdNodeChildren(code, parentName, filter, typesFilter);
    }

    public static MdReverse retrieveMethod(MdNode mdParent) {
        MdReverse reverse = null;
        try {
            reverse = mdParent.getLevel().getReverseBundleName() != null && !mdParent.getLevel().getReverseBundleName().equals("") ? (MdReverse)Util.retrieveMethod(mdParent.getLevel().getReverseClass(), mdParent.getLevel().getReverseBundleName(), new Util.ParameterWrapper[0]) : (MdReverse)Util.retrieveMethod(mdParent.getLevel().getReverseClass(), null, new Util.ParameterWrapper[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
        reverse.setNode(mdParent);
        String conf = ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName();
        reverse.setConf(conf);
        return reverse;
    }

    public static void incrementalReverse(MdNode mdParent, MdReverse reverseMethod, Object connection, Object[] elements, Map<String, Boolean> incrementalDelete, Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseMode) throws ReverseException {
        reverseMethod.setConnection(connection);
        List<MdNode> toReverse = null;
        AttributeRefResolver attributeRefResolver = null;
        if (elements != null && elements.length > 0) {
            toReverse = reverseMethod.doReverse(elements);
            attributeRefResolver = reverseMethod.getAttributeRefResolver();
            HashMap<MdNode, MdNode> map = new HashMap<MdNode, MdNode>();
            int i = 0;
            while (i < elements.length) {
                MdNode newNode = toReverse.get(i);
                MdNode currentNode = mdParent.getNodeByName(newNode.getDefType(), newNode.getName());
                map.put(newNode, currentNode);
                ++i;
            }
            for (MdNode n : toReverse) {
                if (map.keySet().contains(n)) continue;
                map.put(n, null);
            }
            IncrementalReverser ir = new IncrementalReverser(mdParent, map, Collections.EMPTY_LIST, true, attributeRefResolver, incrementalDelete, IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseMode, false);
            ir.reverse();
        }
    }

    public static List<MdNode> doReverse(MdReverse reverseMethod, Object connection, Object[] elements) throws ReverseException {
        reverseMethod.setConnection(connection);
        List<MdNode> toReverse = new ArrayList<MdNode>();
        if (elements != null && elements.length > 0) {
            toReverse = reverseMethod.doReverse(elements);
        }
        return toReverse;
    }
}

