/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom.xpath;

import com.semarchy.xdi.designer.core.models.IWithDisposable;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.IElement;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.MdRootNode;
import com.stambia.md.custom.xpath.MdDocumentWrapper;
import com.stambia.md.custom.xpath.Messages;
import com.stambia.md.impl.custom.DocumentRootHelper;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.StbMdResourceImpl;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.Tech;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.jdom.NodeWrapper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class MdNodeWrapper2
extends NodeWrapper
implements IEvaluationConfigurationService.IConfigurationChangeListener,
IWithDisposable.IDisposable {
    public static final Namespace techNamespace = Namespace.getNamespace((String)"tech", (String)"http://www.stambia.com/tech");
    public static boolean useConf = true;
    private static MdAttributeNativeEvaluator.IExceptionHandler errorHandler = new MdAttributeNativeEvaluator.IExceptionHandler(){

        @Override
        public void handleException(Throwable t) {
            t.printStackTrace();
        }
    };
    private List<org.jdom.Attribute> defaultAttribute = new ArrayList<org.jdom.Attribute>();
    private EContentAdapter defaultAttributeListener = null;
    private boolean recomputeDefaultAttributes = true;

    public Object getNode() {
        return this.node;
    }

    public void setDocumentWrapper(DocumentWrapper docWrapper) {
        this.docWrapper = docWrapper;
    }

    public MdNodeWrapper2(Object node, NodeWrapper parent, int index) {
        super(node, parent, index);
        if (node instanceof IElement && node instanceof EObject && ((EObject)node).eResource() instanceof IWithDisposable) {
            ((IWithDisposable)((EObject)node).eResource()).addDisposable((IWithDisposable.IDisposable)this);
        }
        if (node instanceof MdNode) {
            this.nodeKind = 1;
        } else if (node instanceof Attribute) {
            this.nodeKind = (short)2;
        } else if (node instanceof EAttribute) {
            this.nodeKind = (short)2;
        } else if (node instanceof org.jdom.Attribute) {
            this.nodeKind = (short)2;
        } else if (node instanceof DocumentRoot) {
            this.nodeKind = (short)9;
        } else if (node instanceof RefWrapper) {
            this.nodeKind = 1;
            if (((RefWrapper)((Object)node)).referencedMdNode.eResource() instanceof IWithDisposable) {
                ((IWithDisposable)((RefWrapper)((Object)node)).referencedMdNode.eResource()).addDisposable((IWithDisposable.IDisposable)this);
            }
        }
    }

    public static void useConf(boolean _useConf) {
        useConf = _useConf;
    }

    public void dispose() {
        IEvaluationConfigurationService s;
        if (this.node instanceof MdNode && this.defaultAttributeListener != null) {
            ((MdNode)this.node).eAdapters().remove((Object)this.defaultAttributeListener);
        }
        if (this.node != null && (s = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)) != null) {
            s.removeListener((IEvaluationConfigurationService.IConfigurationChangeListener)this);
        }
        if (this.docWrapper != null && this.docWrapper instanceof MdDocumentWrapper) {
            ((MdDocumentWrapper)this.docWrapper).dispose();
        }
        this.docWrapper = null;
    }

    private void initDefaultAttributes() {
        ((MdNode)this.node).eAdapters().remove((Object)this.defaultAttributeListener);
        ArrayList<org.jdom.Attribute> l = new ArrayList<org.jdom.Attribute>();
        String name = ((MdNode)this.node).getName();
        BigInteger position = ((MdNode)this.node).getPosition();
        String id = ((MdNode)this.node).getId();
        String defType = ((MdNode)this.node).getDefType();
        if (name != null) {
            l.add(new org.jdom.Attribute("name", name, null));
        }
        if (id != null) {
            l.add(new org.jdom.Attribute("id", id, null));
        }
        if (position != null) {
            l.add(new org.jdom.Attribute("position", position.toString(), null));
        }
        if (defType != null) {
            l.add(new org.jdom.Attribute("defType", defType, null));
        }
        final HashSet<CallSite> defaultAttributeDefTypes = new HashSet<CallSite>();
        Level lvl = ((MdNode)this.node).getLevel();
        if (lvl != null) {
            for (Property p : lvl.getAttribute()) {
                Attribute att = ((MdNode)this.node).getAttributeByShortCode(p.getCode());
                if (att != null && att.getValue() != null && !att.getValue().isEmpty()) continue;
                defaultAttributeDefTypes.add((CallSite)((Object)(((MdNode)this.node).getDefType() + "." + p.getCode())));
                if (!p.supportDefaultValue()) continue;
                try {
                    String evaluatedValue = MdAttributeReader.evaluateDefaultValue(p.getCode(), (MdNode)this.node, useConf ? ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName() : null);
                    if (evaluatedValue == null || evaluatedValue.isEmpty()) continue;
                    l.add(new org.jdom.Attribute(p.getXmlName(), evaluatedValue));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.defaultAttribute = l;
        this.defaultAttributeListener = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getEventType() == 9) {
                    return;
                }
                boolean mustReinitDefaultAttributes = false;
                if (notification.getFeature() == MdPackage.eINSTANCE.getElement_Id() || notification.getFeature() == MdPackage.eINSTANCE.getElement_DefType() || notification.getFeature() == MdPackage.eINSTANCE.getElement_Name() || notification.getFeature() == MdPackage.eINSTANCE.getElement_Position()) {
                    mustReinitDefaultAttributes = true;
                } else if (notification.getNotifier() == MdPackage.eINSTANCE.getAttribute()) {
                    if (defaultAttributeDefTypes.contains(((Attribute)notification.getNotifier()).getDefType())) {
                        mustReinitDefaultAttributes = true;
                    }
                } else if (notification.getFeature() == MdPackage.eINSTANCE.getConfiguration_Attribute()) {
                    if (notification.getOldValue() instanceof Attribute && defaultAttributeDefTypes.contains(((Attribute)notification.getOldValue()).getDefType())) {
                        mustReinitDefaultAttributes = true;
                    }
                    if (notification.getNewValue() instanceof Attribute && defaultAttributeDefTypes.contains(((Attribute)notification.getNewValue()).getDefType())) {
                        mustReinitDefaultAttributes = true;
                    }
                }
                if (mustReinitDefaultAttributes) {
                    MdNodeWrapper2.this.recomputeDefaultAttributes = true;
                }
            }
        };
        ((MdNode)this.node).eAdapters().add((Object)this.defaultAttributeListener);
        IEvaluationConfigurationService service = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class);
        if (service != null) {
            service.addListener((IEvaluationConfigurationService.IConfigurationChangeListener)this);
        }
        this.recomputeDefaultAttributes = false;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    private static void expandStringValue(List list, FastStringBuffer sb) {
        for (Object obj : list) {
            if (obj instanceof Element) {
                sb.append(((Element)obj).getValue());
                continue;
            }
            if (obj instanceof Text) {
                sb.append(((Text)obj).getText());
                continue;
            }
            if (obj instanceof EntityRef) {
                throw new IllegalStateException(Messages.MdNodeWrapper2_unexpandedJdomNode);
            }
            if (!(obj instanceof DocType)) {
                throw new AssertionError((Object)Messages.MdNodeWrapper2_6);
            }
        }
    }

    private static String getStringValue(Object node) {
        String res = null;
        if (node instanceof Document) {
            List children1 = ((Document)node).getContent();
            FastStringBuffer sb1 = new FastStringBuffer(2048);
            MdNodeWrapper2.expandStringValue(children1, sb1);
            res = sb1.toString();
        } else {
            if (node instanceof MdNode) {
                return null;
            }
            res = node instanceof Attribute ? ((Attribute)node).getStringValue() : (node instanceof EAttribute ? ((EAttribute)node).toString() : (node instanceof org.jdom.Attribute ? ((org.jdom.Attribute)node).getValue() : (node instanceof Text ? ((Text)node).getText() : (node instanceof String ? (String)node : (node instanceof Comment ? ((Comment)node).getText() : (node instanceof ProcessingInstruction ? ((ProcessingInstruction)node).getData() : (node instanceof Namespace ? ((Namespace)node).getURI() : "")))))));
        }
        Configuration n = null;
        if (node instanceof Attribute) {
            n = (Configuration)((Attribute)node).eContainer();
        } else if (node instanceof EAttribute) {
            n = (Configuration)((EAttribute)node).eContainer();
        }
        if (n != null && !(n instanceof MdNode)) {
            n = (MdNode)n.eContainer();
        }
        if (n != null) {
            try {
                res = MdAttributeNativeEvaluator.evaluate(res, n, errorHandler);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return res;
    }

    public CharSequence getStringValueCS() {
        if (this.node instanceof List) {
            List nodes = (List)this.node;
            FastStringBuffer fsb = new FastStringBuffer(100);
            int i = 0;
            while (i < nodes.size()) {
                Text o = (Text)nodes.get(i);
                fsb.append(MdNodeWrapper2.getStringValue(o));
                ++i;
            }
            return fsb;
        }
        return MdNodeWrapper2.getStringValue(this.node);
    }

    public String getAttributeValue(int fingerprint) {
        return super.getAttributeValue(fingerprint);
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((MdNode)this.node).getLevel().getXmlName();
            }
            case 2: {
                if (this.node instanceof Attribute) {
                    return ((Attribute)this.node).getTechProperty().getXmlName();
                }
                if (this.node instanceof org.jdom.Attribute) {
                    return ((org.jdom.Attribute)this.node).getQualifiedName();
                }
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                if (((MdNode)this.node).getLevel() != null) {
                    return ((MdNode)this.node).getLevel().getXmlName();
                }
            }
            case 2: {
                if (this.node instanceof Attribute) {
                    if (((Attribute)this.node).getTechProperty() == null) return "";
                    return ((Attribute)this.node).getTechProperty().getXmlName();
                }
                if (!(this.node instanceof org.jdom.Attribute)) return "";
                return ((org.jdom.Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    public int getNameCode() {
        return super.getNameCode();
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return "";
            }
            case 2: {
                if (this.node instanceof org.jdom.Attribute) {
                    return ((org.jdom.Attribute)this.node).getNamespacePrefix();
                }
                return "";
            }
        }
        return "";
    }

    public int getSiblingPosition() {
        return super.getSiblingPosition();
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return "";
            }
            case 2: {
                if (this.node instanceof org.jdom.Attribute) {
                    return ((org.jdom.Attribute)this.node).getNamespaceURI();
                }
                return "";
            }
        }
        return "";
    }

    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                boolean b = !((MdNode)this.node).getNode().isEmpty() || !((MdNode)this.node).getAttribute().isEmpty();
                return b;
            }
        }
        return false;
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new MdAttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new MdChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new MdChildEnumeration(this, false, true), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new MdChildEnumeration(this, false, false), nodeTest);
            }
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper, NodeWrapper parent, int index) {
        MdNodeWrapper2 wrapper = null;
        if (node instanceof Document) {
            return docWrapper;
        }
        if (node instanceof MdNode) {
            wrapper = (MdNodeWrapper2)((MdNode)node).getNodeWrapper();
        } else if (node instanceof Attribute) {
            wrapper = (MdNodeWrapper2)((Attribute)node).getNodeWrapper();
        } else if (node instanceof org.jdom.Attribute) {
            wrapper = new MdNodeWrapper2(node, parent, index);
        }
        if (wrapper != null) {
            wrapper.docWrapper = docWrapper;
            return wrapper;
        }
        return super.makeWrapper(node, docWrapper, parent, index);
    }

    public NodeInfo getParent() {
        NodeInfo ni = this._getParent();
        if (ni instanceof MdNodeWrapper2) {
            ((MdNodeWrapper2)ni).setDocumentWrapper(this.docWrapper);
        }
        return ni;
    }

    public NodeInfo _getParent() {
        if (this.node instanceof MdNode) {
            EObject _parent;
            MdNode mdNode = (MdNode)this.node;
            if (mdNode.isSubMetaDataChildFile()) {
                mdNode = (MdNode)mdNode.getRef();
            }
            EObject eObject = _parent = mdNode.getSubstituteContainer() != null ? mdNode.getSubstituteContainer() : mdNode.eContainer();
            if (_parent == null) {
                _parent = mdNode.getSubstituteContainer();
            }
            if (_parent instanceof MdNode) {
                return ((MdNode)_parent).getNodeWrapper();
            }
            if (mdNode instanceof MdNode && _parent instanceof DocumentRoot) {
                MdNode previous = ((MdDocumentWrapper)this.docWrapper).getMdNodeParent(mdNode);
                if (previous != null) {
                    return previous.getNodeWrapper();
                }
                if (mdNode.getRef() instanceof MdNode) {
                    return ((MdNode)mdNode.getRef()).getNodeWrapper();
                }
                return this.docWrapper;
            }
        } else if (this.node instanceof Attribute) {
            return ((MdNode)((Attribute)this.node).eContainer()).getNodeWrapper();
        }
        return super.getParent();
    }

    public static MdNode foundPreviousMd(Tech tech) {
        if (tech.getRef() instanceof Tech) {
            return MdNodeWrapper2.foundPreviousMd((Tech)tech.getRef());
        }
        if (tech.getRef() instanceof MdNode) {
            return (MdNode)tech.getRef();
        }
        return null;
    }

    public Optional<MdDocumentWrapper> setDocumentWrapper(Configuration node) {
        Resource r;
        MdDocumentWrapper res = null;
        Resource resource = r = node.eResource() == null || !(node.eResource() instanceof StbMdResourceImpl) ? node.getSubstituteResource() : node.eResource();
        if (r != null && "map".equals(r.getURI().fileExtension()) && node.getSubstituteResource() != null) {
            r = node.getSubstituteResource();
        }
        if (r != null && r.getContents().size() > 0 && r.getContents().get(0) != null) {
            if (this.docWrapper instanceof MdDocumentWrapper) {
                ((MdDocumentWrapper)this.docWrapper).dispose();
            }
            res = DocumentRootHelper.getNewDocumentWrapper((DocumentRoot)r.getContents().get(0));
            this.docWrapper = res;
        }
        Optional<Object> q = Optional.ofNullable(res);
        return q;
    }

    public void configurationChanged(String oldCnfName, String newCnfName) {
        this.recomputeDefaultAttributes = true;
    }

    final class MdAttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts0;
        private Iterator atts1;
        private Iterator atts2;
        private int ix = 0;
        private MdNodeWrapper2 start;
        private Level level;

        public MdAttributeEnumeration(MdNodeWrapper2 start) {
            this.start = start;
            this.level = ((MdNode)start.node).getLevel();
            if (MdNodeWrapper2.this.recomputeDefaultAttributes) {
                MdNodeWrapper2.this.initDefaultAttributes();
            }
            this.atts0 = start.defaultAttribute.iterator();
            String strConf = useConf ? ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName() : null;
            this.atts1 = ((MdNode)start.node).getAttribute(strConf).iterator();
            this.atts2 = this.level.eClass().getEAllAttributes().iterator();
        }

        public void advance() {
            if (this.atts0.hasNext()) {
                this.current = MdNodeWrapper2.this.makeWrapper(this.atts0.next(), MdNodeWrapper2.this.docWrapper, this.start, this.ix++);
            } else if (this.atts1.hasNext()) {
                Attribute attr = (Attribute)this.atts1.next();
                this.current = attr.getValues() != null && attr.getValues().size() > 0 ? null : (attr.getValueEntry() != null && attr.getValueEntry().size() > 0 ? null : (attr.getTechProperty() != null ? MdNodeWrapper2.this.makeWrapper(attr, MdNodeWrapper2.this.docWrapper, this.start, this.ix++) : null));
            } else if (this.atts2.hasNext()) {
                EAttribute attr = (EAttribute)this.atts2.next();
                Object obj = this.level.eGet((EStructuralFeature)attr);
                if (obj != null) {
                    org.jdom.Attribute _attr = new org.jdom.Attribute(attr.getName(), obj.toString(), techNamespace);
                    this.current = MdNodeWrapper2.this.makeWrapper(_attr, MdNodeWrapper2.this.docWrapper, this.start, this.ix++);
                } else {
                    this.current = null;
                }
            } else {
                this.current = null;
            }
            if (this.current == null && (this.atts0.hasNext() || this.atts1.hasNext() || this.atts2.hasNext())) {
                this.advance();
            }
        }

        public SequenceIterator getAnother() {
            return new MdAttributeEnumeration(this.start);
        }
    }

    private final class MdChildEnumeration
    extends Navigator.BaseEnumeration {
        private MdNodeWrapper2 start;
        private MdNodeWrapper2 commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public MdChildEnumeration(MdNodeWrapper2 start, boolean downwards, boolean forwards) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            this.commonParent = downwards ? start : (MdNodeWrapper2)start.getParent();
            if (this.commonParent.getNodeKind() == 9) {
                ArrayList<MdRootNode> list = new ArrayList<MdRootNode>();
                list.add(((DocumentRoot)this.commonParent.node).getNode());
                this.children = list.listIterator();
            } else {
                MdNode _node = (MdNode)this.commonParent.node;
                MdDocumentWrapper doc = (MdDocumentWrapper)MdNodeWrapper2.this.docWrapper;
                MdNode child = doc.getMdNodeChild(_node);
                ArrayList<MdNode> list = new ArrayList<MdNode>();
                list.addAll((Collection<MdNode>)((MdNode)this.commonParent.node).getNode());
                if (child != null) {
                    list.add(child);
                }
                String strConf = useConf ? ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName() : null;
                ArrayList<Element> nodeFromAttributes = new ArrayList<Element>();
                for (Attribute attr : ((MdNode)MdNodeWrapper2.this.node).getAttribute(strConf)) {
                    Element elt;
                    if (attr.getTechProperty() == null) continue;
                    if (attr.getValues() != null && attr.getValues().size() > 0) {
                        for (String value : attr.getValues()) {
                            elt = new Element(attr.getTechProperty().getXmlName());
                            elt.setText(value);
                            nodeFromAttributes.add(elt);
                        }
                        continue;
                    }
                    if (attr.getValueEntry() != null && attr.getValueEntry().size() > 0) {
                        for (String key : attr.getValueEntry().keySet()) {
                            elt = new Element(attr.getTechProperty().getXmlName());
                            elt.setText((String)attr.getValueEntry().get((Object)key));
                            elt.setAttribute("key", key);
                            nodeFromAttributes.add(elt);
                        }
                        continue;
                    }
                    if (attr.getRefs() == null || attr.getRefs().size() <= 0) continue;
                    for (String value : attr.getRefs()) {
                        RefWrapper w = new RefWrapper(attr.getTechProperty().getXmlName());
                        w.referencedMdNode = (MdNode)((Object)value);
                        w.setText(value.eResource().getURIFragment((EObject)value));
                        nodeFromAttributes.add(w);
                    }
                }
                list.addAll(nodeFromAttributes);
                this.children = list.listIterator();
            }
            if (downwards) {
                if (!forwards) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = start.getSiblingPosition();
                Object n = null;
                if (forwards) {
                    int i = 0;
                    while (i <= this.ix) {
                        n = this.children.next();
                        ++i;
                    }
                    if (n instanceof Text) {
                        boolean atEnd = false;
                        while (n instanceof Text) {
                            if (this.children.hasNext()) {
                                n = this.children.next();
                                ++this.ix;
                                continue;
                            }
                            atEnd = true;
                            break;
                        }
                        if (!atEnd) {
                            this.children.previous();
                        }
                    } else {
                        ++this.ix;
                    }
                } else {
                    int i = 0;
                    while (i < this.ix) {
                        this.children.next();
                        ++i;
                    }
                    --this.ix;
                }
            }
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object nextChild = this.children.next();
                    if (nextChild instanceof DocType) {
                        this.advance();
                        return;
                    }
                    if (nextChild instanceof EntityRef) {
                        throw new IllegalStateException(Messages.MdNodeWrapper2_unexpandedJdomNode);
                    }
                    if (nextChild instanceof Text) {
                        this.current = MdNodeWrapper2.this.makeWrapper(nextChild, MdNodeWrapper2.this.docWrapper, this.commonParent, this.ix++);
                        ArrayList<Object> list = null;
                        while (this.children.hasNext()) {
                            Object n = this.children.next();
                            if (n instanceof Text) {
                                if (list == null) {
                                    list = new ArrayList<Object>(4);
                                    list.add(((MdNodeWrapper2)this.current).node);
                                }
                                list.add(n);
                                ++this.ix;
                                continue;
                            }
                            this.children.previous();
                            break;
                        }
                        if (list != null) {
                            ((MdNodeWrapper2)this.current).node = list;
                        }
                    } else {
                        this.current = MdNodeWrapper2.this.makeWrapper(nextChild, MdNodeWrapper2.this.docWrapper, this.commonParent, this.ix++);
                    }
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object nextChild = this.children.previous();
                if (nextChild instanceof DocType) {
                    this.advance();
                    return;
                }
                if (nextChild instanceof EntityRef) {
                    throw new IllegalStateException(Messages.MdNodeWrapper2_unexpandedJdomNode);
                }
                if (nextChild instanceof Text) {
                    this.current = MdNodeWrapper2.this.makeWrapper(nextChild, MdNodeWrapper2.this.docWrapper, this.commonParent, this.ix--);
                    ArrayList<Object> list = null;
                    while (this.children.hasPrevious()) {
                        Object n = this.children.previous();
                        if (n instanceof Text) {
                            if (list == null) {
                                list = new ArrayList<Object>(4);
                                list.add(((MdNodeWrapper2)this.current).node);
                            }
                            list.add(0, n);
                            --this.ix;
                            continue;
                        }
                        this.children.next();
                        break;
                    }
                    if (list != null) {
                        ((MdNodeWrapper2)this.current).node = list;
                    }
                } else {
                    this.current = MdNodeWrapper2.this.makeWrapper(nextChild, MdNodeWrapper2.this.docWrapper, this.commonParent, this.ix--);
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new MdChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    public class RefWrapper
    extends Element {
        MdNode referencedMdNode;

        public RefWrapper(String name) {
            super(name);
        }

        public NodeWrapper getNodeWrapper() {
            return this.referencedMdNode.getNodeWrapper();
        }
    }
}

