/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class EObjectMerger {
    private MergeRules mergeRules;
    public static final int COPY_MODE = 0;
    public static final int REPLACE_MODE = 1;
    public static final int MERGE_MODE = 2;

    public static EObject merge(EObject eObject1, EObject eObject2, MergeRules mergeRules) {
        EObjectMerger merger = new EObjectMerger();
        if (mergeRules != null) {
            merger.setMergeRules(mergeRules);
        }
        return merger.mergeD(eObject1, eObject2);
    }

    public void setMergeRules(MergeRules mergeRules) {
        this.mergeRules = mergeRules;
    }

    private EObject mergeD(EObject eObject1, EObject eObject2) {
        EClass eClass = eObject1.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                if (eStructuralFeature instanceof EAttribute) {
                    this.mergeAttribute((EAttribute)eStructuralFeature, eObject1, eObject2);
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment()) {
                        this.mergeContainment(eReference, eObject1, eObject2);
                    }
                }
            }
            ++i;
        }
        return eObject1;
    }

    protected void mergeContainment(EReference eReference, EObject eObject1, EObject eObject2) {
        if (eObject2.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                List target = (List)eObject1.eGet((EStructuralFeature)eReference);
                List source = (List)eObject2.eGet(this.getTarget((EStructuralFeature)eReference));
                if (!source.isEmpty()) {
                    ArrayList tagetCopy = new ArrayList(target);
                    for (EObject eo2 : source) {
                        int mode = 0;
                        EObject merge = null;
                        if (this.mergeRules != null) {
                            for (EObject eo1 : tagetCopy) {
                                mode = this.mergeRules.mode(eo1, eo2);
                                if (mode == 2) {
                                    merge = eo1;
                                }
                                if (mode == 1 || mode == 2) break;
                            }
                        }
                        if (mode == 0) {
                            eObject1.eSetDeliver(false);
                            target.add(EcoreUtil.copy((EObject)eo2));
                            eObject1.eSetDeliver(true);
                            continue;
                        }
                        if (mode != 2) continue;
                        EObjectMerger.merge(merge, eo2, this.mergeRules);
                    }
                }
            } else {
                EObject childEObject = (EObject)eObject1.eGet((EStructuralFeature)eReference);
                EObject childEObject2 = (EObject)eObject2.eGet((EStructuralFeature)eReference);
                if (childEObject == null && childEObject2 != null) {
                    eObject1.eSetDeliver(false);
                    eObject1.eSet(this.getTarget((EStructuralFeature)eReference), (Object)(childEObject == null ? null : EcoreUtil.copy((EObject)childEObject2)));
                    eObject1.eSetDeliver(true);
                }
            }
        }
    }

    protected void mergeAttribute(EAttribute eAttribute, EObject eObject1, EObject eObject2) {
        if (eObject2.eIsSet((EStructuralFeature)eAttribute) && !FeatureMapUtil.isFeatureMap((EStructuralFeature)eAttribute)) {
            if (eAttribute.isMany()) {
                List source = (List)eObject2.eGet((EStructuralFeature)eAttribute);
                List target = (List)eObject1.eGet(this.getTarget((EStructuralFeature)eAttribute));
                if (!source.isEmpty()) {
                    eObject1.eSetDeliver(false);
                    target.addAll(source);
                    eObject1.eSetDeliver(true);
                }
            } else {
                Object obj = eObject1.eGet(this.getTarget((EStructuralFeature)eAttribute));
                if (!eObject1.eIsSet((EStructuralFeature)eAttribute) || "".equals(obj)) {
                    eObject1.eSetDeliver(false);
                    eObject1.eSet(this.getTarget((EStructuralFeature)eAttribute), eObject2.eGet((EStructuralFeature)eAttribute));
                    eObject1.eSetDeliver(true);
                }
            }
        }
    }

    private EClass getTarget(EClass eClass) {
        return eClass;
    }

    protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature;
    }

    public static interface MergeRules {
        public int mode(EObject var1, EObject var2);
    }
}

