/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.FileDriverGenericStatement;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.parser.MetadataValueObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;

public class FileDriverPreparedStatement
extends FileDriverGenericStatement
implements PreparedStatement {
    protected MetadataServer.MetadataFileAndEnreg statementMetadataFile = null;
    protected ArrayList<String[]> valuesBuffer = null;
    public static String xmlDefPattern = "(%com.stambia.jdbc.driver.file.md\\{)([^\\e]*)(\\}com.stambia.jdbc.driver.file.md%)";

    public FileDriverPreparedStatement(FileDriverConnection connection) {
        this.connection = connection;
    }

    protected void constructInitRow() {
        int i = 0;
        while (i < this.statementLstValues.length) {
            MetadataValueObject o = this.statementLstValues[i];
            if (o.getValueType() == 1) {
                this.initRow[i] = o.getValue();
            }
            ++i;
        }
    }

    protected void initCurrentRow() {
        int i = 0;
        while (i < this.currentRow.length) {
            this.currentRow[i] = this.initRow[i];
            ++i;
        }
    }

    public static String getXmlPart(String sql) throws UnsupportedEncodingException {
        Pattern patt = Pattern.compile(xmlDefPattern);
        Matcher m1 = patt.matcher(sql);
        if (m1.find()) {
            String query = m1.group(2);
            return query;
        }
        return null;
    }

    public void prepareSQL(String sql, Insert st, MetadataServer metServ, MetadataServer.MetadataFileAndEnreg statementMetadataFile) throws SQLException {
        block10: {
            try {
                this.statementMetadataServer = metServ;
                this.statementMetadataFile = statementMetadataFile;
                if (st instanceof Insert) {
                    if (statementMetadataFile.getMetadataFile().getType() == 0) {
                        this.setVerifyLength("false");
                        this.headerFieldSeparator = statementMetadataFile.getMetadataFile().getFieldSeparator();
                    }
                    this.findOptionsInSQL(sql);
                    this.nbLineColumns = statementMetadataFile.getMetadataEnreg().getLstColumns().length;
                    this.nbStatementColumns = this.getInsertStatementNbColumns((Statement)st);
                    this.currentRow = new String[this.nbLineColumns];
                    this.initRow = new String[this.nbLineColumns];
                    this.statementLstValues = FileDriverPreparedStatement.getLstValues((Statement)st);
                    this.lstColumns = statementMetadataFile.getMetadataEnreg().getLstColumns();
                    this.lstInsertColumnMetadata = this.constructStatementColumnIndex((Statement)st, statementMetadataFile.getMetadataEnreg());
                    this.indexColumnToMetadataIndex = new int[this.lstColumns.length];
                    int i = 0;
                    while (i < this.lstColumns.length) {
                        IMetadataColumn col = this.lstColumns[i];
                        this.indexColumnToMetadataIndex[i] = -1;
                        int j = 0;
                        while (j < this.lstInsertColumnMetadata.length) {
                            if (this.lstInsertColumnMetadata[j] == col) {
                                this.indexColumnToMetadataIndex[i] = j;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.constructInitRow();
                    this.initCurrentRow();
                    this.valuesBuffer = new ArrayList();
                    this.init(statementMetadataFile);
                    boolean exists = new File(this.filePath).exists();
                    this.lineSeparatorBeforeStr = this.lineSeparatorBefore && exists ? statementMetadataFile.getMetadataFile().getLineSeparator() : "";
                    this.lineSeparatorAfterStr = this.lineSeparatorAfter ? statementMetadataFile.getMetadataFile().getLineSeparator() : "";
                    if (this.generateHeader == 1 || this.generateHeader == 2 && !exists) {
                        this.generateHeader(statementMetadataFile);
                    }
                    break block10;
                }
                this.connection.log("FileDriverStatement::executeQuery, this is not an insert statement");
                throw new SQLException(Messages.getString("FileDriverPreparedStatement.0"));
            }
            catch (Exception e) {
                if (statementMetadataFile != null) {
                    this.connection.log(Messages.getString("FileDriverPreparedStatement.1") + statementMetadataFile.getMetadataFile().getFather().getPath() + File.separator + statementMetadataFile.getMetadataFile().getPhysicalName());
                    this.connection.log(FileDriver.getStackTrace(e));
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.2") + statementMetadataFile.getMetadataFile().getFather().getPath() + File.separator + statementMetadataFile.getMetadataFile().getPhysicalName(), e);
                }
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(e);
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.valuesBuffer.add(this.currentRow);
        this.currentRow = new String[this.nbLineColumns];
        this.initCurrentRow();
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.valuesBuffer.size() == 0) {
            this.addBatch();
            this.executeBatch();
            return true;
        }
        throw new SQLException(Messages.getString("FileDriverPreparedStatement.3"));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 1;
        }
        return 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        if (arg0 < 1 || arg0 > this.statementColumnIndex.length) return;
        IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
        if (metCol.getType() == 2 || metCol.getType() == 3) {
            String s = arg1 != null ? metCol.getDecimalFormat().format(arg1) : "";
            if (s.length() > metCol.getPhysicalSize() && this.verifyLength != FileDriverGenericStatement.VerifyLength._false) throw new SQLException(Messages.getString("FileDriverPreparedStatement.4") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.5") + metCol.getPhysicalSize());
            this.currentRow[arg0 - 1] = s;
            return;
        }
        try {
            this.setString(arg0, arg1 != null ? arg1.toString() : null);
            return;
        }
        catch (SQLException e) {
            throw new SQLException(Messages.getString("FileDriverPreparedStatement.6") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.7"), e);
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        if (arg0 < 1 || arg0 > this.statementColumnIndex.length) return;
        IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
        if (metCol.getType() != 16) throw new SQLException(Messages.getString("FileDriverPreparedStatement.10") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.11"));
        String s = Boolean.toString(arg1);
        if (s.length() > metCol.getPhysicalSize()) throw new SQLException(Messages.getString("FileDriverPreparedStatement.8") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.9") + metCol.getPhysicalSize());
        this.currentRow[arg0 - 1] = s;
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            if (metCol.getType() == -7) {
                this.currentRow[arg0 - 1] = Byte.toString(arg1);
            } else {
                try {
                    this.setShort(arg0, arg1);
                }
                catch (SQLException e) {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.12") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.13"), e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        if (arg0 < 1 || arg0 > this.statementColumnIndex.length) return;
        IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
        if (metCol.getType() != -9 && metCol.getType() != -15 && metCol.getType() != 1 && metCol.getType() != 12 && metCol.getType() != -16 && metCol.getType() != -1) throw new SQLException(Messages.getString("FileDriverPreparedStatement.16") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.17"));
        String s = arg1 != null ? new String(arg1) : "";
        if (s.length() > metCol.getPhysicalSize()) throw new SQLException(Messages.getString("FileDriverPreparedStatement.14") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.15") + metCol.getPhysicalSize());
        this.currentRow[arg0 - 1] = s;
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        if (arg1 != null) {
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[1024];
            try {
                int charsRead;
                while ((charsRead = arg1.read(buffer)) != -1) {
                    sb.append(buffer, 0, charsRead);
                }
                this.setString(arg0, sb.toString());
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        if (arg1 != null) {
            this.setString(arg0, arg1.getSubString(1L, (int)arg1.length()));
        }
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        this.setCharacterStream(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        if (arg0 < 1 || arg0 > this.statementColumnIndex.length) throw new SQLException(arg0 + Messages.getString("FileDriverPreparedStatement.22"));
        IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
        if (metCol.getType() != 91) throw new SQLException(Messages.getString("FileDriverPreparedStatement.20") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.21"));
        metCol.getFormat();
        String s = arg1 != null ? metCol.getDateFormat().format(arg1) : "";
        if (s.length() > metCol.getPhysicalSize()) {
            throw new SQLException(Messages.getString("FileDriverPreparedStatement.18") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.19") + metCol.getPhysicalSize());
        }
        this.currentRow[arg0 - 1] = s;
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        this.setDate(arg0, arg1);
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            if (metCol.getType() == 8) {
                this.currentRow[arg0 - 1] = metCol.getDecimalFormat().format(arg1);
            } else {
                try {
                    this.setBigDecimal(arg0, BigDecimal.valueOf(arg1));
                }
                catch (SQLException e) {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.23") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.24"));
                }
            }
        }
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            if (metCol.getType() == 6) {
                this.currentRow[arg0 - 1] = metCol.getDecimalFormat().format(arg1);
            } else {
                try {
                    this.setDouble(arg0, arg1);
                }
                catch (SQLException e) {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.25") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.26"), e);
                }
            }
        }
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            if (metCol.getType() == 4) {
                this.currentRow[arg0 - 1] = String.valueOf(arg1);
            } else {
                try {
                    this.setLong(arg0, arg1);
                }
                catch (SQLException e) {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.27") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.28"), e);
                }
            }
        }
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            if (metCol.getType() == -5 || metCol.getType() == 12) {
                this.currentRow[arg0 - 1] = String.valueOf(arg1);
            } else {
                if (metCol.getType() == 2) {
                    try {
                        this.setBigDecimal(arg0, BigDecimal.valueOf(arg1));
                    }
                    catch (SQLException e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.29") + metCol.getName(), e);
                    }
                }
                try {
                    this.setFloat(arg0, arg1);
                }
                catch (SQLException e) {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.30") + metCol.getName(), e);
                }
            }
        }
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        if (arg1 != null) {
            this.setString(arg0, arg1.getSubString(1L, (int)arg1.length()));
        }
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        this.setCharacterStream(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        this.setString(arg0, arg1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        if (arg0 < 1 || arg0 > this.statementColumnIndex.length) return;
        IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
        if (metCol.getType() == -9 || metCol.getType() == -15 || metCol.getType() == 1 || metCol.getType() == 12 || metCol.getType() == -16 || metCol.getType() == -1) {
            String s = arg1;
            if (s == null) {
                this.currentRow[arg0 - 1] = s;
                return;
            } else if (s.length() <= metCol.getPhysicalSize() || this.verifyLength == FileDriverGenericStatement.VerifyLength._false) {
                this.currentRow[arg0 - 1] = s;
                return;
            } else if (this.verifyLength == FileDriverGenericStatement.VerifyLength.leftTruncation) {
                this.currentRow[arg0 - 1] = s.substring(s.length() - metCol.getPhysicalSize());
                return;
            } else {
                if (this.verifyLength != FileDriverGenericStatement.VerifyLength.rightTruncation) throw new SQLException(Messages.getString("FileDriverPreparedStatement.31") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.32") + metCol.getPhysicalSize());
                this.currentRow[arg0 - 1] = s.substring(0, metCol.getPhysicalSize());
            }
            return;
        } else {
            switch (metCol.getType()) {
                case -5: {
                    if (arg1 == null) return;
                    try {
                        this.setLong(arg0, Long.parseLong(arg1));
                        return;
                    }
                    catch (Exception e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.33") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.34") + arg1 + Messages.getString("FileDriverPreparedStatement.35"), e);
                    }
                }
                case 2: 
                case 3: {
                    if (arg1 == null) return;
                    try {
                        this.setBigDecimal(arg0, BigDecimal.valueOf(Double.parseDouble(arg1)));
                        return;
                    }
                    catch (Exception e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.36") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.37") + arg1 + Messages.getString("FileDriverPreparedStatement.38"), e);
                    }
                }
                case 8: {
                    if (arg1 == null) return;
                    try {
                        this.setDouble(arg0, Double.parseDouble(arg1));
                        return;
                    }
                    catch (Exception e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.39") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.40") + arg1 + Messages.getString("FileDriverPreparedStatement.41"), e);
                    }
                }
                case 6: 
                case 7: {
                    if (arg1 == null) return;
                    try {
                        this.setFloat(arg0, Float.parseFloat(arg1));
                        return;
                    }
                    catch (Exception e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.42") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.43") + arg1 + Messages.getString("FileDriverPreparedStatement.44"), e);
                    }
                }
                case 4: {
                    if (arg1 == null) return;
                    try {
                        this.setInt(arg0, Integer.parseInt(arg1));
                        return;
                    }
                    catch (Exception e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.45") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.46") + arg1 + Messages.getString("FileDriverPreparedStatement.47"), e);
                    }
                }
                case -6: 
                case 5: {
                    if (arg1 == null) return;
                    try {
                        this.setShort(arg0, Short.parseShort(arg1));
                        return;
                    }
                    catch (Exception e) {
                        throw new SQLException(Messages.getString("FileDriverPreparedStatement.48") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.49") + arg1 + Messages.getString("FileDriverPreparedStatement.50"), e);
                    }
                }
                default: {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.51") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.52") + arg1 + Messages.getString("FileDriverPreparedStatement.53"));
                }
            }
        }
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
    }

    @Override
    public void setObject(int arg0, Object arg1) throws SQLException {
        this.setString(arg0, arg1.toString());
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            String s = arg1 == null ? "" : arg1.toString();
            if (metCol.getType() == -8) {
                this.currentRow[arg0 - 1] = s;
            } else {
                throw new SQLException(Messages.getString("FileDriverPreparedStatement.54") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.55"));
            }
        }
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            if (metCol.getType() == -5) {
                this.currentRow[arg0 - 1] = String.valueOf(arg1);
            } else {
                try {
                    this.setInt(arg0, arg1);
                }
                catch (SQLException e) {
                    throw new SQLException(Messages.getString("FileDriverPreparedStatement.56") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.57"));
                }
            }
        }
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            String s = arg1 == null ? "" : arg1.toString();
            if (metCol.getType() == -5) {
                this.currentRow[arg0 - 1] = s;
            } else {
                throw new SQLException(Messages.getString("FileDriverPreparedStatement.58") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.59"));
            }
        }
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        this.setTime(arg0, arg1);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            IMetadataColumn metCol = this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
            String s = arg1 == null ? "" : metCol.getDateFormat().format(arg1);
            if (metCol.getType() == 91 || metCol.getType() == 93) {
                metCol.getFormat();
                this.currentRow[arg0 - 1] = s;
            } else {
                throw new SQLException(Messages.getString("FileDriverPreparedStatement.60") + metCol.getName() + Messages.getString("FileDriverPreparedStatement.61"));
            }
        }
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        this.setTimestamp(arg0, arg1);
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        this.valuesBuffer.add(this.currentRow);
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
        Iterator<String[]> it = this.valuesBuffer.iterator();
        String[] rows = null;
        while (it.hasNext()) {
            rows = it.next();
            if (rows == null) continue;
            int i = 0;
            while (i < rows.length) {
                String row = rows[i];
                if (row != null) {
                    row = null;
                }
                ++i;
            }
            rows = null;
        }
        this.valuesBuffer.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        this.clearBatch();
        this.initCurrentRow();
        this.closeFile();
        this.lstInsertColumnMetadata = null;
        this.statementLstValues = null;
        this.lstColumns = null;
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.hasWriteRow && !this.hasgeneratedHeader) {
            try {
                this.write(this.lineSeparatorBeforeStr);
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("FileDriverPreparedStatement.62"), e);
            }
        }
        Iterator<String[]> it = this.valuesBuffer.iterator();
        int last = this.valuesBuffer.size() - 1;
        int[] ret = new int[this.valuesBuffer.size()];
        if (this.statementMetadataFile.getMetadataFile().getType() == 0) {
            int i = 0;
            while (i <= last) {
                ret[i] = 1;
                this.writeDelimitedRow(it.next(), i, this.statementMetadataFile);
                ++i;
            }
        } else if (this.statementMetadataFile.getMetadataFile().getType() == 1) {
            int i = 0;
            while (i <= last) {
                ret[i] = 1;
                this.writePositionalRow(it.next(), i, this.statementMetadataFile.getMetadataFile());
                ++i;
            }
        }
        try {
            if (this.writerOutputStreamWriter != null) {
                this.writerOutputStreamWriter.flush();
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("FileDriverPreparedStatement.63"));
        }
        this.clearBatch();
        this.initCurrentRow();
        if (ret.length > 0) {
            this.hasWriteRow = true;
        }
        return ret;
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    public IMetadataColumn getColumn(int arg0) {
        if (arg0 >= 1 && arg0 <= this.statementColumnIndex.length) {
            return this.lstInsertColumnMetadata[this.statementColumnIndex[arg0 - 1]];
        }
        return null;
    }
}

