/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.parser;

import com.stambia.jdbc.driver.file.parser.MetadataStandardVisitor;
import com.stambia.jdbc.driver.file.parser.MetadataValueObject;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;

public class MetadataInsertValuesVisitor
extends MetadataStandardVisitor {
    private int nbParameters = 0;
    ArrayList<MetadataValueObject> lstValue = new ArrayList();
    SimpleDateFormat tf = new SimpleDateFormat("hh:mm:ss");

    public int getNbParameters() {
        return this.nbParameters;
    }

    public void setNbParameters(int nbParameters) {
        this.nbParameters = nbParameters;
    }

    public ArrayList<MetadataValueObject> getLstValue() {
        return this.lstValue;
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.lstValue.add(new MetadataValueObject(0, "", 0));
        ++this.nbParameters;
    }

    @Override
    public void visit(StringValue stringValue) {
        this.lstValue.add(new MetadataValueObject(1, stringValue.getValue(), 12));
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.lstValue.add(new MetadataValueObject(1, doubleValue.toString(), 8));
    }

    @Override
    public void visit(LongValue longValue) {
        this.lstValue.add(new MetadataValueObject(1, longValue.toString(), 4));
    }

    @Override
    public void visit(DateValue dateValue) {
        this.lstValue.add(new MetadataValueObject(1, dateValue.getValue().toString(), 91));
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.lstValue.add(new MetadataValueObject(1, timestampValue.getValue().toString(), 93));
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.lstValue.add(new MetadataValueObject(1, timeValue.getValue().toString(), 92));
    }

    public static void main(String[] args) throws JSQLParserException {
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        String sql = "insert into my_table (COL1) values (to_char(),{ts '2004-04-30 04:05:34.56'})";
        Statement st = parserManager.parse((Reader)new StringReader(sql));
        Insert ins = (Insert)st;
        MetadataInsertValuesVisitor mivv = new MetadataInsertValuesVisitor();
        ins.getItemsList().accept((ItemsListVisitor)mivv);
    }
}

