/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.resultset;

import com.stambia.jdbc.driver.InputStreamResultSet;
import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.FileDriverStatement;
import com.stambia.jdbc.driver.file.fileManagment.IInputStreamSet;
import com.stambia.jdbc.driver.file.fileManagment.ILineContext;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.IStambiaReader;
import com.stambia.jdbc.driver.file.fileManagment.StambiaBufferedReaderI;
import com.stambia.jdbc.driver.file.fileManagment.TransformInputStreamWithScript;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataEnreg;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilter;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileContentColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileNumberColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.InternalColumn;
import com.stambia.jdbc.driver.file.resultset.AbstractResultSet;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetColumn;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetMetaData;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetTable;
import com.stambia.jdbc.driver.file.resultset.Messages;
import com.stambia.jdbc.driver.file.resultset.MonoFileInputStreamSet;
import com.stambia.jdbc.driver.file.resultset.MultiFileInputStreamSet;
import com.stambia.jdbc.driver.file.tools.DelimitedLineParser;
import com.stambia.jdbc.driver.file.tools.Pointer;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDriverResultSet
extends AbstractResultSet
implements InputStreamResultSet {
    protected static final int DELIMITED_SEARCH_DEB = 1;
    protected static final int DELIMITED_SEARCH_END = 2;
    protected int fetchSize = 100;
    protected FileDriverConnection connection = null;
    protected FileDriverResultSetMetaData fResultSetMetadata;
    protected MetadataFile metadataFile;
    protected String[][] rowArrayValues = null;
    protected String[] currentRowValues = null;
    protected int[] rowPositions = null;
    int currentRowPosition;
    Boolean previousNull = false;
    protected FileDriverStatement statement;
    protected int isScrollable = 1003;
    Pointer<String> currentLine = new Pointer();
    protected int currentRowInFile;
    protected int currentRowInFetch;
    protected int currentResultSetSize;
    String readerCharSetName = "";
    int readerBufferSize = 8192;
    int lastRow = -10;
    int firstRowInFetch = -1;
    protected String tableName;
    private Writer fileWriter = null;
    private Writer rejectFileWriter = null;
    protected MetadataEnreg metadataEnreg;
    private final Logger logger = LogManager.getLogger((String)FileDriverResultSet.class.getName());
    private int recordErrorCount = 0;
    private int lastBadLinePosition = -1;
    private int fieldErrorCount = 0;
    private int lastBadLinePosition2 = -1;
    private int lastBadFieldPosition = -1;
    private FileDriver.FD_CODE_MSG lastErrorCode = null;
    private String lastFilename = null;
    IInputStreamSet input;
    boolean hasDatafield = false;
    boolean hasInternalField = false;
    boolean hasRawField = false;
    boolean skipLine = false;
    DelimitedLineParser fe;
    boolean needToPurgeBadFIles = true;
    boolean rawIsAlreadyReaded;
    boolean inputFirst = false;
    boolean hasNext = false;
    boolean multiSource = false;
    int readLineModeVersion = 1;

    private void writeCurrentRowInBadFile(int position) {
        this.writeBadLine(position);
    }

    private void writeBadLine(int position) {
        if (this.lastBadLinePosition != position) {
            block6: {
                try {
                    if (this.fileWriter == null) {
                        String tmp = this.getRejectRecordFilePath();
                        this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp, false), this.readerCharSetName), this.readerBufferSize);
                    }
                    if (this.recordErrorCount > 0) {
                        this.fileWriter.write("\n");
                    } else {
                        this.fileWriter.write("LINE_POSITION\tLINE_DATA\n");
                    }
                    this.fileWriter.write(String.format("%s\t<|DATA|>%s<|DATA|>", position + 1, this.currentLine.value));
                    this.fileWriter.flush();
                    this.lastBadLinePosition = position;
                }
                catch (IOException e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("Failed to write badLine", (Throwable)e);
                }
            }
            ++this.recordErrorCount;
        }
    }

    private String formatRejectFieldFilePath(String fileName) {
        return this.metadataFile.getFather().getPath() + File.separator + fileName + ".log.bad";
    }

    private String getRejectFieldFilePath() {
        String fileName = null;
        try {
            fileName = this.input.getFile().getName();
        }
        catch (IOException e) {
            this.logger.error(Messages.getString("FileDriverResultSet.40"), (Throwable)e);
        }
        return this.formatRejectFieldFilePath(fileName);
    }

    private String formatRejectRecordFilePath(String fileName) {
        return this.metadataFile.getFather().getPath() + File.separator + fileName + ".line.bad";
    }

    private String getRejectRecordFilePath() {
        String fileName = null;
        try {
            fileName = this.input.getFile().getName();
        }
        catch (IOException e) {
            this.logger.error(Messages.getString("FileDriverResultSet.40"), (Throwable)e);
        }
        return this.formatRejectRecordFilePath(fileName);
    }

    private void closeStreams() {
        try {
            this.rejectFileWriter.close();
        }
        catch (IOException e) {
            this.logger.error(Messages.getString("FileDriverResultSet.41"), (Throwable)e);
        }
    }

    private void writeRejectField(int position, int fieldNumber, String fieldName, FileDriver.FD_CODE_MSG error, String fieldData, boolean warning) {
        if (this.lastBadLinePosition2 != position || this.lastBadFieldPosition != fieldNumber || this.lastErrorCode != error) {
            block9: {
                String fileName = this.getRejectFieldFilePath();
                try {
                    if (!fileName.equals(this.lastFilename)) {
                        this.lastFilename = fileName;
                        this.fieldErrorCount = 0;
                        if (this.rejectFileWriter != null) {
                            this.closeStreams();
                        }
                        this.rejectFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.lastFilename, false), this.readerCharSetName), this.readerBufferSize);
                    }
                    if (this.fieldErrorCount > 0) {
                        this.rejectFileWriter.write("\n");
                    } else {
                        this.rejectFileWriter.write("LINE_POSITION\tRECORD_NAME\tERROR_CODE\tSEVERITY\tFIELD_POSITION\tFIELD_NAME\tFIELD_DATA\n");
                    }
                    String recordName = this.metadataEnreg != null ? this.metadataEnreg.getLogicalName() : this.metadataFile.getLogicalName();
                    if (fieldNumber != -1) {
                        this.rejectFileWriter.write(String.format("%s\t%s\t%s\t%s\t%s\t%s\t<|DATA|>%s<|DATA|>", position + 1, recordName, error.toString(), warning ? "W" : "R", fieldNumber, fieldName, fieldData));
                    } else {
                        this.rejectFileWriter.write(String.format("%s\t%s\t%s\t%s\t\t\t", position + 1, recordName, error.toString(), warning ? "W" : "R"));
                    }
                    this.rejectFileWriter.flush();
                    this.lastBadLinePosition = position;
                    this.lastBadFieldPosition = fieldNumber;
                    this.lastErrorCode = error;
                }
                catch (IOException e) {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug("Failed to write rejected field", (Throwable)e);
                }
            }
            ++this.fieldErrorCount;
        }
    }

    public List<MetadataFilter> getFilters() {
        return this.metadataEnreg.getFilters();
    }

    @Override
    public void setInputStream(InputStream inputStream) throws SQLException {
        this.setInput(new MonoFileInputStreamSet(inputStream, this));
    }

    public void setFile(File file) {
        this.setInput(new MonoFileInputStreamSet(file, this));
    }

    public void setFiles(List<File> files) {
        this.setInput(new MultiFileInputStreamSet(files, this));
    }

    public void setInput(IInputStreamSet isl) {
        this.setReader(isl);
    }

    public File getFile() throws IOException {
        return this.input.getFile();
    }

    public IInputStreamSet getInput() {
        return this.input;
    }

    public IReadContext getContext() throws IOException {
        return this.input.getContext();
    }

    public void setMultiSource(boolean multiSource) {
        this.multiSource = multiSource;
    }

    static StambiaBufferedReaderI initBufferReader(MetadataFile metadataFile, InputStream inputStream, int readerBufferSize, int readLineModeVersion) throws IOException {
        InputStream is = null;
        is = metadataFile.getReadingScript() != null && (metadataFile.getLanguageScript() == null || !metadataFile.getLanguageScript().equals("disable")) ? TransformInputStreamWithScript.transform(inputStream, metadataFile.getReadingScript(), metadataFile.getLanguageScript()) : inputStream;
        StambiaBufferedReaderI bufferedReader = new StambiaBufferedReaderI(new InputStreamReader(is, metadataFile.getCharsetName()), readerBufferSize);
        bufferedReader.setReadLineModeVersion(readLineModeVersion);
        bufferedReader.setLineSeparator(metadataFile.getLineSeparator());
        bufferedReader.setLineSize(metadataFile.getLineSize());
        bufferedReader.setFilterSet(metadataFile.setFilterSet(bufferedReader));
        bufferedReader.setStringDelimiter(metadataFile.getStringDelimiter());
        bufferedReader.setEscapeChar(metadataFile.getEscapeChar());
        bufferedReader.setLineTransformLanguage(metadataFile.getLineTransformationLanguage());
        bufferedReader.setLineTransformScript(metadataFile.getLineTransformationScript());
        bufferedReader.setLineToSkipBefore(metadataFile.getHeaderSize());
        bufferedReader.setLastLinePosition(metadataFile.getLastLineToSkip());
        bufferedReader.setMaxLasLineToBuffer(metadataFile.searchMaxLastRowPosition(metadataFile, metadataFile.getLastLineToSkip()));
        return bufferedReader;
    }

    public FileDriverResultSet(FileDriverStatement st, FileDriverResultSetMetaData rsmd, File file) throws SQLException {
        this.fResultSetMetadata = rsmd;
        this.statement = st;
        if (file != null) {
            this.setFile(file);
        }
        try {
            this.fetchSize = this.statement.getFetchSize();
        }
        catch (SQLException e) {
            this.logger.error("failed to get fetchsize", (Throwable)e);
        }
        String fileName = this.fResultSetMetadata.getLstTables().firstKey();
        FileDriverResultSetTable fdrst = this.fResultSetMetadata.getLstTables().get(fileName);
        this.metadataEnreg = fdrst.getMetaDataEnreg();
        this.metadataFile = fdrst.getMetaDataFile();
        String metaStringDelimiter = this.metadataFile.getStringDelimiter();
        String metaFieldSeparator = this.metadataFile.getFieldSeparator();
        String metaEscapeChar = this.metadataFile.getEscapeChar();
        if (metaFieldSeparator != null) {
            this.fe = new DelimitedLineParser(metaFieldSeparator, metaStringDelimiter, metaEscapeChar);
        }
        this.readerCharSetName = this.metadataFile.getCharsetName();
        this.connection = (FileDriverConnection)this.statement.getConnection();
        this.currentRowInFetch = 0;
        this.currentRowInFile = -1;
        this.currentResultSetSize = -1;
        this.connection.log(Messages.getString("FileDriverResultSet.0"));
        int i = 1;
        while (i <= this.fResultSetMetadata.getColumns().length) {
            IMetadataColumn col = this.getMetadataColumn(i);
            if (col instanceof FileContentColumn) {
                this.hasRawField = true;
                this.hasInternalField = true;
            } else if (col instanceof InternalColumn) {
                this.hasInternalField = true;
            } else {
                this.hasDatafield = true;
            }
            ++i;
        }
        if (this.hasDatafield && this.hasRawField) {
            throw new SQLException(Messages.getString("FileDriverResultSet.1"));
        }
    }

    public String[][] readDelimited(int numLine) throws SQLException, IOException {
        String[] ret = new String[this.fResultSetMetadata.getColumns().length];
        IMetadataColumn[] metLstColumns = this.metadataEnreg.getLstColumns();
        String[] readData = new String[metLstColumns.length];
        int i = 0;
        this.skipLine = false;
        boolean parse = false;
        Pointer<String> line = this.currentLine;
        i = 0;
        while (i < metLstColumns.length) {
            IMetadataColumn metCol = metLstColumns[i];
            ILineContext context = null;
            if (metCol.getAncestorLevel() > 0) {
                context = this.getReader().getAncestorContext(metCol.getAncestorLevel());
                line = context.getLine();
            } else {
                context = this.getReader().getAncestorContext(0);
            }
            String exprValue = this.getExpressionvalue(context, metCol);
            if (exprValue != null) {
                readData[i] = exprValue;
            } else {
                if (!parse) {
                    parse = true;
                    this.fe.parse(line);
                }
                if (this.fe.hasNext()) {
                    DelimitedLineParser.Field field = this.fe.next();
                    readData[i] = field.getData();
                    if (i == this.metadataEnreg.getLastColumn().getIndex() && this.fe.hasNext()) {
                        this.checkOnError(null, numLine, this.metadataFile.getTrailingFieldsBehaviour(), FileDriver.FD_CODE_MSG.FD_010_012);
                    }
                    if (field.isMissingStringDelimiter()) {
                        this.checkOnError(metCol.getName(), numLine, this.metadataFile.getFieldErrorBehaviour(), FileDriver.FD_CODE_MSG.FD_010_002);
                    }
                } else {
                    readData[i] = "";
                    this.checkOnError(metCol.getName(), numLine, this.metadataFile.getWrongNumberFieldBehaviour(), FileDriver.FD_CODE_MSG.FD_010_005);
                }
            }
            ++i;
        }
        int j = 0;
        while (j < this.fResultSetMetadata.getColumns().length) {
            FileDriverResultSetColumn col = this.fResultSetMetadata.getColumns()[j];
            IMetadataColumn mc = col.getLstExpressionColumns().firstEntry().getValue();
            int index = mc.getIndex();
            if (mc.getType() == 0) {
                ret[j] = null;
            } else if (index < readData.length && j < ret.length) {
                ret[j] = readData[index];
            }
            ++j;
        }
        String[][] ret2 = new String[][]{this.skipLine ? null : ret, readData};
        return ret2;
    }

    public void checkOnError(String name, int numLine, MetadataFile.ErrorBehaviour errorBehaviour, FileDriver.FD_CODE_MSG columnMsg, String ... str) throws SQLException {
        if (errorBehaviour.isRedirectToBadFile()) {
            this.writeBadLine(numLine);
            this.writeRejectField(numLine, -1, null, columnMsg, null, true);
        }
        if (errorBehaviour.isRaiseError()) {
            if (name != null) {
                throw new SQLException("Line: " + (numLine + 1) + " Column '" + name + "' " + columnMsg.getMessage((String)this.currentLine.value, str));
            }
            throw new SQLException("Line: " + (numLine + 1) + " " + columnMsg.getMessage((String)this.currentLine.value, str));
        }
        this.skipLine = errorBehaviour.isSkipLine();
    }

    void checkOnFieldError(int fieldNumber, String fieldName, FileDriver.FD_CODE_MSG error, String data, String ... str) throws SQLException {
        this.checkOnFieldError(fieldNumber, fieldName, error, data, false, str);
    }

    void checkOnFieldError(int fieldNumber, String fieldName, FileDriver.FD_CODE_MSG error, String data, boolean warning, String ... str) throws SQLException {
        MetadataFile.ErrorBehaviour errorBehaviour = this.metadataFile.getFieldErrorBehaviour();
        if (errorBehaviour.isRedirectToBadFile()) {
            this.writeRejectField(this.currentRowPosition, fieldNumber, fieldName, error, data, warning);
            this.writeCurrentRowInBadFile(this.currentRowPosition);
        }
        if (errorBehaviour.isRaiseError()) {
            throw new SQLException("Line: " + this.currentRowPosition + " Column '" + fieldName + "' " + error.getMessage(data, str));
        }
    }

    public void checkOnError(String name, int numLine, MetadataFile.ErrorBehaviour errorBehaviour, FileDriver.FD_CODE_MSG columnMsg) throws SQLException {
        this.checkOnError(name, numLine, errorBehaviour, columnMsg, new String[0]);
    }

    public String[] readPositional(int numLine) throws SQLException {
        String[] ret = new String[this.fResultSetMetadata.columns.length];
        try {
            int lastPosition = ((String)this.currentLine.value).length() - 1;
            IMetadataColumn lastCol = this.metadataEnreg.getLastColumn();
            int size = lastCol.getStartPosition() + lastCol.getPhysicalSize();
            if (size - 1 > ((String)this.currentLine.value).length()) {
                this.checkOnError(null, numLine, this.metadataFile.getWrongNumberFieldBehaviour(), FileDriver.FD_CODE_MSG.FD_010_005);
            } else if (size - 1 < ((String)this.currentLine.value).length()) {
                this.checkOnError(null, numLine, this.metadataFile.getTrailingFieldsBehaviour(), FileDriver.FD_CODE_MSG.FD_010_012);
            }
            if (lastPosition > 0) {
                int j = 0;
                while (j < this.fResultSetMetadata.columns.length) {
                    FileDriverResultSetColumn col = this.fResultSetMetadata.columns[j];
                    IMetadataColumn metCol = col.getLstExpressionColumns().firstEntry().getValue();
                    if (!(metCol instanceof InternalColumn)) {
                        ret[j] = this.readPositional(metCol);
                    }
                    ++j;
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Messages.getString("FileDriverResultSet.2") + numLine, e);
        }
        return ret;
    }

    private String getExpressionvalue(ILineContext context, IMetadataColumn metCol) throws IOException {
        if (metCol.getExpression() != null) {
            if (context == null) {
                context = this.getReader().getAncestorContext(0);
            }
            if (metCol.getExpression().trim().equalsIgnoreCase("uuid()")) {
                return context.getUUID();
            }
            if (metCol.getExpression().trim().equalsIgnoreCase("localposition()")) {
                return String.valueOf(context.getLocalPosition());
            }
            if (metCol.getExpression().trim().equalsIgnoreCase("id()")) {
                return String.valueOf(context.getTimeStampPosition());
            }
            if (metCol.getExpression().trim().equalsIgnoreCase("timestamp()")) {
                if (metCol.getType() == 93 || metCol.getType() == 91) {
                    return metCol.getDateFormat().format(new Date(((IReadContext)((Object)this.getReader())).startTimeStamp()));
                }
                return String.valueOf(((IReadContext)((Object)this.getReader())).startTimeStamp());
            }
        }
        return null;
    }

    private String readPositional(IMetadataColumn metCol) throws IOException {
        String exprValue;
        if (metCol.getType() == 0) {
            return null;
        }
        ILineContext context = null;
        Pointer<String> line = this.currentLine;
        if (metCol.getAncestorLevel() > 0) {
            context = this.getReader().getAncestorContext(metCol.getAncestorLevel());
            line = context.getLine();
        }
        if ((exprValue = this.getExpressionvalue(context, metCol)) != null) {
            return exprValue;
        }
        if (line.value != null) {
            int lastPosition = ((String)line.value).length();
            int start = metCol.getStartPosition() - 1;
            if (start < lastPosition) {
                int end = metCol.getStartPosition() + metCol.getPhysicalSize() - 1;
                end = end > lastPosition ? lastPosition : end;
                return ((String)line.value).substring(start, end);
            }
        }
        return null;
    }

    @Override
    public boolean next() throws SQLException {
        int i;
        while ((i = this.doNext()) == 2) {
        }
        return i == 1;
    }

    private int doNext() throws SQLException {
        block26: {
            if (this.hasRawField) {
                block25: {
                    try {
                        if (!this.input.isNotStart()) break block25;
                        boolean b = this.input.next();
                        if (b) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                if (this.input.hasNext()) {
                    if (this.input.next()) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            if (this.needToPurgeBadFIles) {
                if (this.metadataFile.getFieldErrorBehaviour().isRedirectToBadFile()) {
                    this.purgeRejectFieldFiles();
                }
                if (this.metadataFile.getWrongNumberFieldBehaviour().isRedirectToBadFile()) {
                    this.purgeRejectRecordFiles();
                }
                this.needToPurgeBadFIles = false;
            }
            if (this.currentRowInFetch == this.currentResultSetSize - 1 || this.currentResultSetSize == -1) {
                if (this.currentResultSetSize == -1) {
                    this.currentRowInFile = 0;
                }
                this.rowArrayValues = new String[this.fetchSize][];
                this.rowPositions = new int[this.fetchSize];
                boolean finishFile = false;
                int i = 0;
                while (i < this.fetchSize && !finishFile) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (i == 0) {
                        this.firstRowInFetch = this.currentRowInFile;
                    }
                    if (this.hasNext || this.input.isNotStart()) {
                        this.input.next();
                        this.hasNext = false;
                    }
                    this.currentLine.value = this.getReader().readLine();
                    this.hasNext = this.currentLine.value == null && this.input.hasNext();
                    int position = this.getReader().getCurrentLinePosition();
                    if (this.currentLine.value != null) {
                        String[] lstSelectValues = this.metadataFile.getType() == 0 ? this.readDelimited(position)[0] : this.readPositional(position);
                        this.rowArrayValues[i] = lstSelectValues;
                        this.rowPositions[i] = position;
                        ++this.currentRowInFile;
                    } else {
                        finishFile = true;
                        if (!this.hasNext) {
                            this.lastRow = this.currentRowInFile;
                        }
                    }
                    ++i;
                }
                this.currentRowValues = this.rowArrayValues[0];
                this.currentRowPosition = this.rowPositions[0];
                this.currentRowInFetch = 0;
                this.currentResultSetSize = this.fetchSize;
            } else {
                this.currentRowValues = this.rowArrayValues[++this.currentRowInFetch];
                this.currentRowPosition = this.rowPositions[this.currentRowInFetch];
            }
            this.previousNull = false;
            if (!this.isLast()) break block26;
            return 0;
        }
        try {
            if (this.currentRowValues == null) {
                return 2;
            }
            return 1;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(e);
        }
    }

    private void deleteFile(File toDelete) {
        try {
            if (toDelete.exists()) {
                Files.delete(toDelete.toPath());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to delete {}", (Object)toDelete.toPath(), (Object)e);
        }
    }

    private void purgeRejectFieldFiles() {
        if (this.input instanceof MultiFileInputStreamSet) {
            for (File f : ((MultiFileInputStreamSet)this.input).getFiles()) {
                File toDelete = new File(this.formatRejectFieldFilePath(f.getName()));
                this.deleteFile(toDelete);
            }
        } else {
            this.deleteFile(new File(this.getRejectFieldFilePath()));
        }
    }

    private void purgeRejectRecordFiles() {
        if (this.input instanceof MultiFileInputStreamSet) {
            for (File f : ((MultiFileInputStreamSet)this.input).getFiles()) {
                File toDelete = new File(this.formatRejectRecordFilePath(f.getName()));
                this.deleteFile(toDelete);
            }
        } else {
            this.deleteFile(new File(this.getRejectRecordFilePath()));
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            try {
                if (this.input != null) {
                    this.input.close();
                    this.input = null;
                }
                if (this.fileWriter != null) {
                    this.fileWriter.close();
                    this.fileWriter = null;
                }
                if (this.rejectFileWriter != null) {
                    this.rejectFileWriter.close();
                    this.rejectFileWriter = null;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        finally {
            this.rowArrayValues = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.previousNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String value = null;
        IMetadataColumn metCol = this.getMetadataColumn(columnIndex);
        try {
            value = this.getInternalString(metCol);
            if (value != null) {
                return value;
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        try {
            this.previousNull = false;
            value = this.currentRowValues[columnIndex - 1];
            if (value != null) {
                if (!this.metadataFile.isDisableRightTrimOnString()) {
                    value = FileDriver.rtrim(value);
                }
                if (this.metadataFile.isEnableLeftTrimOnString()) {
                    value = FileDriver.ltrim(value);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(Messages.getString("FileDriverResultSet.3") + columnIndex + Messages.getString("FileDriverResultSet.4"));
        }
        if (value != null && this.metadataFile.getFieldErrorBehaviour().hasCheckSize() && value.length() > metCol.getDisplaySize()) {
            this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_006, value, this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.ignoreError, String.valueOf(value.length()), String.valueOf(metCol.getDisplaySize()));
            if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() != MetadataFile.ErrorMode.ignoreError) {
                if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                    value = null;
                } else if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToEmptyValue) {
                    value = "";
                }
            }
        }
        if (value != null && value.isEmpty()) {
            if (this.metadataFile.isEmptyStringAsNull()) {
                return null;
            }
            if (this.metadataFile.getStringDefaultValue() != null) {
                return this.metadataFile.getStringDefaultValue();
            }
        }
        return value;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        IMetadataColumn metCol = this.getMetadataColumn(columnIndex);
        try {
            Boolean value = this.getInternalBoolean(metCol);
            if (value != null) {
                return value;
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        boolean ret = false;
        this.previousNull = false;
        try {
            String str = this.currentRowValues[columnIndex - 1].trim();
            if (str.equals("")) {
                this.previousNull = true;
                return ret;
            }
            try {
                ret = Boolean.parseBoolean(str);
            }
            catch (Exception e) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "boolean");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(Messages.getString("FileDriverResultSet.5") + columnIndex + Messages.getString("FileDriverResultSet.6"));
        }
        return ret;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte ret;
        block9: {
            ret = 0;
            this.previousNull = false;
            try {
                IMetadataColumn metCol = this.fResultSetMetadata.columns[columnIndex - 1].lstExpressionColumns.firstEntry().getValue();
                String str = this.currentRowValues[columnIndex - 1];
                if (metCol.getConverter() == null) {
                    str = str.trim();
                }
                if (str.isEmpty()) {
                    this.previousNull = true;
                    return ret;
                }
                try {
                    if (metCol.getConverter() != null) {
                        BigDecimal ret2 = metCol.getConverter().parse(str, this.getReader().getEncoding(), metCol);
                        if (ret2 != null) {
                            ret = ret2.byteValue();
                        } else {
                            this.previousNull = true;
                        }
                        break block9;
                    }
                    ret = Byte.parseByte(str.trim());
                }
                catch (Exception e) {
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "byte");
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLException(Messages.getString("FileDriverResultSet.7") + columnIndex + Messages.getString("FileDriverResultSet.8"));
            }
        }
        return ret;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short ret;
        block11: {
            ret = 0;
            this.previousNull = false;
            try {
                IMetadataColumn metCol = this.fResultSetMetadata.columns[columnIndex - 1].lstExpressionColumns.firstEntry().getValue();
                String str = this.currentRowValues[columnIndex - 1];
                if (metCol.getConverter() == null) {
                    str = str.trim();
                }
                if (str.isEmpty()) {
                    if (this.metadataFile.getNumericDefaultValue() != null && !this.metadataFile.getNumericDefaultValue().isEmpty()) {
                        str = this.metadataFile.getNumericDefaultValue();
                    } else {
                        this.previousNull = true;
                        return ret;
                    }
                }
                try {
                    ret = this.doGetShort(metCol, str);
                }
                catch (Exception e) {
                    String defaultEmptyValue;
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "short");
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                        this.previousNull = null;
                        break block11;
                    }
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() != MetadataFile.ErrorMode.setToEmptyValue || this.metadataFile.getNumericDefaultValue() == null || this.metadataFile.getNumericDefaultValue().isEmpty() || (defaultEmptyValue = this.doGetNumericDefaultValue()) == null) break block11;
                    try {
                        ret = this.doGetShort(metCol, defaultEmptyValue);
                    }
                    catch (Exception e1) {
                        throw new SQLException(Messages.getString("FileDriverResultSet.9"), e1);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLException(Messages.getString("FileDriverResultSet.10") + columnIndex + Messages.getString("FileDriverResultSet.11"));
            }
        }
        return ret;
    }

    private short doGetShort(IMetadataColumn metCol, String str) throws Exception {
        if (metCol.getConverter() != null) {
            BigDecimal ret2 = metCol.getConverter().parse(str, this.getReader().getEncoding(), metCol);
            if (ret2 != null) {
                return ret2.shortValue();
            }
            this.previousNull = true;
            return 0;
        }
        return Short.parseShort(str);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int ret;
        block14: {
            IMetadataColumn metCol = this.getMetadataColumn(columnIndex);
            try {
                Integer value = this.getInternalInt(metCol);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            ret = 0;
            this.previousNull = false;
            try {
                String str = this.currentRowValues[columnIndex - 1];
                if (metCol.getConverter() == null) {
                    str = str.trim();
                }
                if (str.isEmpty()) {
                    if (this.metadataFile.getNumericDefaultValue() != null && !this.metadataFile.getNumericDefaultValue().isEmpty()) {
                        str = this.metadataFile.getNumericDefaultValue();
                    } else {
                        this.previousNull = true;
                        return ret;
                    }
                }
                try {
                    ret = this.doGetInt(metCol, str);
                }
                catch (Exception e) {
                    String defaultEmptyValue;
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "int");
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                        this.previousNull = null;
                        break block14;
                    }
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() != MetadataFile.ErrorMode.setToEmptyValue || this.metadataFile.getNumericDefaultValue() == null || this.metadataFile.getNumericDefaultValue().isEmpty() || (defaultEmptyValue = this.doGetNumericDefaultValue()) == null) break block14;
                    try {
                        ret = this.doGetInt(metCol, defaultEmptyValue);
                    }
                    catch (Exception e1) {
                        throw new SQLException(Messages.getString("FileDriverResultSet.12"), e1);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLException(Messages.getString("FileDriverResultSet.13") + columnIndex + Messages.getString("FileDriverResultSet.14"));
            }
        }
        return ret;
    }

    private int doGetInt(IMetadataColumn metCol, String str) throws Exception {
        if (metCol.getConverter() != null) {
            BigDecimal ret2 = metCol.getConverter().parse(str, this.getReader().getEncoding(), metCol);
            if (ret2 != null) {
                return ret2.intValue();
            }
            this.previousNull = null;
            return 0;
        }
        return Integer.parseInt(str);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long ret;
        block14: {
            IMetadataColumn metCol = this.getMetadataColumn(columnIndex);
            try {
                Long value = this.getInternalLong(metCol);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            ret = 0L;
            this.previousNull = false;
            try {
                String str = this.currentRowValues[columnIndex - 1];
                if (metCol.getConverter() == null) {
                    str = str.trim();
                }
                if (str.isEmpty()) {
                    if (this.metadataFile.getNumericDefaultValue() != null && !this.metadataFile.getNumericDefaultValue().isEmpty()) {
                        str = this.metadataFile.getNumericDefaultValue();
                    } else {
                        this.previousNull = true;
                        return ret;
                    }
                }
                try {
                    ret = this.doGetLong(metCol, str);
                }
                catch (Exception e) {
                    String defaultEmptyValue;
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "long");
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                        this.previousNull = null;
                        break block14;
                    }
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() != MetadataFile.ErrorMode.setToEmptyValue || this.metadataFile.getNumericDefaultValue() == null || this.metadataFile.getNumericDefaultValue().isEmpty() || (defaultEmptyValue = this.doGetNumericDefaultValue()) == null) break block14;
                    try {
                        ret = this.doGetLong(metCol, defaultEmptyValue);
                    }
                    catch (Exception e1) {
                        throw new SQLException(Messages.getString("FileDriverResultSet.15"), e1);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLException(Messages.getString("FileDriverResultSet.16") + columnIndex + Messages.getString("FileDriverResultSet.17"));
            }
        }
        return ret;
    }

    private long doGetLong(IMetadataColumn metCol, String str) throws Exception {
        if (metCol.getConverter() != null) {
            BigDecimal ret2 = metCol.getConverter().parse(str, this.getReader().getEncoding(), metCol);
            if (ret2 != null) {
                return ret2.longValue();
            }
            this.previousNull = true;
            return 0L;
        }
        return Long.parseLong(str);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float ret;
        block11: {
            ret = 0.0f;
            this.previousNull = false;
            try {
                IMetadataColumn metCol = this.fResultSetMetadata.columns[columnIndex - 1].lstExpressionColumns.firstEntry().getValue();
                String str = this.currentRowValues[columnIndex - 1];
                if (metCol.getConverter() == null) {
                    str = str.trim();
                }
                if (str.isEmpty()) {
                    if (this.metadataFile.getNumericDefaultValue() != null && !this.metadataFile.getNumericDefaultValue().isEmpty()) {
                        str = this.metadataFile.getNumericDefaultValue();
                    } else {
                        this.previousNull = true;
                        return ret;
                    }
                }
                try {
                    if (metCol.getConverter() != null) {
                        BigDecimal ret2 = metCol.getConverter().parse(str, this.getReader().getEncoding(), metCol);
                        if (ret2 != null) {
                            ret = ret2.floatValue();
                        } else {
                            this.previousNull = true;
                        }
                        break block11;
                    }
                    ret = metCol.getDecimalFormat().parse(str).floatValue();
                }
                catch (Exception e) {
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "float");
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLException(Messages.getString("FileDriverResultSet.18") + columnIndex + Messages.getString("FileDriverResultSet.19"));
            }
        }
        return ret;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double ret;
        block15: {
            ret = 0.0;
            this.previousNull = false;
            try {
                IMetadataColumn metCol = this.fResultSetMetadata.columns[columnIndex - 1].lstExpressionColumns.firstEntry().getValue();
                String str = this.currentRowValues[columnIndex - 1];
                if (metCol.getConverter() == null && str != null) {
                    str = str.trim();
                }
                if (str == null || str.isEmpty()) {
                    if (this.metadataFile.getNumericDefaultValue() != null && !this.metadataFile.getNumericDefaultValue().isEmpty()) {
                        str = this.metadataFile.getNumericDefaultValue();
                    } else {
                        this.previousNull = true;
                        return ret;
                    }
                }
                try {
                    Number numberRet = this.doGetNumber(metCol, str);
                    if (numberRet == null) {
                        this.previousNull = true;
                    } else {
                        ret = numberRet.doubleValue();
                    }
                }
                catch (Exception e) {
                    String defaultEmptyValue;
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "double");
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                        this.previousNull = null;
                        break block15;
                    }
                    if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() != MetadataFile.ErrorMode.setToEmptyValue || this.metadataFile.getNumericDefaultValue() == null || this.metadataFile.getNumericDefaultValue().isEmpty() || (defaultEmptyValue = this.doGetNumericDefaultValue()) == null) break block15;
                    try {
                        Number numberRet = this.doGetNumber(metCol, defaultEmptyValue);
                        if (numberRet == null) {
                            this.previousNull = true;
                        } else {
                            ret = numberRet.doubleValue();
                        }
                    }
                    catch (Exception e1) {
                        throw new SQLException(Messages.getString("FileDriverResultSet.20"), e1);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLException(Messages.getString("FileDriverResultSet.21") + columnIndex + Messages.getString("FileDriverResultSet.22"));
            }
        }
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        IMetadataColumn metCol = this.getMetadataColumn(columnIndex);
        if (metCol instanceof FileContentColumn) {
            try {
                return this.readFully();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (metCol instanceof FileColumn) {
            try {
                String value = this.getInternalString(metCol);
                if (value != null) {
                    return value.getBytes();
                }
            }
            catch (FileNotFoundException e) {
                throw new SQLException(e);
            }
        }
        byte[] ret = null;
        try {
            String str = this.currentRowValues[columnIndex - 1];
            try {
                ret = str.getBytes();
            }
            catch (Exception e) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "bytes");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(Messages.getString("FileDriverResultSet.23") + columnIndex + Messages.getString("FileDriverResultSet.24"));
        }
        return ret;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        boolean hasError;
        Date ret;
        IMetadataColumn metCol;
        block24: {
            String str;
            DateFormat dateFormat;
            block23: {
                metCol = this.getMetadataColumn(columnIndex);
                try {
                    Date value = this.getInternalDate(metCol);
                    if (value != null) {
                        return value;
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
                ret = null;
                dateFormat = null;
                this.previousNull = false;
                hasError = false;
                try {
                    dateFormat = metCol.getDateFormat();
                    if (dateFormat == null) {
                        dateFormat = new SimpleDateFormat(MetadataServer.DEFAULT_DATE_FORMAT);
                        dateFormat.setLenient(false);
                    }
                }
                catch (Exception e) {
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_008, null, e.getMessage());
                    return null;
                }
                try {
                    str = this.currentRowValues[columnIndex - 1];
                    if (str != null) break block23;
                    return null;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new SQLException(Messages.getString("FileDriverResultSet.25") + columnIndex + Messages.getString("FileDriverResultSet.26"));
                }
            }
            str = str.trim();
            if (str.isEmpty()) {
                if (this.metadataFile.getDateDefaultValue() != null && !this.metadataFile.getDateDefaultValue().isEmpty()) {
                    str = this.metadataFile.getDateDefaultValue();
                } else {
                    this.previousNull = true;
                    return ret;
                }
            }
            try {
                if (this.metadataFile.getFieldErrorBehaviour().hasCheckSize() && str.length() > metCol.getDisplaySize()) {
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_006, str, this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.ignoreError, String.valueOf(str.length()), String.valueOf(metCol.getDisplaySize()));
                    hasError = true;
                    break block24;
                }
                ret = new Date(dateFormat.parse(str).getTime());
            }
            catch (Exception e) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "date");
                hasError = true;
            }
        }
        if (hasError) {
            if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                return null;
            }
            if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToEmptyValue && this.metadataFile.getDateDefaultValue() != null && !this.metadataFile.getDateDefaultValue().isEmpty()) {
                try {
                    ret = new Date(metCol.getDefaultDateFormat().parse(this.metadataFile.getDateDefaultValue()).getTime());
                }
                catch (ParseException e1) {
                    if (metCol.getDefaultDateFormat() != metCol.getDateFormat()) {
                        try {
                            ret = new Date(metCol.getDateFormat().parse(this.metadataFile.getDateDefaultValue()).getTime());
                        }
                        catch (ParseException e2) {
                            throw new SQLException(Messages.getString("FileDriverResultSet.27"), e2);
                        }
                    }
                    throw new SQLException(Messages.getString("FileDriverResultSet.28"), e1);
                }
            }
        }
        return ret;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Time ret = null;
        this.previousNull = false;
        try {
            String str = this.currentRowValues[columnIndex - 1].trim();
            if (str.equals("")) {
                this.previousNull = true;
                return ret;
            }
            try {
                ret = Time.valueOf(str);
            }
            catch (Exception e) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "Time");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(Messages.getString("FileDriverResultSet.29") + columnIndex + Messages.getString("FileDriverResultSet.30"));
        }
        return ret;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        boolean hasError;
        Timestamp ret;
        IMetadataColumn metCol;
        block23: {
            String str;
            DateFormat dateFormat;
            block22: {
                metCol = this.getMetadataColumn(columnIndex);
                try {
                    Timestamp value = this.getInternalTimestamp(metCol);
                    if (value != null) {
                        return value;
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
                ret = null;
                this.previousNull = false;
                hasError = false;
                try {
                    dateFormat = metCol.getDateFormat();
                }
                catch (Exception e) {
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_009, null, e.getMessage());
                    return null;
                }
                try {
                    str = this.currentRowValues[columnIndex - 1];
                    if (str != null) break block22;
                    return null;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new SQLException(Messages.getString("FileDriverResultSet.31") + columnIndex + Messages.getString("FileDriverResultSet.32"));
                }
            }
            str = str.trim();
            if (str.isEmpty()) {
                if (this.metadataFile.getTimestampDefaultValue() != null) {
                    str = this.metadataFile.getTimestampDefaultValue();
                } else {
                    this.previousNull = true;
                    return ret;
                }
            }
            try {
                if (this.metadataFile.getFieldErrorBehaviour().hasCheckSize() && str.length() > metCol.getDisplaySize()) {
                    this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_006, str, this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.ignoreError, String.valueOf(str.length()), String.valueOf(metCol.getDisplaySize()));
                    hasError = true;
                    break block23;
                }
                ret = new Timestamp(dateFormat.parse(str).getTime());
            }
            catch (Exception e) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, "timestamp");
                hasError = true;
            }
        }
        if (hasError) {
            if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                return null;
            }
            if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToEmptyValue && this.metadataFile.getTimestampDefaultValue() != null && !this.metadataFile.getTimestampDefaultValue().isEmpty()) {
                try {
                    ret = new Timestamp(metCol.getDefaultDateFormat().parse(this.metadataFile.getTimestampDefaultValue()).getTime());
                }
                catch (ParseException e1) {
                    if (metCol.getDefaultDateFormat() != metCol.getDateFormat()) {
                        try {
                            ret = new Timestamp(metCol.getDateFormat().parse(this.metadataFile.getTimestampDefaultValue()).getTime());
                        }
                        catch (ParseException e2) {
                            throw new SQLException(Messages.getString("FileDriverResultSet.33"), e2);
                        }
                    }
                    throw new SQLException(Messages.getString("FileDriverResultSet.34"), e1);
                }
            }
        }
        return ret;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String val;
        IMetadataColumn col = this.getMetadataColumn(columnIndex);
        if (col instanceof FileContentColumn) {
            try {
                String str = this.readFully(this.readerCharSetName);
                return new ByteArrayInputStream(str.getBytes("US-ASCII"));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        try {
            val = this.getInternalString(col);
        }
        catch (FileNotFoundException e) {
            throw new SQLException(e);
        }
        if (val != null) {
            try {
                return new ByteArrayInputStream(val.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        }
        ByteArrayInputStream ret = null;
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = new ByteArrayInputStream(str.getBytes());
        }
        catch (Exception e) {
            this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, " asciiStream");
        }
        return ret;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        IMetadataColumn col = this.getMetadataColumn(columnIndex);
        if (col instanceof FileContentColumn) {
            try {
                return this.input.getInputStream();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.fResultSetMetadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int i = this.fResultSetMetadata.getColumnType(columnIndex);
        switch (i) {
            case 12: {
                return this.getString(columnIndex);
            }
            case 2: {
                return this.getBigDecimal(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getString(columnName);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.fResultSetMetadata.getColumnId(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        StringReader ret;
        IMetadataColumn col = this.getMetadataColumn(columnIndex);
        if (col instanceof FileContentColumn) {
            return new StringReader(this.getString(columnIndex));
        }
        String str = this.currentRowValues[columnIndex - 1];
        try {
            ret = new StringReader(str);
        }
        catch (Exception e) {
            String name = this.getMetaData().getColumnName(columnIndex);
            throw new SQLException("Line: " + this.getRow() + Messages.getString("FileDriverResultSet.35") + name + Messages.getString("FileDriverResultSet.36") + str + Messages.getString("FileDriverResultSet.37") + "a java.io.Reader object", e);
        }
        return ret;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        IMetadataColumn metCol = this.getMetadataColumn(columnIndex);
        try {
            Long value = this.getInternalLong(metCol);
            if (value != null) {
                return new BigDecimal(value);
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        BigDecimal ret = null;
        this.previousNull = false;
        boolean hasError = false;
        String str = this.currentRowValues[columnIndex - 1];
        if (str == null) {
            return null;
        }
        if (metCol.getConverter() == null) {
            str = str.trim();
        }
        if (str.isEmpty()) {
            String defaultEmptyValue = this.doGetNumericDefaultValue();
            if (defaultEmptyValue != null) {
                str = this.metadataFile.getNumericDefaultValue();
            } else {
                this.previousNull = true;
                return ret;
            }
        }
        try {
            ret = (BigDecimal)this.doGetNumber(metCol, str);
        }
        catch (Exception e) {
            this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_007, str, " BigDecimal");
        }
        if (ret != null && this.metadataFile.getFieldErrorBehaviour().hasCheckSize()) {
            int scale = ret.scale();
            int precision = ret.precision();
            if (scale < 0) {
                precision -= scale;
                scale = 0;
            }
            if (metCol.getDisplaySize() < precision) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_010, str, this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.ignoreError, String.valueOf(precision), String.valueOf(metCol.getDisplaySize()));
                hasError = true;
            }
            if (metCol.getScale() < scale) {
                this.checkOnFieldError(columnIndex, this.getMetaData().getColumnName(columnIndex), FileDriver.FD_CODE_MSG.FD_010_011, str, this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.ignoreError, String.valueOf(scale), String.valueOf(metCol.getScale()));
                hasError = true;
            }
        }
        if (hasError) {
            String defaultEmptyValue;
            if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToNull) {
                ret = null;
            } else if (this.metadataFile.getFieldErrorBehaviour().getErrorMode() == MetadataFile.ErrorMode.setToEmptyValue && (defaultEmptyValue = this.doGetNumericDefaultValue()) != null) {
                try {
                    ret = (BigDecimal)this.doGetNumber(metCol, defaultEmptyValue);
                }
                catch (Exception e) {
                    throw new SQLException(Messages.getString("FileDriverResultSet.38"), e);
                }
            }
        }
        return ret;
    }

    private String doGetNumericDefaultValue() {
        if (this.metadataFile.getNumericDefaultValue() != null && !this.metadataFile.getNumericDefaultValue().isEmpty()) {
            return this.metadataFile.getNumericDefaultValue();
        }
        return null;
    }

    private Number doGetNumber(IMetadataColumn metCol, String str) throws Exception {
        if (metCol.getConverter() != null) {
            return metCol.getConverter().parse(str, this.getReader().getEncoding(), metCol);
        }
        return metCol.getDecimalFormat().parse(str);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.fResultSetMetadata.getColumnId(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentRowInFile == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRowInFile == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.firstRowInFetch + this.currentRowInFetch == this.lastRow;
    }

    @Override
    public int getRow() throws SQLException {
        return this.firstRowInFetch + this.currentRowInFetch + 1;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.isScrollable;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public IStambiaReader getReader() throws IOException {
        return this.input.getReader();
    }

    private String readFully(String encoding) throws IOException {
        return new String(this.readFully(), encoding);
    }

    private byte[] readFully() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.input.getInputStream();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            return baos.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IMetadataColumn getMetadataColumn(int columnIndex) {
        return this.fResultSetMetadata.getColumns()[columnIndex - 1].getLstExpressionColumns().firstEntry().getValue();
    }

    private Date getInternalDate(IMetadataColumn col) throws SQLException {
        if (col instanceof FileColumn) {
            try {
                return ((FileColumn)col).getDate(this.getFile());
            }
            catch (Throwable e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    private Timestamp getInternalTimestamp(IMetadataColumn col) throws SQLException {
        if (col instanceof FileColumn) {
            try {
                return ((FileColumn)col).getTimestamp(this.getFile());
            }
            catch (Throwable e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    private Long getInternalLong(IMetadataColumn col) throws SQLException {
        if (col instanceof FileColumn) {
            try {
                return ((FileColumn)col).getLong(this.getFile());
            }
            catch (Throwable e) {
                throw new SQLException(e);
            }
        }
        if (col instanceof FileNumberColumn) {
            return this.getFileNumber();
        }
        return null;
    }

    private Integer getInternalInt(IMetadataColumn col) throws SQLException {
        Long l = this.getInternalLong(col);
        if (l != null) {
            return l.intValue();
        }
        return null;
    }

    private Boolean getInternalBoolean(IMetadataColumn col) throws SQLException {
        if (col instanceof FileColumn) {
            try {
                return ((FileColumn)col).getBoolean(this.getFile());
            }
            catch (Throwable e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    private String getInternalString(IMetadataColumn col) throws FileNotFoundException, SQLException {
        if (col instanceof FileColumn) {
            try {
                return ((FileColumn)col).getString(this.getFile());
            }
            catch (Throwable e) {
                throw new SQLException(e);
            }
        }
        if (col instanceof FileContentColumn) {
            try {
                return this.readFully(this.readerCharSetName);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (col instanceof FileNumberColumn) {
            return String.valueOf(this.getFileNumber());
        }
        return null;
    }

    public long getFileNumber() {
        return 1L;
    }

    public void setReader(IInputStreamSet input) {
        this.input = input;
    }

    public void setReadLineModeVersion(int i) throws SQLException {
        if (i == 1 || i == 2) {
            if (i == 2 && this.fe != null) {
                this.fe.newParserMode = true;
            }
        } else {
            throw new SQLException(Messages.getString("FileDriverResultSet.39"));
        }
        this.readLineModeVersion = i;
    }
}

