/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.resultset;

import com.stambia.jdbc.driver.file.fileManagment.IInputStreamSet;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.IStambiaReader;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSet;
import com.stambia.jdbc.driver.file.resultset.IgnoreTrailingLinesInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MonoFileInputStreamSet
implements IInputStreamSet {
    boolean end;
    boolean start;
    IStambiaReader isr;
    IReadContext context;
    final FileDriverResultSet resultSet;
    File file;
    InputStream inputStream;

    MonoFileInputStreamSet(File file, FileDriverResultSet resultSet) {
        this.resultSet = resultSet;
        this.file = file;
    }

    MonoFileInputStreamSet(InputStream inputStream, FileDriverResultSet resultSet) {
        this.resultSet = resultSet;
        this.inputStream = inputStream;
    }

    @Override
    public boolean next() throws IOException {
        if (!this.end) {
            this.start = true;
            this.end = true;
            if (this.isr != null) {
                this.isr.close();
            }
            this.isr = null;
            return true;
        }
        return false;
    }

    @Override
    public int getStreamPosition() {
        return 1;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.getFile() != null) {
            return new FileInputStream(this.getFile());
        }
        throw new IOException();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public IStambiaReader getReader() throws IOException {
        if (this.isr == null) {
            InputStream is = this.getInputStream();
            if (this.resultSet.metadataFile.getIgnoreEmptyLines() == MetadataFile.IgnoreEmptyLines.trailingLines) {
                is = new IgnoreTrailingLinesInputStream(is);
            }
            this.isr = FileDriverResultSet.initBufferReader(this.resultSet.metadataFile, is, this.resultSet.readerBufferSize, this.resultSet.readLineModeVersion);
            this.context = (IReadContext)((Object)this.isr);
            if (!this.resultSet.multiSource) {
                this.isr.setMonoSourceName(this.resultSet.metadataEnreg.getLogicalName());
            }
        }
        return this.isr;
    }

    @Override
    public void close() throws IOException {
        if (this.isr != null) {
            this.isr.close();
        } else {
            InputStream is = this.getInputStream();
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public IReadContext getContext() throws IOException {
        return this.context;
    }

    @Override
    public boolean hasNext() throws IOException {
        return !this.end;
    }

    @Override
    public boolean isNotStart() throws IOException {
        return !this.start;
    }
}

