/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandLineParser;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CommandLine(startWith="schedule delivery", removeString="schedule", usage="schedule delivery <delivery> [scheduleName <scheduleName>] [sessionName <sessionName>] [jobName <jobname>] [with command] [on host <hostname>] [port <hostport>] [start <startDate>] [end <endDate>] [var <path> <value>] [var ...] [configuration <configuration>] [logLevel <logLevel>] cron <cronExpression>", description="Schedule a delivery")
public class ScheduleDeliveryCommand
implements RuntimeCommand {
    @CommandParameter(name="delivery", required=true, usage="Delivery name")
    public String delivery;
    @CommandParameter(name="scheduleName", valueSample="scheduleName", usage="Schedule name")
    public String scheduleName;
    @CommandParameter(name="sessionName", valueSample="sessionName", usage="Session name")
    public String sessionName;
    @CommandParameter(name="with command", usage="Autonomous Thread")
    public Boolean withCommand;
    @CommandParameter(name="on host", valueSample="hostname", usage="Remote runtime host")
    public String hostName;
    @CommandParameter(name="port", valueSample="hostport", usage="Remote runtime port")
    public String port;
    @CommandParameter(name="start", valueSample="startdate", usage="Start date")
    public String startDate;
    @CommandParameter(name="end", valueSample="enddate", usage="End date, like ...")
    public String endDate;
    @CommandParameter(name="cron", required=true, valueSample="cronExpression", usage="Cron expression, like \"0 0 0 * ? *\"")
    public String cron;
    @CommandParameter(name="var", parameters={"name", "value"}, usage="Variable name and value")
    public List<Map<String, String>> vars;
    @CommandParameter(name="configuration", valueSample="DEV", usage="Configuration code")
    public String configuration;
    @CommandParameter(name="jobName", aliases={"with name"}, usage="Job Name")
    public String jobName;
    @CommandParameter(name="logLevel")
    public String logLevel;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.delivery);
        boolean alreadyExist = false;
        if (this.scheduleName != null) {
            if (this.scheduleName.startsWith("CRON")) {
                out.println(Messages.getString("ScheduleDeliveryCommand.0"));
                return;
            }
            for (Map scheduleMap : engineAPI.getLstSchedules(null)) {
                if (!scheduleMap.containsKey("scheduleName") || !scheduleMap.get("scheduleName").equals(this.scheduleName)) continue;
                alreadyExist = true;
                break;
            }
        }
        if (alreadyExist) {
            out.println(Messages.getString("ScheduleDeliveryCommand.1") + this.scheduleName + Messages.getString("ScheduleDeliveryCommand.2"));
        } else if (engineAPI.existDelivery(map)) {
            int executionMode = 1;
            if (this.isWithCommand()) {
                executionMode = 2;
            }
            String _hostPort = this.port;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            ArrayList<Map> lst = new ArrayList<Map>();
            EngineScheduleDetail esd = new EngineScheduleDetail(executionMode);
            esd.setCronExpression(this.cron.trim());
            esd.setSessionName(this.sessionName);
            esd.setConfiguration(this.configuration);
            esd.setScheduleName(this.scheduleName);
            Map _map = esd.toMap();
            HashMap<String, String> variables = null;
            HashMap mapParameters = new HashMap();
            if (this.vars != null) {
                variables = new HashMap<String, String>();
                for (Map<String, String> var : this.vars) {
                    variables.put(var.get("name"), var.get("value"));
                }
                mapParameters.put("variables", variables);
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            String jobName = this.jobName != null && !this.jobName.isEmpty() ? this.jobName : this.delivery;
            parameters.put(ParameterType.jobName.name(), jobName);
            parameters.put(ParameterType.scheduleParameters.name(), mapParameters);
            parameters.put(ParameterType.deliveryName.name(), this.delivery);
            lst.add(_map);
            parameters.put(ParameterType.listSchedules.name(), lst);
            parameters.put(ParameterType.executionType.name(), executionMode);
            if (this.port != null) {
                parameters.put(ParameterType.port.name(), this.port);
            }
            if (this.hostName != null) {
                parameters.put(ParameterType.host.name(), this.hostName);
            }
            if (this.logLevel != null) {
                parameters.put(ParameterType.logLevel.name(), Integer.parseInt(this.logLevel));
            }
            engineAPI.scheduleDeliv(parameters);
        } else {
            out.println(Messages.getString("ScheduleDeliveryCommand.3") + this.delivery + Messages.getString("ScheduleDeliveryCommand.4"));
        }
    }

    public String toString() {
        return "ScheduleDeliveryCommand [delivery=" + this.delivery + ", jobName=" + this.delivery + ", withCommand=" + String.valueOf(this.withCommand) + ", hostName=" + this.hostName + ", port=" + this.port + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", cron=" + this.cron + ", vars=" + String.valueOf(this.vars) + ", logLevel=" + this.logLevel + "]";
    }

    public static void main(String[] args) throws Exception {
        CommandLineParser parser = new CommandLineParser();
        Object o = parser.parse(Messages.getString("ScheduleDeliveryCommand.5"));
        System.out.println(o);
        if (o instanceof RuntimeCommand) {
            ((RuntimeCommand)o).execute(null, System.out, null);
        }
    }

    private boolean isWithCommand() {
        return this.withCommand != null && this.withCommand != false;
    }
}

