/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.action.statics;

import com.indy.engine.Global;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.ActionStaticCode;
import com.indy.engine.main.action.statics.ActionStaticProcess;
import com.indy.engine.main.action.statics.ConnectionStore;
import com.indy.engine.main.action.statics.LinkStatic;
import com.indy.engine.main.action.statics.SessionStatic;
import com.indy.engine.main.action.statics.VariableStatic;
import com.indy.engine.main.listener.impl.ActionEventProvider;
import com.indy.engine.main.listener.impl.Event;
import com.indy.engine.main.listener.impl.EventManager;
import com.indy.engine.main.listener.impl.EventTrigger;
import com.indy.engine.main.listener.impl.SynchEvent;
import com.indy.engine.main.listener.impl.UserLog;
import com.indy.engine.manager.Action;
import com.indy.engine.manager.Logger;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StoreManager {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(StoreManager.class);

    private StoreManager() {
    }

    public static SessionStatic deserializeXML(Document domdoc) throws Exception {
        Document doc = domdoc;
        SessionStatic session = new SessionStatic();
        session.setDeliveryName((String)doc.getUserData("deliveryName"));
        doc.getDocumentElement().normalize();
        Node root = doc.getFirstChild();
        NamedNodeMap deliveryAttrs = root.getAttributes();
        String idRoot = deliveryAttrs.getNamedItem("id").getNodeValue();
        NodeList nlForFirstAction = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            NodeList nl;
            nlForFirstAction = nl = Action.parseMetaInf2(deliveryAttrs);
            if (nl != null && nl.getLength() > 0) {
                int k = 0;
                while (k < nl.getLength()) {
                    Node node = nl.item(k);
                    if (node.getNodeName() != null && node.getTextContent() != null) {
                        map.put(node.getNodeName(), node.getTextContent());
                    }
                    ++k;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while parsing meta-inf", (Throwable)e);
        }
        String tmp = null;
        try {
            tmp = deliveryAttrs.getNamedItem("nbMaxParallelSessions").getNodeValue();
        }
        catch (Exception k) {
            // empty catch block
        }
        if (tmp != null && !tmp.isEmpty()) {
            session.setNbParallelizeExecution(Integer.valueOf(tmp));
        } else {
            session.setNbParallelizeExecution(-1);
            String value = (String)map.get("nbMaxParallelSessions");
            if (value != null) {
                try {
                    session.setNbParallelizeExecution(Integer.valueOf(value));
                }
                catch (Exception e) {
                    session.setNbParallelizeExecution(-1);
                }
            }
        }
        try {
            tmp = deliveryAttrs.getNamedItem("logLevel").getNodeValue();
        }
        catch (Exception value) {
            // empty catch block
        }
        Integer logLevel = null;
        try {
            logLevel = Integer.valueOf(tmp);
        }
        catch (Exception e) {
            try {
                logLevel = Integer.valueOf((String)map.get("logLevel"));
            }
            catch (Exception e2) {
                logLevel = MainEngineI.noLogLevel;
            }
        }
        session.setLogLevel(logLevel);
        Integer retryNumber = null;
        try {
            retryNumber = Integer.valueOf(tmp);
        }
        catch (Exception e) {
            try {
                retryNumber = Integer.valueOf((String)map.get("autoRestartNumber"));
            }
            catch (Exception e2) {
                retryNumber = null;
            }
        }
        session.setRetryNumber(retryNumber);
        Integer retryInterval = null;
        try {
            retryInterval = Integer.valueOf(tmp);
        }
        catch (Exception e) {
            try {
                retryInterval = Integer.valueOf((String)map.get("autoRestartInterval"));
            }
            catch (Exception e2) {
                retryInterval = null;
            }
        }
        session.setRetryInterval(retryInterval);
        boolean externalized = false;
        try {
            session.setExternalized(Boolean.valueOf(deliveryAttrs.getNamedItem("externalized").getNodeValue()));
        }
        catch (Exception e) {
            session.setExternalized(false);
        }
        try {
            session.setSessionConf(deliveryAttrs.getNamedItem("configurationCode").getNodeValue());
        }
        catch (Exception e) {
            session.setSessionConf("");
        }
        try {
            session.setBuildUser(deliveryAttrs.getNamedItem("buildUser").getNodeValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            session.setBuildDate(deliveryAttrs.getNamedItem("buildDate").getNodeValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            session.setVersion(deliveryAttrs.getNamedItem("version").getNodeValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            session.setDescription(deliveryAttrs.getNamedItem("description").getNodeValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            session.setPackageId(deliveryAttrs.getNamedItem("packageId").getNodeValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        session.setDlvId(deliveryAttrs.getNamedItem("id").getNodeValue());
        String dynamicName = null;
        try {
            dynamicName = deliveryAttrs.getNamedItem("dynamicName").getNodeValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            session.setAllowedScriptErrors(Boolean.valueOf(deliveryAttrs.getNamedItem("allowedScriptErrors").getNodeValue()));
        }
        catch (Exception e) {
            session.setAllowedScriptErrors(false);
        }
        try {
            session.setAllowedVariableErrors(Boolean.valueOf(deliveryAttrs.getNamedItem("allowedVariableErrors").getNodeValue()));
        }
        catch (Exception e) {
            session.setAllowedVariableErrors(false);
        }
        Node _root = doc.getFirstChild();
        NodeList list = _root.getChildNodes();
        ArrayList<Node> connections = new ArrayList<Node>();
        ArrayList<Node> steps = new ArrayList<Node>();
        ArrayList<Node> processes = new ArrayList<Node>();
        ArrayList<Node> paremeterAndAltIds = new ArrayList<Node>();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeName().equals("connection")) {
                connections.add(node);
            } else if (node.getNodeName().equals("process")) {
                processes.add(node);
                NodeList _list = node.getChildNodes();
                int j = 0;
                while (j < _list.getLength()) {
                    Node _node = _list.item(j);
                    if (_node.getNodeName().equals("step")) {
                        steps.add(_node);
                    }
                    ++j;
                }
            } else if (node.getNodeName().equals("altId")) {
                paremeterAndAltIds.add(node);
            } else if (node.getNodeName().equals("parameter")) {
                paremeterAndAltIds.add(node);
            }
            ++i;
        }
        StoreManager.reverseConnection(connections, session);
        StoreManager.reverseStep(steps, session);
        StoreManager.reverseProcess(processes, paremeterAndAltIds, session, idRoot, dynamicName, nlForFirstAction);
        connections.clear();
        steps.clear();
        processes.clear();
        paremeterAndAltIds.clear();
        try {
            StoreManager.addEvents(session);
        }
        catch (Throwable e) {
            Global.getLogger().warn("Delivery " + session.getDeliveryName() + " error during attach events", e);
        }
        return session;
    }

    private static void addEvents(SessionStatic session) throws JAXBException {
        for (EventManager conf : Global.getLoadEventsManager()) {
            for (ActionStatic as : session.allStaticActionsByName.values()) {
                Collection<ActionEventProvider> actionListeners = conf.staticActionEvaluation(as, session);
                for (ActionEventProvider list : actionListeners) {
                    for (Event event : list.getEvents()) {
                        List<EventTrigger> triggers;
                        if (!(event instanceof SynchEvent) || (triggers = conf.eventToTrigger.get(event)) == null) continue;
                        for (EventTrigger trigger : triggers) {
                            if (!(trigger instanceof UserLog)) continue;
                            UserLog log = (UserLog)trigger;
                            Logger logger = null;
                            if (list.getTriggerOn() == ActionEventProvider.ActionTriggerOn.beforeExecution) {
                                logger = log.getBeforeLogger();
                            } else if (list.getTriggerOn() == ActionEventProvider.ActionTriggerOn.afterExecution) {
                                logger = log.getAfterLogger();
                            }
                            if (logger == null) continue;
                            as.addLogger(logger);
                        }
                    }
                }
            }
        }
    }

    private static void reverseProcess(List<Node> processes, List<Node> paremeterAndAltIds, SessionStatic session, String idRoot, String dynamicName, NodeList nlForFirstAction) throws Exception {
        for (Node nodeProcess : processes) {
            Node nodeAction;
            NamedNodeMap procAtts = nodeProcess.getAttributes();
            if (procAtts.getNamedItem("isBeginProcess").getNodeValue().equals("true")) {
                ActionStaticProcess action = new ActionStaticProcess(session, procAtts.getNamedItem("actionName").getNodeValue(), idRoot);
                session.addAction(action);
                StoreManager.addParamAltIdCdata(session, action, paremeterAndAltIds);
                session.setStartAction(action);
                action.setActionDynamicName(dynamicName);
                if (nlForFirstAction != null) {
                    try {
                        action.parseMetaInfUserLog(nlForFirstAction);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ActionStaticProcess process = (ActionStaticProcess)session.getActionByName(procAtts.getNamedItem("actionName").getNodeValue());
            NodeList nlActions = nodeProcess.getChildNodes();
            int j = 0;
            while (j < nlActions.getLength()) {
                nodeAction = nlActions.item(j);
                if (nodeAction.getNodeName().equals("step")) {
                    procAtts = nodeAction.getAttributes();
                    ActionStatic child = session.getActionByName(procAtts.getNamedItem("actionName").getNodeValue());
                    process.addAction(child);
                }
                ++j;
            }
            j = 0;
            while (j < nlActions.getLength()) {
                nodeAction = nlActions.item(j);
                if (nodeAction.getNodeName().equals("link")) {
                    procAtts = nodeAction.getAttributes();
                    ActionStatic source = session.getActionByName(procAtts.getNamedItem("sourceName").getNodeValue());
                    ActionStatic target = session.getActionByName(procAtts.getNamedItem("targetName").getNodeValue());
                    LinkStatic ls = new LinkStatic(source, target, procAtts.getNamedItem("type").getNodeValue(), new Integer(procAtts.getNamedItem("mandatory").getNodeValue()), procAtts.getNamedItem("id").getNodeValue());
                    if (procAtts.getNamedItem("bindType") != null) {
                        String bindType = procAtts.getNamedItem("bindType").getNodeValue();
                        ls.setBindType(bindType);
                    }
                    if (procAtts.getNamedItem("linkCondition") != null) {
                        ls.setCondition(procAtts.getNamedItem("linkCondition").getNodeValue());
                    }
                    ls.source.addOutgoingLink(ls);
                    ls.target.addIncomingLink(ls);
                    process.addLink(ls);
                }
                ++j;
            }
        }
    }

    private static void reverseStep(List<Node> steps, SessionStatic session) throws Exception {
        for (Node nodeAction : steps) {
            NamedNodeMap actAtts = nodeAction.getAttributes();
            ActionStatic action = actAtts.getNamedItem("type").getNodeValue().equals("Process") ? new ActionStaticProcess(session, actAtts.getNamedItem("actionName").getNodeValue(), actAtts.getNamedItem("id").getNodeValue()) : new ActionStaticCode(session, actAtts.getNamedItem("actionName").getNodeValue(), actAtts.getNamedItem("id").getNodeValue());
            try {
                action.setRestartPointMode(actAtts.getNamedItem("restartPoint").getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                action.setActionDynamicName(actAtts.getNamedItem("dynamicName").getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Node n = actAtts.getNamedItem("semaphoreName");
                if (n != null) {
                    action.setSemaphoreLockName(n.getNodeValue());
                }
            }
            catch (Exception n) {
                // empty catch block
            }
            NodeList nl = Action.parseMetaInf2(actAtts);
            action.parseMetaInfUserLog(nl);
            session.addAction(action);
            NodeList _list = nodeAction.getChildNodes();
            ArrayList<Node> list = new ArrayList<Node>();
            int i = 0;
            while (i < _list.getLength()) {
                list.add(_list.item(i));
                ++i;
            }
            StoreManager.addParamAltIdCdata(session, action, list);
            list.clear();
            if (action instanceof ActionStaticCode) {
                ((ActionStaticCode)action).setActionTechnology(actAtts.getNamedItem("technology").getNodeValue());
                if (((ActionStaticCode)action).getActionTxtCode() == null) {
                    ((ActionStaticCode)action).setActionCode("");
                }
                try {
                    if (actAtts.getNamedItem("encrypted") != null) {
                        ((ActionStaticCode)action).setIsEncrypted(Boolean.valueOf(actAtts.getNamedItem("encrypted").getNodeValue()));
                    }
                }
                catch (Exception e) {
                    ((ActionStaticCode)action).setIsEncrypted(false);
                }
                try {
                    ((ActionStaticCode)action).setModule(actAtts.getNamedItem("module").getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (actAtts.getNamedItem("stopBindOnError") != null) {
                    action.setStopBindOnError(Boolean.valueOf(actAtts.getNamedItem("stopBindOnError").getNodeValue()));
                } else {
                    action.setStopBindOnError(true);
                }
            }
            catch (Exception e) {
                action.setStopBindOnError(true);
            }
            action.setToleratedError(Boolean.parseBoolean(actAtts.getNamedItem("toleratedError").getNodeValue()));
            Integer nbCycles = new Integer(actAtts.getNamedItem("nbCycles").getNodeValue());
            action.setNbCycles(nbCycles);
            Node item = actAtts.getNamedItem("isBeginAction");
            if (item == null) continue;
            if (item.getNodeValue().equals("true")) {
                action.setBeginAction(true);
                continue;
            }
            action.setBeginAction(false);
        }
    }

    private static void reverseConnection(List<Node> connections, SessionStatic session) throws TransformerException, XPathFactoryConfigurationException, XPathExpressionException {
        for (Node nodeConn : connections) {
            ConnectionStore conn = new ConnectionStore();
            NamedNodeMap actAtts = nodeConn.getAttributes();
            conn.name = actAtts.getNamedItem("name").getNodeValue();
            conn.type = actAtts.getNamedItem("type").getNodeValue();
            NodeList nlParameters = nodeConn.getChildNodes();
            int j = 0;
            while (j < nlParameters.getLength()) {
                NamedNodeMap connAtts;
                Node nodeParameter = nlParameters.item(j);
                if (nodeParameter.getNodeName().equals("parameter")) {
                    connAtts = nodeParameter.getAttributes();
                    conn.properties.put(connAtts.getNamedItem("name").getNodeValue(), connAtts.getNamedItem("value").getNodeValue());
                }
                if (nodeParameter.getNodeName().equals("transaction")) {
                    connAtts = nodeParameter.getAttributes();
                    conn.transactions.add(connAtts.getNamedItem("name").getNodeValue());
                }
                ++j;
            }
            session.addConnection(conn);
        }
    }

    private static void addParamAltIdCdata(SessionStatic session, ActionStatic action, List<Node> nodes) {
        for (Node nodeParameter : nodes) {
            if ((nodeParameter.getNodeType() == 3 || nodeParameter.getNodeType() == 4) && action instanceof ActionStaticCode) {
                ((ActionStaticCode)action).setActionCode(nodeParameter.getNodeValue());
                continue;
            }
            if (nodeParameter.getNodeName().equals("altId")) {
                NamedNodeMap idAtts = nodeParameter.getAttributes();
                String altId = idAtts.getNamedItem("value").getNodeValue();
                String origin = idAtts.getNamedItem("origin").getNodeValue();
                session.addAltIdAssociation(altId, origin, action);
                action.addAltId(altId, origin);
                continue;
            }
            if (!nodeParameter.getNodeName().equals("parameter")) continue;
            NamedNodeMap paramAtts = nodeParameter.getAttributes();
            VariableStatic vs = new VariableStatic(action, paramAtts.getNamedItem("vName").getNodeValue(), paramAtts.getNamedItem("value").getNodeValue(), paramAtts.getNamedItem("type").getNodeValue());
            vs.action = action;
            paramAtts = nodeParameter.getAttributes();
            action.addVariable(vs);
        }
    }
}

