/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.objects.data;

import com.indy.engine.objects.data.DataFieldMetadata;
import com.indy.engine.objects.data.RelationalRecord;
import java.util.HashMap;

public class RelationalDataFlow {
    RelationalRecord firstElem = null;
    RelationalRecord lastElem = null;
    int dataFlowSize = 0;
    HashMap lstFieldsById = new HashMap();
    public HashMap lstFieldsByName = new HashMap();

    public RelationalRecord newRecord(int rId, int nbColumns) {
        RelationalRecord tmp;
        if (this.dataFlowSize == 0) {
            this.firstElem = tmp = new RelationalRecord(rId, nbColumns, null, null);
            ++this.dataFlowSize;
            this.lastElem = this.firstElem;
        } else {
            this.lastElem.nextElem = tmp = new RelationalRecord(rId, nbColumns, this.lastElem, null);
            this.lastElem = tmp;
            ++this.dataFlowSize;
        }
        return tmp;
    }

    public RelationalRecord getFirstElem() {
        return this.firstElem;
    }

    public RelationalRecord getNextElem(RelationalRecord elem) {
        if (elem == null) {
            return this.firstElem;
        }
        return elem.nextElem;
    }

    public RelationalRecord getElem(int id) {
        RelationalRecord it = this.firstElem;
        while (it != null) {
            if (it.recordId == id) {
                return it;
            }
            it = it.nextElem;
        }
        return null;
    }

    public void removeRange(int firstId, int lastId) {
        RelationalRecord it = this.firstElem;
        RelationalRecord pElem = null;
        RelationalRecord nElem = null;
        boolean notOut = true;
        if (firstId >= lastId) {
            notOut = false;
        }
        while (it != null && notOut) {
            if (it.recordId == firstId) {
                pElem = it.prevElem;
            }
            if (it.recordId == lastId) {
                nElem = it.nextElem;
                if (pElem != null) {
                    pElem.nextElem = nElem;
                }
                if (nElem != null) {
                    nElem.prevElem = pElem;
                }
                this.dataFlowSize -= lastId - firstId + 1;
                notOut = false;
            }
            if (!notOut) continue;
            it = it.nextElem;
        }
    }

    public void destroy() {
    }

    public void addColumnDesc(Integer fId, String fName, int fType) {
        DataFieldMetadata dField = new DataFieldMetadata(fId, fName, fType);
        this.lstFieldsById.put(fId, dField);
        this.lstFieldsByName.put(fName, dField);
    }

    public HashMap getLstFieldsByName() {
        return this.lstFieldsByName;
    }

    public int getNbFieds() {
        return this.lstFieldsById.size();
    }

    public DataFieldMetadata getField(Integer fId) {
        return (DataFieldMetadata)this.lstFieldsById.get(fId);
    }

    public DataFieldMetadata getField(String fName) {
        DataFieldMetadata df = this.lstFieldsByName.containsKey(fName) ? (DataFieldMetadata)this.lstFieldsByName.get(fName) : null;
        return df;
    }
}

