/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.userLog.IRecordWriter;
import com.indy.engine.userLog.Messages;
import com.indy.engine.userLog.SessionRecorder;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSessionLogWriter
implements IRecordWriter {
    boolean uniqueJSONObject = false;
    JAXBContext context;
    Marshaller marshaller;
    BufferedWriter writer = null;
    VariableRecordManager variableManager = new VariableRecordManager();

    public VariableRecordManager getVariableManager() {
        return this.variableManager;
    }

    private void registerVariableRecord(SessionRecorder.VariableRecord var) {
        String actionId = var.getAction() == null || var.getAction() != null && var.getAction().isProcess() ? var.getSessionID() : var.getAction().getActionId() + var.getAction().getActionIteration();
        this.variableManager.store(actionId, var);
    }

    protected abstract void write(SessionRecorder.SessionRecord var1) throws EngineExceptionI;

    @Override
    public void writeRecord(SessionRecorder.Record record) throws EngineExceptionI {
        if (record instanceof SessionRecorder.SessionRecord) {
            if (record instanceof SessionRecorder.VariableRecord) {
                this.registerVariableRecord((SessionRecorder.VariableRecord)record);
            } else {
                this.write((SessionRecorder.SessionRecord)record);
            }
        }
    }

    public static class NotSupportedException
    extends EngineExceptionI {
        public NotSupportedException() {
            super(String.format(Messages.getString("AbstractSessionLogWriter.0"), AbstractSessionLogWriter.class.getName()));
        }
    }

    public class VariableRecordManager {
        Map<String, List<SessionRecorder.VariableRecord>> variablesRecordPerActionId = new HashMap<String, List<SessionRecorder.VariableRecord>>();
        Map<String, Long> maxVariableNum = new HashMap<String, Long>();

        synchronized void store(String variableRecordKey, SessionRecorder.VariableRecord record) {
            List<SessionRecorder.VariableRecord> l = null;
            l = this.variablesRecordPerActionId.get(variableRecordKey);
            if (l == null) {
                l = Collections.synchronizedList(new ArrayList());
                this.variablesRecordPerActionId.put(variableRecordKey, l);
            }
            l.add(record);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List<SessionRecorder.VariableRecord> consume(SessionRecorder.SessionRecord o) {
            String variableRecordKey = null;
            if (o instanceof SessionRecorder.SessionStartRecord) {
                variableRecordKey = ((SessionRecorder.SessionStartRecord)o).getSessionID();
            } else if (o instanceof SessionRecorder.SessionEndRecord) {
                variableRecordKey = ((SessionRecorder.SessionEndRecord)o).getSessionID();
            } else if (o instanceof SessionRecorder.ChildSessionRecord) {
                variableRecordKey = ((SessionRecorder.ChildSessionRecord)o).getChildSessionId();
            } else if (o instanceof SessionRecorder.ActionRecord) {
                variableRecordKey = ((SessionRecorder.ActionRecord)o).getAction().getActionId();
            }
            ArrayList<SessionRecorder.VariableRecord> variables = new ArrayList<SessionRecorder.VariableRecord>();
            List<SessionRecorder.VariableRecord> cur = this.variablesRecordPerActionId.get(variableRecordKey);
            if (cur == null) {
                return null;
            }
            List<SessionRecorder.VariableRecord> list = cur;
            synchronized (list) {
                HashMap<CallSite, SessionRecorder.VariableRecord> vars = new HashMap<CallSite, SessionRecorder.VariableRecord>();
                for (SessionRecorder.VariableRecord r : cur) {
                    String recordId = variableRecordKey + "/" + r.getShortName();
                    Long numSequence = this.maxVariableNum.get(recordId);
                    if (numSequence != null && numSequence >= r.getNum()) continue;
                    this.maxVariableNum.put(recordId, r.getNum());
                    vars.put((CallSite)((Object)recordId), r);
                }
                variables.addAll(vars.values());
                cur.clear();
            }
            return variables;
        }
    }
}

