/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.objects.LinkDataExchangeI;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.indy.engine.userLog.AsynchRecordWriter;
import com.indy.engine.userLog.EmptyUserLog;
import com.indy.engine.userLog.IRecordWriter;
import com.indy.engine.userLog.IUserLogI;
import com.indy.engine.userLog.IUserLogManager;
import com.indy.engine.userLog.Messages;
import com.indy.engine.userLog.MultiRecordWriter;
import com.indy.engine.userLog.RdbmsUserLog;
import com.indy.engine.userLog.SessionRecorder;
import com.indy.engine.userLog.log4j.Log4SessionLog;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.lang.reflect.Method;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserLogManagerI
implements IUserLogManager {
    private IUserLogI uLog = null;
    private IUserLogI reportLog = null;
    private IRecordWriter writer = null;
    private MainEngineI mainEngine = null;
    boolean connectionOpened = false;
    Method initUserLog;
    Method createSession;
    Method restartSession;
    Method closeSession;
    Method addProcess;
    Method finalizeProcess;
    Method addAction;
    Method finalizeAction;
    Method addChildSession;
    Method reportProperty;
    Method reportLinkChanges;
    Method getSession;
    Method getLstProperties;
    Method getLstLinkChanges;
    Method getLstChildSessions;
    Method getLstClosedSessions;
    SessionRecorder sr = new SessionRecorder();
    Map<String, SessionRecorder.CommonRecord> allRecords = Collections.synchronizedMap(new HashMap());

    public UserLogManagerI(MainEngineI pMainEngine) throws EngineExceptionI {
        try {
            this.mainEngine = pMainEngine;
            Global.dLog.write(this.mainEngine.getSessionName(), "UserLogManagerI()", Messages.getString("UserLogManagerI.0"), 0, 0, "INFO");
            Class<?> uLogClass = Class.forName(this.mainEngine.lstLogProperties.get("userLogClass"));
            this.uLog = (IUserLogI)uLogClass.newInstance();
            SynchMode synchMode = SynchMode.synch;
            if (pMainEngine.getSynchLogMode() == null) {
                String tmp = this.mainEngine.lstLogProperties.get("synchMode");
                if (tmp != null) {
                    synchMode = SynchMode.valueOf(tmp);
                }
            } else {
                synchMode = pMainEngine.getSynchLogMode();
            }
            ArrayList<IRecordWriter> writers = new ArrayList<IRecordWriter>();
            if (Log4SessionLog.isActive()) {
                writers.add(new Log4SessionLog());
            }
            if (!(this.uLog instanceof EmptyUserLog)) {
                writers.add(new RecordWriter(this.uLog));
            }
            IRecordWriter rw = writers.size() == 1 ? (IRecordWriter)writers.get(0) : new MultiRecordWriter(writers);
            this.writer = writers.size() > 0 && synchMode != SynchMode.synch ? new AsynchRecordWriter(rw, pMainEngine.engineContext.getThreadName() + "-asynchLog", synchMode == SynchMode.synchFirstLog) : rw;
            this.reportLog = Global.commandLine ? this.uLog : Global.engineServer.getULog();
            Global.dLog.write(this.mainEngine.getSessionName(), "UserLogManagerI()", Messages.getString("UserLogManagerI.1"), 0, 0, "DEBUG");
        }
        catch (ClassNotFoundException e) {
            Global.dLog.write(this.mainEngine.getSessionName(), "MainEngine -> UserLogManagerI()", Messages.getString("UserLogManagerI.2") + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI((Throwable)e);
        }
        catch (InstantiationException e) {
            Global.dLog.write(this.mainEngine.getSessionName(), "MainEngine -> UserLogManagerI()", Messages.getString("UserLogManagerI.3") + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Global.dLog.write(this.mainEngine.getSessionName(), "MainEngine -> UserLogManagerI()", Messages.getString("UserLogManagerI.4") + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI((Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.mainEngine = null;
        this.createSession = null;
        this.restartSession = null;
        this.closeSession = null;
        this.addProcess = null;
        this.finalizeProcess = null;
        this.addAction = null;
        this.finalizeAction = null;
        this.reportProperty = null;
        this.allRecords.clear();
        if (this.uLog != null) {
            this.uLog.cleanReportLog();
            this.uLog = null;
        }
    }

    @Override
    public IMemoryDelivery getSessionDelivery() throws EngineExceptionI {
        return this.reportLog.getSessionDelivery(this.mainEngine.getSessionID());
    }

    @Override
    public void initLog(Map<String, String> properties, String logName, String type) throws EngineExceptionI {
        this.uLog.initLog(properties, logName, "u");
        this.uLog.connect();
        this.connectionOpened = true;
        Global.dLog.write(this.mainEngine.getSessionName(), "UserLogManagerI --> initUserLog", Messages.getString("UserLogManagerI.5"), 0, 0, "INFO");
    }

    @Override
    public void createSession() throws EngineExceptionI {
        Global.dLog.write(this.mainEngine.getSessionName(), "UserLogManagerI --> createSession", Messages.getString("UserLogManagerI.6"), 0, 0, "INFO");
        SessionRecorder.SessionStartRecord ssr = this.sr.createSessionStartRecord(this.mainEngine);
        if (!this.filterSessions()) {
            this.writeRecord(ssr);
        } else {
            this.record(ssr);
        }
    }

    @Override
    public void restartSession() throws EngineExceptionI {
        this.allRecords.clear();
        SessionRecorder.SessionStartRecord ssr = this.sr.createSessionStartRecord(this.mainEngine);
        if (!this.filterSessions()) {
            this.writeRecord(ssr);
        } else {
            this.record(ssr);
        }
    }

    @Override
    public void closeSession() throws EngineExceptionI {
        try {
            this.mainEngine.setIsClosing(true);
            SessionRecorder.SessionEndRecord ser = this.sr.createSessionEndRecord(this.mainEngine);
            if (!this.filterSessions()) {
                this.record(ser);
            }
            if (this.mainEngine.getSessionStatus() == -1 || this.mainEngine.getSessionStatus() == -2) {
                if (this.filterSessions()) {
                    this.record(ser);
                }
                List sortedRecords = this.allRecords.values().stream().sorted(new Comparator<SessionRecorder.CommonRecord>(){

                    @Override
                    public int compare(SessionRecorder.CommonRecord o1, SessionRecorder.CommonRecord o2) {
                        return o1.offset < o2.offset ? -1 : (o1.offset == o2.offset ? 0 : 1);
                    }
                }).collect(Collectors.toList());
                for (SessionRecorder.CommonRecord record : sortedRecords) {
                    this.writeRecord(record);
                }
            } else if (!this.filterSessions()) {
                this.writeRecord(ser);
            }
        }
        finally {
            this.mainEngine.setIsClosing(false);
        }
    }

    @Override
    public void closeConnection() {
        this.connectionOpened = false;
    }

    @Override
    public void addAction(IAction action, int num) throws EngineExceptionI {
        SessionRecorder.ActionStartRecord record = this.sr.createActionStartRecord(action, num);
        if (!this.filterActions() && !action.isProcess() || !this.filterProcesses() && action.isProcess()) {
            this.writeRecord(record);
        } else {
            this.record(record);
        }
    }

    @Override
    public void addActionLog(IAction action, IAction actionPath, String path, String message, int num) throws EngineExceptionI {
        SessionRecorder.ActionLogRecord alr = this.sr.createActionLogRecord(action, actionPath, path, message, num);
        if (!this.filterActions() && !action.isProcess() || !this.filterProcesses() && action.isProcess()) {
            this.writeRecord(alr);
        } else {
            this.record(alr);
        }
    }

    @Override
    public void finalizeAction(IAction action, int num) throws EngineExceptionI {
        SessionRecorder.ActionEndRecord record = this.sr.createActionEndRecord(action, num);
        if (!this.filterActions() && !action.isProcess() || !this.filterProcesses() && action.isProcess()) {
            this.writeRecord(record);
        } else {
            this.record(record);
        }
    }

    @Override
    public long getSessionActivityDelta() {
        return this.uLog.getSessionActivityDelta();
    }

    @Override
    public void updateSessionActivity() throws EngineExceptionI {
        SessionRecorder.SessionActivityRecord sar = this.sr.createSessionActivityRecord(this.mainEngine);
        if (!this.filterSessions()) {
            this.writeRecord(sar);
        } else {
            this.record(sar);
        }
    }

    @Override
    public void addChildSession(IAction act, int iteration, String sessId) throws EngineExceptionI {
        SessionRecorder.ChildSessionRecord csr = this.sr.createChildSessionRecord(act, iteration, sessId);
        if (!this.filterSessions()) {
            this.writeRecord(csr);
        } else {
            this.record(csr);
        }
    }

    @Override
    public void reportProperty(IAction action, Variable var, int num) throws EngineExceptionI {
        SessionRecorder.VariableRecord vr = this.sr.createVariableRecord(this.mainEngine, action, var, num);
        if (!this.filterProperties()) {
            this.writeRecord(vr);
        } else {
            this.record(vr);
        }
    }

    @Override
    public void reportLinkChanges(ActionGraphLinkI agl, Boolean withTxt, Date date) throws EngineExceptionI {
        SessionRecorder.LinkRecord lr = this.sr.createLinkRecord(agl, withTxt, date);
        if (!this.filterProperties()) {
            this.writeRecord(lr);
        } else {
            this.record(lr);
        }
    }

    @Override
    public ISessionDataExchange getSession() throws EngineExceptionI {
        return this.reportLog.getSession(this.mainEngine);
    }

    @Override
    public Map<String, String> getLstChildSessions() throws EngineExceptionI {
        return this.reportLog.getLstChildSessions(this.mainEngine);
    }

    @Override
    public int getLstProperties(Map<String, Variable> lst) throws EngineExceptionI {
        return this.reportLog.getLstProperties(this.mainEngine, this.mainEngine.getNumVar(), lst);
    }

    @Override
    public Map<String, LinkDataExchangeI> getLstLinkChanges() throws EngineExceptionI {
        return this.reportLog.getLstLinkChanges(this.mainEngine);
    }

    @Override
    public int getActions(String sessionId, int sessIter, int numAction, Map<String, IActionDataExchange> lstAct) throws EngineExceptionI {
        return this.reportLog.getActions(sessionId, sessIter, numAction, lstAct);
    }

    private boolean filterProperties() {
        return this.mainEngine.getLogLevel() > -1 && this.mainEngine.getLogLevel() < 400;
    }

    private boolean filterActions() {
        return this.mainEngine.getLogLevel() > -1 && this.mainEngine.getLogLevel() < 300;
    }

    private boolean filterProcesses() {
        return this.mainEngine.getLogLevel() > -1 && this.mainEngine.getLogLevel() < 200;
    }

    private boolean filterSessions() {
        return this.mainEngine.getLogLevel() > -1 && this.mainEngine.getLogLevel() < 100;
    }

    @Override
    public void createDelivery() throws EngineExceptionI {
        SessionRecorder.DeliveryRecord dr = this.sr.createDeliveryRecord(this.mainEngine);
        if (!this.filterSessions()) {
            this.writeRecord(dr);
        } else {
            this.record(dr);
        }
    }

    private void record(SessionRecorder.CommonRecord record) throws EngineExceptionI {
        this.allRecords.put(record.getUniqueName(), record);
    }

    public void writeRecord(SessionRecorder.Record record) throws EngineExceptionI {
        this.writer.writeRecord(record);
    }

    @Override
    public boolean isConnected() {
        return this.connectionOpened;
    }

    final class RecordWriter
    implements IRecordWriter {
        IUserLogI log;

        public RecordWriter(IUserLogI log) {
            this.log = log;
        }

        @Override
        public void writeRecord(SessionRecorder.Record record) throws EngineExceptionI {
            try {
                this.log.writeRecord(record);
            }
            catch (EngineExceptionI e) {
                try {
                    if (e.getCause() instanceof SQLRecoverableException && this.log instanceof RdbmsUserLog) {
                        this.log.writeRecord(record);
                    }
                }
                catch (Exception ex) {
                    Global.getLogger().warn("Another exception while retrying previous failed operation", (Throwable)ex);
                }
                throw e;
            }
        }
    }

    public static enum SynchMode {
        synch,
        asynch,
        synchFirstLog;

    }
}

