/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.common.swagger2.IOpenAPI;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.wsdl.DeliveryRestAPIHelper;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.runtime.json.JsonNode;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet2;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpStatus;

public class DeliveryRestServlet3
extends DeliveryRestServlet2 {
    public DeliveryRestServlet3(WsdlAPI wsdlAPI2) {
        super(wsdlAPI2);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(HttpStatus.OK.value());
    }

    @Override
    protected void invokeDelivery(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String query = req.getQueryString();
        if (query != null) {
            if (query.equals("swagger-ui")) {
                resp.sendRedirect(req.getContextPath() + "/swagger-ui/index.html");
                return;
            }
            if (query.equals("swagger2.json") || query.equals("openapi3.json")) {
                String jsonSchemaFileName = query;
                DeliveryRestAPIHelper.Spec spec = null;
                if (jsonSchemaFileName.equals("swagger2.json")) {
                    spec = DeliveryRestAPIHelper.Spec.SWAGGER20;
                } else if (jsonSchemaFileName.equals("openapi3.json")) {
                    spec = DeliveryRestAPIHelper.Spec.OPENAPI303;
                }
                try {
                    DeliveryRestAPIHelper.Catalog catalog = this.wsdlApi.getDeliveryRestHelper().getCatalog("default");
                    Object node = IOpenAPI.serialize((Object)catalog.getOpenAPISpec(spec).getDefinition());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    JsonNode.serialize((Object)node, (OutputStream)baos, (String)"UTF-8");
                    resp.setHeader("Content-Type", "application/json;charset=\"UTF-8\"");
                    resp.setStatus(HttpStatus.OK.value());
                    resp.getOutputStream().write(baos.toByteArray());
                    return;
                }
                catch (Exception e) {
                    this.handleError("Failed to create swagger/openApi webservice description", e, resp);
                }
            }
        }
        super.invokeDelivery(req, resp);
    }

    @Override
    protected boolean restrictOriginalName(Delivery deliv) {
        return deliv != null && deliv.getHttpRestDeliveryProperties() != null && !deliv.getHttpRestDeliveryProperties().isUrlPathTemplateNotSet();
    }
}

