/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.ExecuteAnt;
import com.semarchy.xdi.designer.generation.cli.LoggingConfigurationHelper;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import com.semarchy.xdi.security.zip.ZipArchiveThresholdInputStream;
import com.semarchy.xdi.security.zip.ZipSecureFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.felix.shell.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=patch"}, service={Command.class}, enabled=true)
public class PatchPackageShellCommand
implements Command {
    @ShellCommandParameter(commutator="package")
    private String packageLocation;
    @ShellCommandParameter(commutator="patch")
    private String patchLocation;
    @ShellCommandParameter(commutator="outputPackage")
    private String outputPackage = null;
    @ShellCommandParameter(commutator="verbose")
    private boolean debug = false;
    private ICacheService cacheService = null;
    @Reference
    private IWorkspace wksp;
    @Reference
    private IGenerationService.LoggingConfigurationFactory loggingConfigurationFactory;
    private SAXParserFactory parserFactory;
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Reference(policy=ReferencePolicy.DYNAMIC, unbind="unbindCacheService")
    public void bindCacheService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Activate
    public void activate() throws Exception {
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        this.parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        this.parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        this.parserFactory.setFeature("http://xml.org/sax/features/validation", false);
        this.parserFactory.setNamespaceAware(true);
    }

    public void unbindCacheService(ICacheService cacheService) {
        this.cacheService = null;
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        block9: {
            this.debug = false;
            this.outputPackage = null;
            this.packageLocation = null;
            this.patchLocation = null;
            PrintWriter writer = new PrintWriter(out);
            try {
                this.parseLine(line.trim().substring(this.getName().length() + 1));
            }
            catch (Exception ex) {
                ex.printStackTrace(err);
                writer.println("ERROR - Command Parsing - " + ex.getMessage());
                return;
            }
            this.outputPackage = PathResolver.resolveFileSystemPath((String)this.outputPackage);
            this.packageLocation = PathResolver.resolveFileSystemPath((String)this.packageLocation);
            this.patchLocation = PathResolver.resolveFileSystemPath((String)this.patchLocation);
            try {
                try {
                    this.logger.info("Execute {}", (Object)line);
                    IStatus res = this.perform(out, err);
                    if (res.isOK()) {
                        writer.println("SUCCESS - Patch ");
                        this.logger.info("Patched succeed");
                        break block9;
                    }
                    writer.println("ERROR - Patch - " + res.getMessage());
                    if (res.getException() != null) {
                        res.getException().printStackTrace(err);
                    }
                    this.logger.error("Patched failed", res.getException());
                }
                catch (Exception ex) {
                    writer.println("ERROR - Initialization - " + ex.getMessage());
                    writer.flush();
                    ex.printStackTrace(err);
                    err.flush();
                    writer.flush();
                }
            }
            finally {
                writer.flush();
            }
        }
    }

    private IStatus perform(PrintStream out, PrintStream err) throws Exception {
        if (this.outputPackage == null) {
            throw new Exception("Missing outputPackage argument");
        }
        if (this.packageLocation == null) {
            throw new Exception("Missing package argument");
        }
        if (this.packageLocation == null) {
            throw new Exception("Missing patch argument");
        }
        boolean autobuildEnabled = this.wksp.getDescription().isAutoBuilding();
        try {
            IStatus iStatus;
            final IProject project = this.wksp.getRoot().getProject("___patch");
            WorkspaceJob initProjectJob = new WorkspaceJob("Init Workspace Job"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFolder f;
                        boolean autobuildEnabled;
                        if (project.exists()) {
                            try {
                                project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                                PatchPackageShellCommand.this.logger.debug("deleted project __path");
                            }
                            catch (Exception ex) {
                                throw new Exception("Failed to delete existing project __patch", ex);
                            }
                        }
                        try {
                            project.create((IProgressMonitor)new NullProgressMonitor());
                            PatchPackageShellCommand.this.logger.debug("created project __path");
                        }
                        catch (Exception ex) {
                            throw new Exception("Failed to create project __patch", ex);
                        }
                        if (!project.isOpen()) {
                            try {
                                project.open((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (Exception ex) {
                                throw new Exception("Failed to open project __patch", ex);
                            }
                        }
                        if (autobuildEnabled = PatchPackageShellCommand.this.wksp.getDescription().isAutoBuilding()) {
                            PatchPackageShellCommand.this.logger.debug("disabled auto-build");
                            IWorkspaceDescription description = PatchPackageShellCommand.this.wksp.getDescription();
                            description.setAutoBuilding(false);
                            PatchPackageShellCommand.this.wksp.setDescription(description);
                        }
                        if ((f = project.getFolder("indy.build")) != null && f.exists()) {
                            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                public void run(IProgressMonitor monitor) throws CoreException {
                                    IResource[] iResourceArray = f.members();
                                    int n = iResourceArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IResource r = iResourceArray[n2];
                                        r.delete(true, (IProgressMonitor)new NullProgressMonitor());
                                        ++n2;
                                    }
                                }
                            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        return Status.OK_STATUS;
                    }
                    catch (Exception ex) {
                        return new Status(4, "com.indy.ui.build", "Patch failed during workspace init: " + ex.getMessage(), (Throwable)ex);
                    }
                }
            };
            initProjectJob.setRule((ISchedulingRule)this.wksp.getRoot());
            initProjectJob.schedule();
            initProjectJob.join();
            if (!initProjectJob.getResult().isOK()) {
                throw (Exception)initProjectJob.getResult().getException();
            }
            File packageFile = new File(this.packageLocation);
            if (!packageFile.exists() || packageFile.isDirectory()) {
                throw new Exception("The specified package " + this.packageLocation + " is not a file");
            }
            class UnzipPackageJob
            extends WorkspaceJob {
                UnzipResult packageRes;
                private final /* synthetic */ IProject val$project;
                private final /* synthetic */ File val$packageFile;

                public UnzipPackageJob(IProject iProject, File file) {
                    this.val$project = iProject;
                    this.val$packageFile = file;
                    super("Unzip package");
                    this.packageRes = null;
                    this.setRule((ISchedulingRule)PatchPackageShellCommand.this.wksp.getRoot());
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        File f = new File(this.val$project.getLocationURI());
                        this.packageRes = PatchPackageShellCommand.this.unzip(f.getAbsolutePath(), this.val$packageFile, false);
                        PatchPackageShellCommand.this.logger.debug("unzipped {}", (Object)this.val$packageFile);
                        this.val$project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        this.packageRes.quickAnalyze(this.val$project);
                    }
                    catch (Exception ex) {
                        return new Status(4, "com.indy.ui.build", "Failed to unzip package " + String.valueOf(this.val$packageFile), (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            }
            UnzipPackageJob unzipPackage = new UnzipPackageJob(project, packageFile);
            unzipPackage.schedule();
            unzipPackage.join();
            if (!unzipPackage.getResult().isOK()) {
                throw (Exception)unzipPackage.getResult().getException();
            }
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            final HashMap<String, URI> originalModels = new HashMap<String, URI>();
            for (String s : unzipPackage.packageRes.resourcesRelativePaths) {
                IResource r = project.findMember(s);
                originalModels.put(unzipPackage.packageRes.resourcesRelativePathsId.get(s), URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath()));
            }
            WorkspaceJob jj = new WorkspaceJob(""){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    PatchPackageShellCommand.this.cacheService.enableResources(originalModels);
                    return Status.OK_STATUS;
                }
            };
            jj.setRule((ISchedulingRule)this.wksp.getRoot());
            jj.schedule();
            jj.join();
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.debug("exception", (Throwable)ex);
            }
            catch (Exception ex) {
                this.logger.debug("exception", (Throwable)ex);
            }
            try {
                Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.debug("exception", (Throwable)ex);
            }
            catch (Exception ex) {
                this.logger.debug("exception", (Throwable)ex);
            }
            IFolder patchFolder = project.getFolder("__patch");
            PatchWkpsJob patchJob = new PatchWkpsJob(patchFolder);
            patchJob.setRule((ISchedulingRule)this.wksp.getRoot());
            patchJob.schedule();
            patchJob.join();
            if (!patchJob.getResult().isOK()) {
                Throwable t = patchJob.getResult().getException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new Exception(t.getMessage(), t);
            }
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            final HashMap<String, URI> patchModelURIs = new HashMap<String, URI>();
            patchJob.patchRes.quickAnalyze(project);
            for (String s : patchJob.patchRes.resourcesRelativePaths) {
                IResource r = patchFolder.findMember(s.substring(7));
                patchModelURIs.put(patchJob.patchRes.resourcesRelativePathsId.get(s), URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath()));
            }
            patchFolder.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            this.logger.debug("Enabling Patched resources {}", patchModelURIs);
            WorkspaceJob j = new WorkspaceJob("Temporisation job"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    PatchPackageShellCommand.this.cacheService.enableResources(patchModelURIs);
                    PatchPackageShellCommand.this.logger.debug("Enabled patch model in workspace ");
                    return Status.OK_STATUS;
                }
            };
            j.setRule((ISchedulingRule)this.wksp.getRoot());
            j.schedule();
            j.join();
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            IWorkspaceDescription description = this.wksp.getDescription();
            this.logger.debug("Enabled auto-build");
            description.setAutoBuilding(true);
            this.wksp.setDescription(description);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            this.logger.debug("Joined mapping build");
            StringBuilder paths = new StringBuilder();
            for (String s : unzipPackage.packageRes.processesId) {
                URI uri = this.cacheService.findResourceURIByFileId(s);
                if (uri == null) {
                    if (s.endsWith("-proc") && (uri = this.cacheService.findResourceURIByFileId(s.substring(0, s.length() - 5))) != null) {
                        throw new Exception("The package contains a delivery based on the Mapping id=" + s.substring(0, s.length() - 5) + " which does not seem to be built");
                    }
                    throw new Exception("Unable to find the process id=" + s + " in the workspace");
                }
                IFile r = (IFile)this.wksp.getRoot().findMember(URIUtils.toPath((URI)uri));
                paths.append(FileLocator.resolve((URL)r.getLocationURI().toURL()).getFile());
                paths.append("|");
                paths.append(r.getFullPath().makeAbsolute().toString());
                paths.append(";");
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            File outputPackageFile = new File(this.outputPackage);
            String confName = outputPackageFile.getAbsolutePath().substring(outputPackageFile.getAbsolutePath().lastIndexOf(File.separator) + 1);
            if (confName.contains(".")) {
                confName = confName.substring(0, confName.indexOf("."));
            }
            options.put("com.indy.launchers.configurations.packageOutputName", confName + ".pck");
            options.put("com.indy.launchers.configurations.packageOutputConfName", confName);
            options.put("package.multiProc.paths", paths.toString());
            options.put("package.multiProc.generateDocumentation", "" + unzipPackage.packageRes.containsDocumentation);
            options.put("package.includeSources", "true");
            options.put("package.multiProc.packageId", unzipPackage.packageRes.packageId);
            outputPackageFile.getParentFile().mkdirs();
            options.put("com.indy.launchers.configurations.packageOutputFolder", outputPackageFile.getParentFile().getAbsolutePath());
            this.logger.debug("created outputFolder {}", (Object)outputPackageFile.getParentFile());
            IEvaluationConfigurationService evalService = (IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class);
            String previousConfName = evalService.getCurrentConfigurationName();
            try {
                if (unzipPackage.packageRes.conf != null && !unzipPackage.packageRes.conf.isEmpty()) {
                    evalService.setCurrentConfigurationName(unzipPackage.packageRes.conf, false);
                }
                ExecuteAnt ant = new ExecuteAnt(null);
                IStatus res = ant.run("package.multiProc", IGenerationService.EnvironmentInitializer.of(options, null), this.debug ? LoggingConfigurationHelper.createLoggingConfiguration((IGenerationService.LoggingConfigurationFactory)this.loggingConfigurationFactory, (PrintStream)out, (PrintStream)err) : null);
                this.logger.debug("executed Package Generation Job");
                iStatus = res;
            }
            catch (Throwable throwable) {
                evalService.setCurrentConfigurationName(previousConfName, false);
                throw throwable;
            }
            evalService.setCurrentConfigurationName(previousConfName, false);
            return iStatus;
        }
        finally {
            IWorkspaceDescription description = this.wksp.getDescription();
            if (description.isAutoBuilding() != autobuildEnabled) {
                description.setAutoBuilding(autobuildEnabled);
                try {
                    this.wksp.setDescription(description);
                }
                catch (Exception ex) {
                    ex.printStackTrace(err);
                }
            }
        }
    }

    private UnzipResult unzip(String outputFolder, File packageFile, boolean isPatch) throws Exception {
        boolean packageContainsSources = false;
        UnzipResult res = new UnzipResult();
        byte[] buffer = new byte[1024];
        File folder = new File(outputFolder);
        if (!folder.exists()) {
            folder.mkdir();
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (ZipSecureFile zipFile = new ZipSecureFile(packageFile);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                Throwable throwable2 = null;
                Object var15_18 = null;
                try (ZipArchiveThresholdInputStream inputStream = zipFile.getInputStream(entry);){
                    boolean proceed = false;
                    if (isPatch) {
                        if (fileName.endsWith(".md") || fileName.endsWith(".tech") || fileName.endsWith(".proc") || fileName.endsWith(".map")) {
                            proceed = true;
                            res.resourcesRelativePaths.add("__patch/" + fileName);
                        }
                    } else if (fileName.endsWith(".deliv")) {
                        proceed = true;
                        res.delivRelativePaths.add(fileName);
                    } else if (fileName.startsWith("___internal___/__src/")) {
                        if (fileName.endsWith(".md") || fileName.endsWith(".tech") || fileName.endsWith(".proc") || fileName.endsWith(".map")) {
                            packageContainsSources = true;
                            proceed = true;
                            fileName = fileName.substring(21);
                            res.resourcesRelativePaths.add(fileName);
                        }
                    } else if (fileName.startsWith("___internal___/doc/")) {
                        res.containsDocumentation = true;
                    }
                    if (!proceed) continue;
                    File newFile = new File(outputFolder + File.separator + fileName);
                    newFile.getParentFile().mkdirs();
                    Throwable throwable3 = null;
                    Object var20_25 = null;
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(newFile));){
                        int len;
                        while ((len = inputStream.read(buffer)) > 0) {
                            ((OutputStream)fos).write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        if (!isPatch && !packageContainsSources) {
            throw new Exception("The package does not contains its sources. It cannot be patched");
        }
        return res;
    }

    public String getName() {
        return "patch";
    }

    public String getShortDescription() {
        return "Patch a package from a zip file containing stambia models.";
    }

    public String getUsage() {
        return "patch <packageFullPath> <patchFullPath.zip> [-outputFolder <folder>] [-outputSuffix <suffix>] [-debug <debug>]";
    }

    public void patch(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName() + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(s + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    private class DeliveryIdExtractorHandler
    implements ContentHandler {
        String processId;
        String conf;
        String packageId;

        private DeliveryIdExtractorHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("deliv:delivery")) {
                this.processId = atts.getValue("processId");
                this.conf = atts.getValue("configurationCode");
                this.packageId = atts.getValue("packageId");
                throw new ProcessedException();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    private class IdExtractorHandler
    implements ContentHandler {
        String modelId;

        private IdExtractorHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.modelId = atts.getValue("id");
            throw new ProcessedException();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    private class PatchWkpsJob
    extends WorkspaceJob {
        private IFolder patchFolder;
        private UnzipResult patchRes;

        public PatchWkpsJob(IFolder patchFolder) {
            super("Patch Workspace Job");
            this.patchFolder = patchFolder;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                try {
                    this.patchFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception ex) {
                    throw new Exception("Failed to create folder " + String.valueOf(this.patchFolder), ex);
                }
                PatchPackageShellCommand.this.logger.debug("created folder /__patch");
                File patchFile = new File(PatchPackageShellCommand.this.patchLocation);
                if (!patchFile.exists() || !patchFile.isFile()) {
                    throw new Exception("The specified patch " + PatchPackageShellCommand.this.patchLocation + " is not a file");
                }
                try {
                    File f = new File(this.patchFolder.getLocationURI());
                    this.patchRes = PatchPackageShellCommand.this.unzip(f.getAbsolutePath(), patchFile, true);
                    PatchPackageShellCommand.this.logger.debug("Unzipped patch {}", (Object)patchFile);
                }
                catch (Exception ex) {
                    throw new Exception("Failed to unzip patch " + String.valueOf(patchFile), ex);
                }
                this.patchFolder.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, "com.indy.ui.build", "Patch worksapce operation failed", (Throwable)ex);
            }
        }
    }

    class ProcessedException
    extends SAXException {
        ProcessedException() {
        }
    }

    class UnzipResult {
        List<String> delivRelativePaths = new ArrayList<String>();
        List<String> resourcesRelativePaths = new ArrayList<String>();
        Map<String, String> resourcesRelativePathsId = new HashMap<String, String>();
        Set<String> processesId = new HashSet<String>();
        boolean containsDocumentation;
        String conf;
        String packageId;

        UnzipResult() {
        }

        public void quickAnalyze(IProject p) throws Exception {
            XMLReader reader;
            SAXParser parser;
            ContentHandler handler;
            InputStream is;
            IResource r;
            for (String f : this.delivRelativePaths) {
                r = p.findMember(f);
                is = null;
                handler = new DeliveryIdExtractorHandler();
                try {
                    try {
                        parser = PatchPackageShellCommand.this.parserFactory.newSAXParser();
                        reader = parser.getXMLReader();
                        reader.setContentHandler(handler);
                        is = ((IFile)r).getContents();
                        reader.parse(new InputSource(is));
                    }
                    catch (ProcessedException ex) {
                        PatchPackageShellCommand.this.logger.debug("exception while parsing", (Throwable)ex);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                PatchPackageShellCommand.this.logger.warn("exception while close", (Throwable)e);
                            }
                        }
                        this.processesId.add(handler.processId);
                        if (this.conf == null) {
                            this.conf = handler.conf;
                        }
                        if (this.packageId != null) continue;
                        this.packageId = handler.packageId;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            PatchPackageShellCommand.this.logger.warn("exception while close", (Throwable)e);
                        }
                    }
                    this.processesId.add(handler.processId);
                    if (this.conf == null) {
                        this.conf = handler.conf;
                    }
                    if (this.packageId == null) {
                        this.packageId = handler.packageId;
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        PatchPackageShellCommand.this.logger.warn("exception while close", (Throwable)e);
                    }
                }
                this.processesId.add(handler.processId);
                if (this.conf == null) {
                    this.conf = handler.conf;
                }
                if (this.packageId != null) continue;
                this.packageId = handler.packageId;
            }
            for (String f : this.resourcesRelativePaths) {
                block35: {
                    r = p.findMember(f);
                    is = null;
                    handler = new IdExtractorHandler();
                    try {
                        parser = PatchPackageShellCommand.this.parserFactory.newSAXParser();
                        reader = parser.getXMLReader();
                        reader.setContentHandler(handler);
                        is = ((IFile)r).getContents();
                        reader.parse(new InputSource(is));
                    }
                    catch (ProcessedException ex) {
                        PatchPackageShellCommand.this.logger.warn("exception", (Throwable)ex);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                PatchPackageShellCommand.this.logger.warn("exception while close", (Throwable)e);
                            }
                        }
                        break block35;
                    }
                    catch (Exception t) {
                        try {
                            PatchPackageShellCommand.this.logger.warn("exception", (Throwable)t);
                            throw t;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    PatchPackageShellCommand.this.logger.warn("exception while close", (Throwable)e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (is == null) break block35;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        PatchPackageShellCommand.this.logger.warn("exception while close", (Throwable)e);
                    }
                }
                if (((IdExtractorHandler)handler).modelId == null) {
                    throw new Exception("Unable to find Id in model " + f);
                }
                this.resourcesRelativePathsId.put(f, ((IdExtractorHandler)handler).modelId);
            }
        }
    }
}

