/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.osgihook.utils.JavaProps;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.AntProperties;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IGenerationService.class}, scope=ServiceScope.SINGLETON)
public class GenerationService
implements IGenerationService {
    @Reference
    private IGenerationService.ITaskSynchronizer taskSynchronizer;
    @Reference
    private EnvironmentInfo environmentInfo;
    private Logger logger = LogManager.getLogger(GenerationService.class);

    public void buildDelivery(URI processURI, IGenerationService.ITaskDoneHandler<String> deliveryGenerationHandler) {
        Path deliverOutputFolderPath;
        String deliveryOutputFolder = this.environmentInfo.getProperty(JavaProps.BUILD_DELIVERY_FOLDER.label());
        if (deliveryOutputFolder == null) {
            deliveryOutputFolder = JavaProps.BUILD_DELIVERY_FOLDER.getDefault();
        }
        if (!(deliverOutputFolderPath = Path.of(deliveryOutputFolder, new String[0])).isAbsolute()) {
            Location installLocation = (Location)E4InjectorHelper.getService(Location.class, (String)Location.ECLIPSE_HOME_FILTER);
            try {
                deliverOutputFolderPath = Path.of(URIUtil.toURI((URL)installLocation.getURL())).resolve(deliverOutputFolderPath);
            }
            catch (Exception e) {
                this.logger.error("Failed to resolve Path", (Throwable)e);
                Status errorStatus = new Status(4, this.getClass(), String.format("Was not able to resolve the installation location properly. Please use an absolute path to configure the property %s within configuration/config.ini file and restart the designer.", JavaProps.BUILD_DELIVERY_FOLDER.label()), (Throwable)e);
                StatusManager.getManager().handle((IStatus)errorStatus, 7);
                throw new IllegalArgumentException(errorStatus.getMessage(), e);
            }
        }
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put(AntProperties.DELIVERY_BUILD_OUTPUT_FOLDER.getPropertyName(), deliverOutputFolderPath.toString());
        this.taskSynchronizer.executeTask("delivery.procToDeliv", processURI, IGenerationService.EnvironmentInitializer.of(opts, null), deliveryGenerationHandler);
    }

    public void buildPackage(URI processURI, boolean includeDoc) {
        IGenerationService.EnvironmentInitializer initializer = IGenerationService.EnvironmentInitializer.of(null, null);
        if (includeDoc) {
            this.taskSynchronizer.executeTask("package.full.create.doc", processURI, initializer, null);
        } else {
            this.taskSynchronizer.executeTask("package.full.create", processURI, initializer, null);
        }
    }

    public void convertDeliveryToText(URI processURI) {
        this.taskSynchronizer.executeTask("compare.delivery.to.text", processURI, IGenerationService.EnvironmentInitializer.of(null, null), null);
    }

    public void buildDocumentation(URI processURI, IGenerationService.ITaskDoneHandler<String> handler) {
        this.taskSynchronizer.executeTask("documentation.procToHtml", processURI, IGenerationService.EnvironmentInitializer.of(null, null), handler);
    }
}

