/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.licence.manager.tools.composite;

import com.semarchy.xdi.license.server.model.Host;
import com.semarchy.xdi.license.server.model.Hosts;
import com.semarchy.xdi.license.server.model.Session;
import com.semarchy.xdi.license.server.model.SessionStatus;
import com.semarchy.xdi.license.server.model.Utils;
import com.stambia.ui.licence.manager.tools.Connection;
import com.stambia.ui.licence.manager.tools.composite.Messages;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.framework.wiring.BundleWiring;
import org.xml.sax.InputSource;

public abstract class HostSessionComposite
extends Composite {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private TreeViewer tv;
    private static Unmarshaller unmarshaller;
    String address;

    static {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.semarchy.xdi.license.server.model", (ClassLoader)((BundleWiring)Platform.getBundle((String)"com.indy.ui.howto.model").adapt(BundleWiring.class)).getClassLoader());
            unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public abstract String getAdress();

    public HostSessionComposite(Composite parent, int style, boolean createRefreshButton) {
        super(parent, style);
        GridLayout gd = new GridLayout();
        gd.numColumns = 1;
        this.setLayout((Layout)gd);
        if (createRefreshButton) {
            Composite c = new Composite((Composite)this, 0);
            c.setBackground(parent.getBackground());
            c.setLayout((Layout)new GridLayout(2, false));
            Button b = new Button(c, 0);
            b.setText(Messages.HostSessionComposite_2);
            b.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    HostSessionComposite.this.refresh();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            Button copy = new Button(c, 8);
            copy.setText(Messages.HostSessionComposite_3);
            copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Address;GroupCode;HostId;MacAddress;Name;OS;RemoteAddress;RemoteName;User;SessionHostId;SessionUUID;SessionLastAccess;SessionDate;SessionStatus;DesignerVersion;DesignerJVM\n");
                    Hosts hs = (Hosts)HostSessionComposite.this.tv.getInput();
                    if (hs != null) {
                        for (Host h : hs.getHost()) {
                            StringBuilder b = new StringBuilder();
                            b.append(h.getAddress());
                            b.append(";");
                            b.append(h.getGroupCode());
                            b.append(";");
                            b.append(h.getHostId());
                            b.append(";");
                            b.append(h.getMacAddress());
                            b.append(";");
                            b.append(h.getName());
                            b.append(";");
                            b.append(h.getOperatingSystem());
                            b.append(";");
                            b.append(h.getRemoteAddress());
                            b.append(";");
                            b.append(h.getRemoteName());
                            b.append(";");
                            b.append(h.getUserName());
                            b.append(";");
                            for (Session s : h.getSession()) {
                                StringBuilder bs = new StringBuilder();
                                bs.append(s.getHostId());
                                bs.append(";");
                                bs.append(s.getUuid());
                                bs.append(";");
                                try {
                                    bs.append(HostSessionComposite.this.sdf.format(s.getLastAccessDate().toGregorianCalendar().getTime()));
                                }
                                catch (Exception ex) {
                                    bs.append(s.getLastAccessDate());
                                }
                                bs.append(";");
                                try {
                                    bs.append(HostSessionComposite.this.sdf.format(s.getSessionDate().toGregorianCalendar().getTime()));
                                }
                                catch (Exception ex) {
                                    bs.append(s.getSessionDate());
                                }
                                bs.append(";");
                                bs.append(s.getStatus().name());
                                bs.append(";");
                                String v = s.getDesignerVersion();
                                bs.append(s.getDesignerVersion() != null && !s.getDesignerVersion().startsWith("18") ? s.getDesignerVersion() : "");
                                bs.append(";");
                                bs.append(s.getDesignerJvm() != null ? s.getDesignerJvm() : "");
                                buf.append(b.toString());
                                buf.append(bs.toString());
                                buf.append("\n");
                            }
                        }
                    }
                    Clipboard clipboard = null;
                    try {
                        clipboard = new Clipboard(HostSessionComposite.this.getDisplay());
                        Object[] data = new String[]{buf.toString()};
                        clipboard.setContents(data, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        if (clipboard != null) {
                            clipboard.dispose();
                        }
                    }
                }
            });
        }
        Tree tree = new Tree((Composite)this, 2050);
        GridData gdata = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gdata);
        tree.setHeaderVisible(true);
        this.tv = new TreeViewer(tree);
        this.tv.setContentProvider((IContentProvider)new HostSessionContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new HostSessionLabelProvider());
        TreeColumn tc = new TreeColumn(tree, 0);
        tc.setText(Messages.HostSessionComposite_19);
        tc.setWidth(175);
        tc = new TreeColumn(tree, 0);
        tc.setText(Messages.HostSessionComposite_20);
        tc.setWidth(60);
        tc = new TreeColumn(tree, 0);
        tc.setText(Messages.HostSessionComposite_21);
        tc.setWidth(70);
        tc = new TreeColumn(tree, 0);
        tc.setText(Messages.HostSessionComposite_22);
        tc.setWidth(150);
        tc = new TreeColumn(tree, 0);
        tc.setText(Messages.HostSessionComposite_7);
        tc.setWidth(150);
        tc = new TreeColumn(tree, 0);
        tc.setText(Messages.HostSessionComposite_8);
        tc.setWidth(150);
        this.tv.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int dir = -1;
                if (e1 instanceof Session && e2 instanceof Session) {
                    return Utils.compareSession((Session)((Session)e1), (Session)((Session)e2)) * dir;
                }
                if (e1 instanceof Host && e2 instanceof Host) {
                    try {
                        Session maxSess1 = null;
                        for (Session sess : ((Host)e1).getSession()) {
                            if (maxSess1 != null && Utils.compareSession((Session)sess, (Session)maxSess1) <= 0) continue;
                            maxSess1 = sess;
                        }
                        Session maxSess2 = null;
                        for (Session sess : ((Host)e2).getSession()) {
                            if (maxSess2 != null && Utils.compareSession((Session)sess, (Session)maxSess2) <= 0) continue;
                            maxSess2 = sess;
                        }
                        if (maxSess1 == null && maxSess2 == null) {
                            return 0 * dir;
                        }
                        if (maxSess2 == null) {
                            return 1 * dir;
                        }
                        if (maxSess1 == null) {
                            return -1 * dir;
                        }
                        return Utils.compareSession((Session)maxSess1, (Session)maxSess2) * dir;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return super.compare(viewer, e1, e2) * dir;
            }
        });
    }

    public void refresh() {
        if (this.getAdress() == null) {
            this.tv.setInput(null);
        } else {
            try {
                Connection.invoke((String)(this.getAdress() + "/hostList"), Collections.emptyMap(), r -> {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStream inputStream = r.getEntity().getContent();){
                            InputSource is = new InputSource();
                            is.setByteStream(inputStream);
                            JAXBElement elt = (JAXBElement)unmarshaller.unmarshal(is);
                            Object o = elt.getValue();
                            if (o instanceof Hosts) {
                                this.tv.setInput(o);
                                this.tv.refresh(o);
                            } else {
                                this.tv.setInput(null);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e1) {
                        this.tv.setInput(null);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.HostSessionComposite_25, (String)this.getExceptionMessage(e1));
                    }
                    return null;
                });
            }
            catch (Exception e1) {
                this.tv.setInput(null);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.HostSessionComposite_25, (String)this.getExceptionMessage(e1));
            }
        }
    }

    private String getExceptionMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e);
        if (e.getCause() != null) {
            sb.append("\n").append(e.getCause());
        }
        return sb.toString();
    }

    public abstract void handleRefreshEnvt();

    class HostSessionContentProvider
    implements ITreeContentProvider,
    IHostSessionListViewer {
        Hosts hosts;

        HostSessionContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.hosts = (Hosts)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.hosts.getHost().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Host) {
                return ((Host)parentElement).getSession().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Host) {
                return this.hosts;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] result = this.getChildren(element);
            if (result != null) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }
    }

    class HostSessionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SimpleDateFormat sdf2 = new SimpleDateFormat("mm:ss");

        HostSessionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Session) {
                Session session = (Session)element;
                if (columnIndex == 0) {
                    return HostSessionComposite.this.sdf.format(session.getSessionDate().toGregorianCalendar().getTime());
                }
                if (columnIndex == 2) {
                    if (session.getStatus() == SessionStatus.ACTIVE) {
                        long c = System.currentTimeMillis() - session.getSessionDate().toGregorianCalendar().getTimeInMillis();
                        Object s = this.sdf2.format(new Date(c));
                        long l = c / 1000L / 60L / 60L;
                        s = l + ":" + (String)s;
                        return s;
                    }
                    return null;
                }
                if (columnIndex == 1) {
                    return session.getStatus().toString();
                }
                if (columnIndex == 3) {
                    return HostSessionComposite.this.sdf.format(session.getLastAccessDate().toGregorianCalendar().getTime());
                }
                if (columnIndex == 4) {
                    if (session.getDesignerVersion() != null && !session.getDesignerVersion().startsWith("18") && !session.getDesignerVersion().startsWith("17")) {
                        return session.getDesignerVersion();
                    }
                    return Messages.HostSessionComposite_0;
                }
                if (columnIndex == 5) {
                    if (session.getDesignerJvm() != null) {
                        return session.getDesignerJvm();
                    }
                    return Messages.HostSessionComposite_12;
                }
            }
            if (element instanceof Host) {
                Host host = (Host)element;
                if (columnIndex == 0) {
                    String tmp = host.getUserName() + "@";
                    tmp = host.getName() != null ? tmp + host.getName() : tmp + host.getAddress();
                    return tmp;
                }
                if (columnIndex == 1) {
                    for (Session session : host.getSession()) {
                        if (session.getStatus() != SessionStatus.ACTIVE) continue;
                        return SessionStatus.ACTIVE.toString();
                    }
                    return SessionStatus.INACTIVE.toString();
                }
            }
            return null;
        }
    }

    static interface IHostSessionListViewer {
    }
}

