/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AMQPReceiveMessageActionCodeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPFileReceiver;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.ResultSet;

public class AMQPReceiveFileActionCodeI
extends AMQPReceiveMessageActionCodeI {
    long totalFileSize = 0L;
    boolean askToClose = false;

    public AMQPReceiveFileActionCodeI() {
        this.needToBeBinded = false;
    }

    @Override
    protected void initReceiver() {
        this.jfs = new AMQPFileReceiver();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        String outFileDir;
        super.prepare(rSet);
        Object outFileMask = null;
        outFileMask = this.getLocalStringBindedParameter(rSet, "OUT_FILE_PATTERN", null);
        if (outFileMask == null) {
            outFileMask = this.getActionContext().getSessionId() + "-[AMQP_MESSAGE_NUMBER].data";
        }
        if ((outFileDir = this.getLocalStringBindedParameter(rSet, "OUT_FILE_DIR", null)) == null) {
            File file = new File((String)outFileMask);
            if (!file.isAbsolute()) throw new EngineExceptionI(Messages.getString("AMQP.ERROR_007"));
            ((AMQPFileReceiver)this.jfs).setReceiveDirectory(file.getParent());
            ((AMQPFileReceiver)this.jfs).setFileMask(file.getName());
            return;
        } else {
            ((AMQPFileReceiver)this.jfs).setFileMask((String)outFileMask);
            ((AMQPFileReceiver)this.jfs).setReceiveDirectory(outFileDir);
        }
    }

    @Override
    protected void fireStatistic(int messageCount) {
        super.fireStatistic(messageCount);
        this.totalFileSize += (long)((AMQPFileReceiver)this.jfs).getFileSize();
        this.publishVariable("OUT_FILE_SIZE", this.totalFileSize);
        this.publishVariable("OUT_NB_FILES", messageCount + 1);
    }

    @Override
    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (th != null) {
            th.interrupt();
        }
        if (!this.askToClose) {
            this.askToClose = true;
        }
    }
}

