/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.AntWaitFiles;
import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.tools.ant.BuildException;

public class FileWaitActionCodeI
extends AntActionCodeTypeI {
    AntWaitFiles fileManager;
    private String waitFile;
    private String waitDir;
    private String sExcludes;
    private String sIncludes;
    private long timeOut;
    private long pollint;
    private int expectedFileNumber;
    private Boolean casesensitive;
    private Boolean defaultExcludes;
    private static final String DEBUG = "DEBUG";

    public FileWaitActionCodeI() {
        this.actionCodeName = "Delete File Class";
        this.actionClassName = "FileDeleteActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("FileWaitActionCodeI.0"), 3, DEBUG);
        this.setStandardConnectionParameters(rSet);
        this.waitDir = this.getLocalStringBindedParameter(rSet, "WAIT_FILE_DIR", "");
        this.waitFile = this.getLocalStringBindedParameter(rSet, "WAIT_FILE", "");
        this.sIncludes = this.getLocalStringBindedParameter(rSet, "WAIT_FILE_INCLUDES", "");
        this.sExcludes = this.getLocalStringBindedParameter(rSet, "WAIT_FILE_EXCLUDES", "");
        if (this.waitFile.isEmpty() && this.waitDir.isEmpty()) {
            throw new EngineExceptionI(Messages.getString("FileWaitActionCodeI.1"));
        }
        if (!(!this.waitDir.isEmpty() || this.sIncludes.isEmpty() && this.sExcludes.isEmpty())) {
            throw new EngineExceptionI(Messages.getString("FileWaitActionCodeI.2"));
        }
        this.expectedFileNumber = this.getLocalIntegerBindedParameter(rSet, "WAIT_FILE_NB_FILES", 1);
        this.timeOut = this.getLocalLongBindedParameter(rSet, "WAIT_FILE_TIMEOUT", -99L);
        if (this.timeOut == -99L) {
            this.timeOut = this.expectedFileNumber == -1 ? 0L : -1L;
        }
        this.pollint = this.getLocalLongBindedParameter(rSet, "WAIT_FILE_POLLINT", 1000L);
        this.casesensitive = this.getLocalBooleanBindedParameter(rSet, "WAIT_FILE_CASE_SENSITIVE", true);
        this.defaultExcludes = this.getLocalBooleanBindedParameter(rSet, "WAIT_FILE_DEFAULT_EXLUDES", true);
        this.debugLog("prepare", Messages.getString("FileWaitActionCodeI.3"), 3, DEBUG);
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", Messages.getString("FileWaitActionCodeI.4") + this.connectionName, 3, DEBUG);
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("FileWaitActionCodeI.5"), 3, DEBUG);
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
        }
        int handledFileNumber = this.fileManager != null ? this.fileManager.getHandledFileNumber() : 0;
        this.fileManager = new AntWaitFiles(this.casesensitive, this.defaultExcludes, this.isRdbmsLinked, this, this.expectedFileNumber, handledFileNumber, this.pollint, this.timeOut);
        this.fileManager.setAntProject(this.project);
        try {
            String[] lstExcludes;
            String[] lstIncludes;
            if (this.jdbcConnection != null) {
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isTransactionAutoCommit());
            }
            if (!this.waitDir.isEmpty()) {
                File waitDirectory = new File(this.waitDir);
                this.fileManager.setDir(waitDirectory);
                if (this.waitFile.isEmpty() && this.sIncludes.isEmpty()) {
                    this.sIncludes = "**" + File.separator + "*";
                }
            }
            if (!this.waitFile.isEmpty()) {
                this.fileManager.setFile(new File(this.waitFile));
            }
            if (!this.sIncludes.isEmpty() && (lstIncludes = this.sIncludes.split(";")) != null && lstIncludes.length > 0) {
                lstIncludes = this.removeSpacesFromFilePattern(lstIncludes);
                this.fileManager.appendIncludes(lstIncludes);
            }
            if (!this.sExcludes.isEmpty() && (lstExcludes = this.sExcludes.split(";")) != null && lstExcludes.length > 0) {
                lstExcludes = this.removeSpacesFromFilePattern(lstExcludes);
                this.fileManager.appendExcludes(lstExcludes);
            }
            this.fileManager.execute();
            if (this.fileManager.getPreparedStatementToResultSet() != null) {
                this.fileManager.getPreparedStatementToResultSet().end();
            }
            this.publishCumulativeVariable("FILE_NB", String.valueOf(this.fileManager.getHandledFileNumber() - handledFileNumber), "Integer", false);
            this.publishCumulativeVariable("NB_FILES", String.valueOf(this.fileManager.getHandledFileNumber() - handledFileNumber), "Integer", false);
        }
        catch (BuildException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("FileWaitActionCodeI.6") + e.getMessage(), "String");
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("FileWaitActionCodeI.7") + e.getMessage(), "String");
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }

    private String[] removeSpacesFromFilePattern(String[] lstIncludes) {
        int i = 0;
        while (i < lstIncludes.length) {
            String include = lstIncludes[i];
            if (include.length() > 0) {
                lstIncludes[i] = include.replaceFirst("^\\s*", "");
            }
            ++i;
        }
        return lstIncludes;
    }
}

