/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.JMSBaseAction;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.jms.JMSException;
import java.sql.ResultSet;
import javax.naming.NamingException;

public class JMSOperationActionCodeI
extends JMSBaseAction {
    private Operation operation;

    public JMSOperationActionCodeI() {
        super("JMSOperationActionCodeI", true);
    }

    @Override
    public void doExecute() throws Throwable {
        try {
            this.setConnection();
            this.setSession();
            if (this.operation == Operation.commit) {
                this.jmsConnection.commitSession(this.jmsSessionName);
            } else if (this.operation == Operation.rollback) {
                this.jmsConnection.rollbackSession(this.jmsSessionName);
            } else if (this.operation == Operation.closesession) {
                this.jmsConnection.closeSession(this.jmsSessionName);
            } else if (this.operation == Operation.recoversession) {
                this.jmsConnection.recoverSession(this.jmsSessionName);
            } else if (this.operation == Operation.acknowledgelastmessage) {
                this.jmsConnection.acknowledgeSession(this.jmsSessionName);
            } else if (this.operation == Operation.opensession) {
                this.jmsConnection.createSession(this.jmsSessionName, this.acknowLedgePolicy);
            }
        }
        catch (JMSException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (NamingException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    @Override
    public void prepare(ResultSet rSet) throws EngineExceptionI {
        super.prepare(rSet);
        this.operation = Operation.valueOf(this.getLocalStringBindedParameter(rSet, "JMS_OPERATION", "commit").toLowerCase());
    }

    static enum Operation {
        nothing,
        rollback,
        commit,
        opensession,
        closesession,
        acknowledgelastmessage,
        recoversession;

    }
}

