/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.action.common.IAutomaticSemaphore;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.loader.JdbcBinder;
import com.indy.engine.common.sql.SqlUtils;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.common.KeyWord;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigInteger;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JdbcActionCodeI
extends ActionCodeTypeI
implements IAutomaticSemaphore {
    private static final String ACTION_TYPE_DDL_DML = "DDL_DML";
    private static final String ACTION_TYPE_SELECT = "SELECT";
    private static final String TRANSACTION_TYPE_COMMIT = "COMMIT";
    private static final String ACTION_TYPE_DELETE = "DELETE";
    private static final String ACTION_TYPE_UPDATE = "UPDATE";
    private static final String ACTION_TYPE_INSERT = "INSERT";
    private static final long DEFAULT_POLLINT_VALUE = 10000L;
    String sqlActionType;
    Integer sqlBatchSize;
    Integer sqlTransCommitNb;
    Statement dmlStatement = null;
    PreparedStatement batchPreparedStatement;
    BindExpressionReplacer.BindedExpressionPlaceHolder trgSQLTxtCode;
    List<String> lstColsToBind = null;
    boolean sqlWaitData = false;
    long sqlWaitTimeout = -1L;
    long sqlWaitPollint = 10000L;
    int sqlWaitNbRows = 1;
    String sqlWaitCountSelect = null;
    List<String> sqlNamedObjectList = new ArrayList<String>();
    int batchSize;
    int sqlNbRows = 0;
    String typeStatistiques;
    boolean isEmptyCode = false;
    private boolean multiQuery;
    private String multiQuerySeparators;
    private String multiQueryExclusionsRules;
    boolean toBatch = false;
    JdbcBinder binder;
    private boolean sqlDisableNbRowsStatistic;
    Set<Integer> sqlDisableNbRowsStatisticPosition = new HashSet<Integer>();
    int[] index = new int[0];
    long sqlNbRowsTotal = 0L;

    public JdbcActionCodeI() {
        this.actionCodeName = "JDBC Operation";
        this.actionClassName = "JdbcActionCodeI";
        this.connectionName = "";
        this.sqlActionType = "";
        this.sqlTransName = null;
        this.sqlTransType = null;
        this.sqlTransCommitNb = null;
        this.dmlStatement = null;
        this.batchPreparedStatement = null;
        this.batchSize = 0;
        this.bNullCodeAllowed = true;
        this.binder = new JdbcBinder(this);
    }

    private boolean isTimeOut(long debTime) {
        return BigInteger.valueOf(System.currentTimeMillis()).compareTo(BigInteger.valueOf(debTime).add(BigInteger.valueOf(this.sqlWaitTimeout))) > 0;
    }

    public void stopAction(Thread th) {
        block17: {
            this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.0"), 1, this.actionLevel, "DEBUG");
            this.setStoppingAction(true);
            try {
                if (this.dmlStatement != null) {
                    this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.2"), 1, this.actionLevel, "ERROR");
                    try {
                        this.dmlStatement.cancel();
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    this.dmlStatement.close();
                    this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.3"), 1, this.actionLevel, "ERROR");
                    th.interrupt();
                    this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.4"), 1, this.actionLevel, "ERROR");
                }
                if (this.sqlActionType != null) {
                    if (this.sqlActionType.equals(ACTION_TYPE_DDL_DML) || this.sqlActionType.equals(ACTION_TYPE_SELECT) && this.sqlWaitData) {
                        this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.1"), 1, this.actionLevel, "DEBUG");
                        if (this.dmlStatement == null) {
                            th.interrupt();
                        }
                    }
                    if (this.sqlActionType.equals(ACTION_TYPE_DDL_DML)) break block17;
                    this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.5"), 1, this.actionLevel, "DEBUG");
                    if (this.actionContext.isSrcBindedAction()) {
                        IActionBind aBind = this.actionContext.getSrcBind(this.actionName);
                        if (aBind != null) {
                            aBind.setBindKilling(true);
                            aBind.notifyFetch();
                        }
                        th.interrupt();
                    } else if (this.actionContext.isTrgBindedAction()) {
                        th.interrupt();
                        try {
                            if (this.getCurrentRSet() != null) {
                                ResultSet rs = this.getCurrentRSet();
                                rs.close();
                            }
                        }
                        catch (Exception e) {
                            this.logger.warn("unexpected", (Throwable)e);
                        }
                    } else {
                        th.interrupt();
                    }
                    this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.6"), 1, this.actionLevel, "DEBUG");
                    break block17;
                }
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.7"), 1, this.actionLevel, "DEBUG");
                th.interrupt();
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.8"), 1, this.actionLevel, "ERROR");
                th.interrupt();
            }
            catch (Exception e) {
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", this.actionName + Messages.getString("JdbcActionCodeI.9"), 1, this.actionLevel, "ERROR");
            }
        }
    }

    public int prepareSetConnection(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        try {
            this.sqlTransName = this.getStringBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
        }
        catch (Exception e) {
            this.logger.debug("cannot get parameter", (Throwable)e);
            this.sqlTransName = "T1";
        }
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = this.getStringBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_ISOLATION");
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("error while reading parameter", (Throwable)e);
        }
        this.setTransactionAndCommit(this.getLocalStringParameter("SQL_TRANSACTION_TYPE", null), this.sqlActionType.equals(ACTION_TYPE_SELECT));
        try {
            this.sqlTransCommitNb = this.getIntegerBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_COMMIT_NB");
        }
        catch (Exception e) {
            this.logger.debug("cannot get parameter", (Throwable)e);
            this.sqlTransCommitNb = -1;
        }
        return ret;
    }

    public int prepareSetConnection() throws EngineExceptionI {
        int ret = 0;
        this.setTransactionAndCommit(this.getLocalStringParameter("SQL_TRANSACTION_TYPE", null), this.sqlActionType.equals(ACTION_TYPE_SELECT));
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_ISOLATION");
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("error while reading parameter", (Throwable)e);
        }
        try {
            this.sqlTransName = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
        }
        catch (Exception e) {
            this.logger.debug("cannot get parameter", (Throwable)e);
            this.sqlTransName = "T1";
        }
        try {
            this.sqlTransCommitNb = this.getIntegerParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_COMMIT_NB");
        }
        catch (Exception e) {
            this.logger.debug("cannot get parameter", (Throwable)e);
            this.sqlTransCommitNb = -1;
        }
        return ret;
    }

    public void finalizeBadDirectBindedFetch() throws EngineExceptionI {
        if (!this.sqlActionType.equals(ACTION_TYPE_DDL_DML)) {
            if (this.sqlActionType.equals(ACTION_TYPE_INSERT) || this.sqlActionType.equals(ACTION_TYPE_UPDATE) || this.sqlActionType.equals(ACTION_TYPE_DELETE)) {
                try {
                    if (this.jdbcConnection != null && !this.jdbcConnection.getAutoCommit()) {
                        this.jdbcConnection.rollback();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
            }
            try {
                this.endBatchStatement(true);
            }
            catch (SQLException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.jdbcConnection = null;
    }

    private int executeUpdate() throws SQLException {
        this.toBatch = false;
        return this.batchPreparedStatement.executeUpdate();
    }

    private void addBatch() throws SQLException {
        this.batchPreparedStatement.addBatch();
        this.toBatch = true;
    }

    private int[] executeBatch() throws SQLException {
        if (this.toBatch) {
            this.toBatch = false;
            int[] ret = this.batchPreparedStatement.executeBatch();
            if (ret == null) {
                ret = new int[]{1};
            }
            return ret;
        }
        int[] ret = new int[1];
        return ret;
    }

    public int finalizeDirectBindedFetch(int numRecord) throws EngineExceptionI {
        int ret = 0;
        this.write(this.sessionName, "JdbcActionCode=>finalizeDirectBindedFetch", this.actionName + Messages.getString("JdbcActionCodeI.10"), 1, this.actionLevel, "INFO");
        try {
            try {
                if (!this.sqlActionType.equals(ACTION_TYPE_DDL_DML) && this.getSqlBatchSize() > 0 && numRecord >= this.batchSize && numRecord != 0 && this.batchPreparedStatement != null) {
                    int[] count;
                    int[] nArray = count = this.executeBatch();
                    int n = count.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int c = nArray[n2];
                        this.sqlNbRows += c == -2 ? 1 : c;
                        ++n2;
                    }
                    if ((this.sqlActionType.equals(ACTION_TYPE_INSERT) || this.sqlActionType.equals(ACTION_TYPE_UPDATE) || this.sqlActionType.equals(ACTION_TYPE_DELETE)) && this.sqlTransType.equals(TRANSACTION_TYPE_COMMIT)) {
                        this.jdbcConnection.commit();
                    }
                }
            }
            catch (SQLException e) {
                this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>finalizeDirectBindedFetch, " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            try {
                this.closeBatchStatement();
            }
            catch (SQLException e) {
                this.logger.warn("Cannot close statement", (Throwable)e);
            }
            this.doCloseConnection(false);
            this.jdbcConnection = null;
        }
        this.write(this.sessionName, "JdbcActionCode=>finalizeDirectBindedFetch", this.actionName + " : OK", 1, this.actionLevel, "INFO");
        return ret;
    }

    int addStatementValue(int preparedStatementParamIndex, ResultSet rSet, PreparedStatement stmt, String sourceColumnName, ResultSetMetaData sourceRSMD) throws SQLException, EngineExceptionI {
        int ret = 0;
        int sourceColumnIndex = BindExpressionReplacer.bindedVariableMatchSessionVariablePattern((String)sourceColumnName) ? -1 : this.findColumn(preparedStatementParamIndex, sourceColumnName, rSet);
        Integer colType = sourceColumnIndex != -1 ? sourceRSMD.getColumnType(sourceColumnIndex) : -1;
        try {
            this.binder.write(preparedStatementParamIndex, rSet, sourceColumnIndex, stmt, colType, this.trgSQLTxtCode);
        }
        catch (Exception e) {
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.11") + sourceColumnIndex + Messages.getString("JdbcActionCodeI.12") + preparedStatementParamIndex + ", " + e.getMessage(), "String", false);
            throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.13") + sourceColumnIndex + Messages.getString("JdbcActionCodeI.14") + preparedStatementParamIndex, (Throwable)e);
        }
        return ret;
    }

    private void closeBatchStatement() throws SQLException {
        if (this.batchPreparedStatement != null && !this.batchPreparedStatement.isClosed()) {
            this.batchPreparedStatement.close();
            this.batchPreparedStatement = null;
        }
    }

    private void endBatchStatement(boolean error) throws SQLException {
        if (this.batchPreparedStatement != null) {
            if (error) {
                try {
                    this.batchPreparedStatement.cancel();
                }
                catch (Exception e1) {
                    this.logger.warn("unexpected", (Throwable)e1);
                }
            }
            this.closeBatchStatement();
        }
    }

    private int findColumn(int i, String name, ResultSet sourceRSet) throws SQLException {
        if (this.index.length < i) {
            int[] tempIndex = Arrays.copyOf(this.index, i);
            try {
                tempIndex[i - 1] = sourceRSet.findColumn(name);
            }
            catch (SQLException e) {
                try {
                    tempIndex[i - 1] = sourceRSet.findColumn(name.toLowerCase());
                }
                catch (SQLException e2) {
                    tempIndex[i - 1] = sourceRSet.findColumn(name.toUpperCase());
                }
            }
            this.index = tempIndex;
        }
        return this.index[i - 1];
    }

    private int executeTrgDirectBindedInsert(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws SQLException, InterruptedException, EngineExceptionI {
        int ret;
        block18: {
            ret = 0;
            Iterator<String> lstCols = null;
            String colName = "";
            if (Thread.interrupted()) {
                this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.15"), 1, this.actionLevel, "ERROR");
                this.endBatchStatement(true);
                throw new InterruptedException();
            }
            ++this.batchSize;
            ret = 0;
            int i = 1;
            if (this.lstColsToBind != null) {
                lstCols = this.lstColsToBind.iterator();
            }
            try {
                if (lstCols != null) {
                    while (lstCols.hasNext()) {
                        colName = lstCols.next();
                        ret = this.addStatementValue(i, sourceRSet, this.batchPreparedStatement, colName, sourceRSMD);
                        ++i;
                    }
                }
                if (this.getSqlBatchSize() == 0) {
                    this.sqlNbRows += this.executeUpdate();
                } else {
                    this.addBatch();
                }
                if (this.sqlTransType.equals(TRANSACTION_TYPE_COMMIT) && this.sqlTransCommitNb != -1 && this.sqlTransCommitNb % this.batchSize == 0) {
                    this.jdbcConnection.commit();
                }
                if (numRecord % this.sqlBindingFetchSize == 0) {
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.16") + numRecord, 3, this.actionLevel, "INFO");
                }
                if (this.getSqlBatchSize() <= 0 || this.batchSize % this.getSqlBatchSize() != 0) break block18;
                this.publishCumulativeStatistiques(false);
                this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.17") + this.batchSize, 3, this.actionLevel, "INFO");
                try {
                    int[] count;
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.18"), 4, this.actionLevel, "INFO");
                    int[] nArray = count = this.executeBatch();
                    int n = count.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int c = nArray[n2];
                        this.sqlNbRows += c == -2 ? 1 : c;
                        ++n2;
                    }
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.19") + this.batchSize, 4, this.actionLevel, "INFO");
                }
                catch (BatchUpdateException e) {
                    SQLException e2 = e.getNextException();
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.20") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    if (e2 != null) {
                        if (e2 instanceof SQLException) {
                            this.logSqlException(e2);
                        }
                        this.logger.warn("exception", (Throwable)e2);
                        this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "BatchUpdateException : " + e.getMessage() + "\n" + e2.getMessage(), "String", false);
                    } else {
                        this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "BatchUpdateException : " + e.getMessage(), "String", false);
                    }
                    this.endBatchStatement(true);
                    throw new EngineExceptionI((Throwable)e);
                }
                catch (SQLException e) {
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.21") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "SQLException : " + e.getMessage(), "String", false);
                    this.endBatchStatement(true);
                    this.logSqlException(e);
                    throw new EngineExceptionI((Throwable)e);
                }
                catch (Exception e) {
                    this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + " : Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                    this.endBatchStatement(true);
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>executeTrgDirectBindedInsert", this.actionName + Messages.getString("JdbcActionCodeI.22") + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                this.endBatchStatement(true);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return ret;
    }

    private void doCloseConnection(boolean commit) {
        if (this.sqlTransType != null && !this.connectionName.isEmpty() && this.isTransactionAutoCommit()) {
            this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, commit);
        }
    }

    public int executeDdlDml(String txtCode) throws EngineExceptionI {
        int ret = 0;
        try {
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.23"), 2, this.actionLevel, "DEBUG");
            this.connectionName = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
            try {
                this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                ret = 0;
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.24") + e.getMessage(), 0, this.actionLevel, "ERROR");
                this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.25"), 2, this.actionLevel, "DEBUG");
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.26"), 2, this.actionLevel, "DEBUG");
            if (this.isAutoCommit()) {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.27"), 2, this.actionLevel, "DEBUG");
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)true);
            } else {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.28"), 2, this.actionLevel, "DEBUG");
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)false);
            }
            if (!this.isEmptyCode) {
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.29"), 2, this.actionLevel, "DEBUG");
                this.dmlStatement = this.jdbcConnection.createStatement();
                this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.30"), 2, this.actionLevel, "DEBUG");
                if (this.multiQuery) {
                    Object tmp = txtCode;
                    if (!((String)tmp).trim().endsWith(this.multiQuerySeparators)) {
                        tmp = (String)tmp + this.multiQuerySeparators;
                    }
                    int i = 1;
                    for (String query : SqlUtils.splitSqlScript((String)tmp, (String)this.multiQuerySeparators, (String[])this.multiQueryExclusionsRules.split(";"))) {
                        int localTmp = this.dmlStatement.executeUpdate(query);
                        if (this.sqlDisableNbRowsStatisticPosition.isEmpty() || !this.sqlDisableNbRowsStatisticPosition.contains(i)) {
                            this.sqlNbRows += localTmp;
                        }
                        ++i;
                    }
                } else {
                    int localTmp = this.dmlStatement.executeUpdate(txtCode);
                    if (this.sqlDisableNbRowsStatisticPosition.isEmpty() || !this.sqlDisableNbRowsStatisticPosition.contains(1)) {
                        this.sqlNbRows = localTmp;
                    }
                }
                if (this.sqlNbRows < 0) {
                    this.sqlNbRows = 0;
                }
                if (this.dmlStatement != null) {
                    try {
                        this.dmlStatement.close();
                        this.dmlStatement = null;
                    }
                    catch (Exception e2) {
                        this.logger.warn("unexpected", (Throwable)e2);
                    }
                }
            }
            if (this.sqlTransType.equals(TRANSACTION_TYPE_COMMIT)) {
                this.jdbcConnection.commit();
            }
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.31"), 2, this.actionLevel, "DEBUG");
        }
        catch (SQLFeatureNotSupportedException e) {
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.32") + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.33") + e.getMessage(), "String", false);
            if (!this.actionContext.getActionToleratedError() && !this.sqlTransType.equals("AUTOCOMMIT")) {
                try {
                    this.jdbcConnection.rollback();
                }
                catch (Exception e2) {
                    this.logger.warn("unexpected", (Throwable)e2);
                }
            }
            if (this.dmlStatement != null) {
                try {
                    this.dmlStatement.close();
                    this.dmlStatement = null;
                }
                catch (Exception e2) {
                    this.logger.warn("unexpected", (Throwable)e2);
                }
            }
            this.doCloseConnection(true);
            throw new EngineExceptionI((Throwable)e);
        }
        catch (SQLException e) {
            this.write(this.sessionName, "JdbcActionCode=>executeDDL_DML", this.actionName + Messages.getString("JdbcActionCodeI.34") + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.35") + e.getMessage(), "String", false);
            if (!this.actionContext.getActionToleratedError() && !this.sqlTransType.equals("AUTOCOMMIT")) {
                try {
                    this.jdbcConnection.rollback();
                }
                catch (Exception e2) {
                    this.logger.warn("unexpected", (Throwable)e2);
                }
            }
            if (this.dmlStatement != null) {
                try {
                    this.dmlStatement.close();
                    this.dmlStatement = null;
                }
                catch (Exception e2) {
                    this.logger.warn("unexpected", (Throwable)e2);
                }
            }
            this.doCloseConnection(false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws Exception {
        int ret;
        block7: {
            ret = 0;
            if (this.sqlActionType.equals(ACTION_TYPE_INSERT) || this.sqlActionType.equals(ACTION_TYPE_UPDATE) || this.sqlActionType.equals(ACTION_TYPE_DELETE)) {
                return this.executeTrgDirectBindedInsert(numRecord, sourceRSet, sourceRSMD);
            }
            if (this.sqlActionType.equals(ACTION_TYPE_DDL_DML) && (ret = this.prepareSetConnection(sourceRSet)) == 0) {
                try {
                    String realCode = this.actionContext.executeSubstitutionScript(BindExpressionReplacer.replaceBindedExpressions((ResultSet)sourceRSet, (String)this.actionTxtCode, (String)this.objectStartDelimiter, (String)this.objectEndDelimiter, (ActionCodeTypeI)this), "b");
                    if (realCode == null) {
                        this.isEmptyCode = true;
                    } else if (realCode.equals("") || StringOperations.isEmptyOrComments((String)realCode)) {
                        this.isEmptyCode = true;
                    }
                    ret = this.executeDdlDml(realCode);
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block7;
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int executeSrcBindedSelect() throws EngineExceptionI {
        ret = 0;
        try {
            block61: {
                block62: {
                    canContinue = false;
                    timeoutPassed = false;
                    debTime = 0L;
                    if (!this.sqlWaitData) break block61;
                    nbRowsReturned = -1L;
                    if (this.sqlWaitCountSelect == null) break block62;
                    debTime = System.currentTimeMillis();
                    this.dmlStatement = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);
                    if (true) ** GOTO lbl56
                }
                debTime = System.currentTimeMillis();
                try {
                    var9_14 = null;
                    var10_20 = null;
                    try {
                        stmtSelect = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);
                        try {
                            if (true) ** GOTO lbl98
                            do {
                                var9_14 = null;
                                var10_18 = null;
                                try {
                                    sourceRSet = this.dmlStatement.executeQuery(this.sqlWaitCountSelect);
                                    try {
                                        if (sourceRSet.next() == false) throw new EngineExceptionI(this.getClass().getName() + "=>executeSrcBindedSelect() : the select in the SQL_WAIT_COUNT_SELECT parameter should return a value");
                                        try {
                                            nbRowsReturned = sourceRSet.getInt(1);
                                        }
                                        catch (Exception e) {
                                            throw new EngineExceptionI(this.getClass().getName() + "=>executeSrcBindedSelect() : the select in the SQL_WAIT_COUNT_SELECT parameter should return a single numeric value");
                                        }
                                        if (nbRowsReturned >= (long)this.sqlWaitNbRows || this.isTimeOut(debTime)) {
                                            canContinue = true;
                                        } else {
                                            try {
                                                Thread.sleep(this.sqlWaitPollint);
                                            }
                                            catch (InterruptedException e) {
                                                Thread.currentThread().interrupt();
                                                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "executeSrcBindedSelect : Pollint not possible : " + e.getMessage(), "String", false);
                                                throw new EngineExceptionI(this.getClass().getName() + "=>executeSrcBindedSelect() : Pollint not possible or interrupted", (Throwable)e);
                                            }
                                        }
                                        if (!Thread.interrupted()) continue;
                                        throw new InterruptedException(Messages.getString("JdbcActionCodeI.36"));
                                    }
                                    finally {
                                        if (sourceRSet != null) {
                                            sourceRSet.close();
                                        }
                                    }
                                }
                                catch (Throwable var10_19) {
                                    if (var9_14 == null) {
                                        var9_14 = var10_19;
                                        throw var9_14;
                                    }
                                    if (var9_14 == var10_19) throw var9_14;
                                    var9_14.addSuppressed(var10_19);
                                    throw var9_14;
                                }
lbl56:
                                // 2 sources

                            } while (!canContinue);
                            if (this.isTimeOut(debTime)) {
                                timeoutPassed = true;
                            }
                            break block61;
                            do {
                                if (Thread.interrupted()) {
                                    throw new InterruptedException(Messages.getString("JdbcActionCodeI.37"));
                                }
                                var12_26 = null;
                                var13_28 = null;
                                try {
                                    sourceRSet = stmtSelect.executeQuery(this.actionTxtCode);
                                    try {
                                        if (sourceRSet.getType() != 1003) {
                                            if (sourceRSet.absolute(this.sqlWaitNbRows) || this.isTimeOut(debTime)) {
                                                canContinue = true;
                                            }
                                        } else {
                                            i = 0;
                                            while (sourceRSet.next() && !canContinue) {
                                                if (++i < this.sqlWaitNbRows && !this.isTimeOut(debTime)) continue;
                                                canContinue = true;
                                            }
                                            if (!canContinue && this.isTimeOut(debTime)) {
                                                canContinue = true;
                                            }
                                        }
                                        if (canContinue) continue;
                                        try {
                                            Thread.sleep(this.sqlWaitPollint);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.38") + e.getMessage(), "String", false);
                                            throw new EngineExceptionI(this.getClass().getName() + "=>executeSrcBindedSelect() : Pollint not possible or interrupted", (Throwable)e);
                                        }
                                    }
                                    finally {
                                        if (sourceRSet != null) {
                                            sourceRSet.close();
                                        }
                                    }
                                }
                                catch (Throwable var13_29) {
                                    if (var12_26 == null) {
                                        var12_26 = var13_29;
                                        throw var12_26;
                                    }
                                    if (var12_26 == var13_29) throw var12_26;
                                    var12_26.addSuppressed(var13_29);
                                    throw var12_26;
                                }
lbl98:
                                // 3 sources

                            } while (!canContinue);
                            if (this.isTimeOut(debTime)) {
                                timeoutPassed = true;
                            }
                        }
                        finally {
                            if (stmtSelect != null) {
                                stmtSelect.close();
                            }
                        }
                    }
                    catch (Throwable var10_21) {
                        if (var9_14 == null) {
                            var9_14 = var10_21;
                            throw var9_14;
                        }
                        if (var9_14 == var10_21) throw var9_14;
                        var9_14.addSuppressed(var10_21);
                        throw var9_14;
                    }
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            if (this.sqlWaitData && timeoutPassed) {
                throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.39"));
            }
            if (this.sqlWaitData) {
                this.publishVariable("SQL_WAIT_DATA_FIRED", "true", "Boolean");
            }
            if ((aBind = this.actionContext.getSrcBind(this.actionName)) != null) {
                this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + Messages.getString("JdbcActionCodeI.40"), 3, this.actionLevel, "DEBUG");
                try {
                    this.sqlBindingFetchSize = this.getIntegerParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_FETCH_SIZE");
                }
                catch (EngineExceptionI e) {
                    this.sqlBindingFetchSize = this.sqlServerFetchSize != -1 ? Integer.valueOf(this.sqlServerFetchSize) : this.runtimeContext.DEFAULT_FETCH_SIZE;
                    this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + Messages.getString("JdbcActionCodeI.41"), 3, this.actionLevel, "DEBUG");
                }
                catch (Exception e) {
                    this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + " : Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                    ret = -1;
                    throw new EngineExceptionI((Throwable)e);
                }
                if (ret == -1) return ret;
                if (aBind.getBindType().equals("DirectBind") == false) return ret;
                this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + Messages.getString("JdbcActionCodeI.42"), 3, this.actionLevel, "INFO");
                rsb = new NotFetchedResultSetBindI(){
                    Map<String, Statement> statements = new HashMap<String, Statement>();
                    Map<String, ResultSet> resultSets = new HashMap<String, ResultSet>();

                    public synchronized ResultSet initResultSet(String id) throws SQLException {
                        try {
                            Statement st = JdbcActionCodeI.this.jdbcConnection.createStatement();
                            this.statements.put(id, st);
                            try {
                                Integer tmp = JdbcActionCodeI.this.sqlBindingFetchSize;
                                if (JdbcActionCodeI.this.sqlBindingFetchSize == null) {
                                    tmp = JdbcActionCodeI.this.runtimeContext.DEFAULT_FETCH_SIZE;
                                }
                                st.setFetchSize(tmp);
                            }
                            catch (SQLException e) {
                                JdbcActionCodeI.this.write(JdbcActionCodeI.this.sessionName, "JdbcActionCodeI=>NotFetchedResultSetBindI.initResultSet", JdbcActionCodeI.this.actionName + Messages.getString("JdbcActionCodeI.43") + e.getMessage(), 3, JdbcActionCodeI.this.actionLevel, "WARNING");
                                JdbcActionCodeI.this.addVariableWithULog(JdbcActionCodeI.this.runtimeContext.VAR_PREFIXE + JdbcActionCodeI.this.actionName + JdbcActionCodeI.this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_WARNING.getName(), Messages.getString("JdbcActionCodeI.44") + e.getMessage(), "String", false);
                            }
                            ResultSet rs = st.executeQuery(JdbcActionCodeI.this.actionTxtCode);
                            this.resultSets.put(id, rs);
                            return rs;
                        }
                        catch (SQLException t) {
                            this.closeResultSet(JdbcActionCodeI.this.getActionContext().getActionId());
                            throw t;
                        }
                    }

                    public synchronized void closeResultSet(String id) throws SQLException {
                        ResultSet rs = this.resultSets.get(id);
                        if (rs != null) {
                            rs.close();
                            this.resultSets.remove(id);
                        }
                        try {
                            try {
                                Statement st = this.statements.get(id);
                                if (st != null) {
                                    st.close();
                                }
                            }
                            catch (Exception e) {
                                JdbcActionCodeI.this.logger.warn("Cannot close statement", (Throwable)e);
                                this.statements.remove(id);
                            }
                        }
                        finally {
                            this.statements.remove(id);
                        }
                    }

                    public synchronized ResultSet getResultSet(String id) {
                        return this.resultSets.get(id);
                    }
                };
                rsb.lstParameters.put("SQL_FETCH_SIZE", new Variable("SQL_FETCH_SIZE", String.valueOf(this.sqlBindingFetchSize), "Integer"));
                rsb.lstParameters.put("SELECT_TXT_CODE", new Variable("SELECT_TXT_CODE", this.actionTxtCode, "String"));
                if (this.getDateAsTimestamp) {
                    rsb.lstParameters.put("GET_DATE_AS_TIMESTAMP", new Variable("GET_DATE_AS_TIMESTAMP", "true", "Boolean"));
                }
                aBind.addBindedObject((Object)rsb);
                aBind.setBindActif(true);
                aBind.notifyFetch();
                this.actionContext.notifyIsConnectedBindedAndRunning();
                if (aBind.verifConsommation() == -1) {
                    ret = -1;
                }
                if (this.actionContext.getIsStopping() == false) return ret;
                throw new EngineExceptionI("Stopping Action...");
            }
            if (this.sqlWaitData != false) return ret;
            if (this.sqlNamedObjectList != null && !this.sqlNamedObjectList.isEmpty()) {
                this.exposeResultSetAsNamedObjects();
                return ret;
            }
            var7_12 = null;
            var8_34 = null;
            try {
                stmtSelect = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);
                try {
                    stmtSelect.execute(this.actionTxtCode);
                    return ret;
                }
                finally {
                    if (stmtSelect != null) {
                        stmtSelect.close();
                    }
                }
            }
            catch (Throwable var8_35) {
                if (var7_12 == null) {
                    var7_12 = var8_35;
                    throw var7_12;
                }
                if (var7_12 == var8_35) throw var7_12;
                var7_12.addSuppressed(var8_35);
                throw var7_12;
            }
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + " : InterruptedException : " + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.45"), "String", false);
            throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.46"));
        }
        catch (Exception e) {
            this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + " : Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
            ret = -1;
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private void exposeResultSetAsNamedObjects() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Statement stmtSelect = JdbcActionCodeI.createResultSetStatement((Connection)this.jdbcConnection);){
            try {
                stmtSelect.setFetchSize(this.sqlBindingFetchSize != null ? this.sqlBindingFetchSize : this.runtimeContext.DEFAULT_FETCH_SIZE);
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>executeSrcBindedSelect", this.actionName + Messages.getString("JdbcActionCodeI.43") + e.getMessage(), 3, this.actionLevel, "WARNING");
                this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_WARNING.getName(), Messages.getString("JdbcActionCodeI.44") + e.getMessage(), "String", false);
            }
            for (String namedObject : this.sqlNamedObjectList) {
                namedObject = namedObject.trim();
                ResultSet sourceRSet = stmtSelect.executeQuery(this.actionTxtCode);
                this.getActionContext().getNamedObjectManager().setObject(namedObject, (Object)sourceRSet);
                this.getActionContext().getNamedObjectManager().waitReady(namedObject);
            }
            for (String namedObject : this.sqlNamedObjectList) {
                this.getActionContext().getNamedObjectManager().waitCompleted(namedObject);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret;
        block10: {
            ret = 0;
            if (this.actionTxtCode == null) {
                this.isEmptyCode = true;
            } else if (this.actionTxtCode.equals("") || StringOperations.isEmptyOrComments((String)this.actionTxtCode)) {
                this.isEmptyCode = true;
            }
            try {
                if (this.sqlActionType.equals(ACTION_TYPE_DDL_DML)) {
                    ret = this.prepareSetConnection();
                    if (ret == 0) {
                        ret = this.executeDdlDml(this.actionTxtCode);
                    }
                    break block10;
                }
                if (this.isEmptyCode && !this.sqlWaitData) {
                    this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", this.actionName + Messages.getString("JdbcActionCodeI.47"), 1, this.actionLevel, "ERROR");
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.48"));
                }
                if (this.sqlActionType.equals(ACTION_TYPE_SELECT)) {
                    ret = this.executeSrcBindedSelect();
                    break block10;
                }
                this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", this.actionName + Messages.getString("JdbcActionCodeI.49"), 1, this.actionLevel, "ERROR");
                throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.50"));
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>executeSimpleCode", this.actionName + Messages.getString("JdbcActionCodeI.51") + e.getMessage(), 1, this.actionLevel, "ERROR");
                if (!this.existsVariable(VariableType.CORE_RET_MESS.getName())) {
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.52") + e.getMessage());
                }
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.jdbcConnection = null;
        return ret;
    }

    public int prepareDirectBindedFetch(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.prepare(rSet);
        if (this.sqlActionType.equals(ACTION_TYPE_INSERT) || this.sqlActionType.equals(ACTION_TYPE_UPDATE) || this.sqlActionType.equals(ACTION_TYPE_DELETE)) {
            this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", this.actionName + Messages.getString("JdbcActionCodeI.53") + this.getSqlBatchSize(), 3, this.actionLevel, "INFO");
            this.batchSize = 0;
            this.lstColsToBind = this.getLstTxtCodeBindedParameters(this.actionTxtCode);
            try {
                if (this.sqlActionType.equals(ACTION_TYPE_INSERT) || this.sqlActionType.equals(ACTION_TYPE_UPDATE) || this.sqlActionType.equals(ACTION_TYPE_DELETE)) {
                    this.trgSQLTxtCode = BindExpressionReplacer.replaceBindedExpressions((String)this.actionTxtCode);
                    if (this.trgSQLTxtCode.getBindedExpression() == null) {
                        this.isEmptyCode = true;
                    } else if (this.trgSQLTxtCode.getBindedExpression().equals("") || StringOperations.isEmptyOrComments((String)this.trgSQLTxtCode.getBindedExpression())) {
                        this.isEmptyCode = true;
                    }
                    if (this.isEmptyCode) {
                        this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", this.actionName + Messages.getString("JdbcActionCodeI.54"), 1, this.actionLevel, "ERROR");
                        throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.55"));
                    }
                }
                try {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
                }
                catch (Exception e2) {
                    this.logger.warn("unexpected", (Throwable)e2);
                }
                this.batchPreparedStatement = this.jdbcConnection.prepareStatement(this.trgSQLTxtCode.getBindedExpression());
                try {
                    this.binder.setParameterMetadata(this.batchPreparedStatement.getParameterMetaData());
                }
                catch (Exception e) {
                    this.getActionCodeLogger().warn("JdbcActionCodeI getParameterMetaData function not Supported", (Throwable)e);
                }
                this.binder.setGetDateAsTimestamp(this.getDateAsTimestamp);
                this.binder.setSetNVarcharAsNVarchar(this.setNVarcharAsVarchar);
                this.binder.setDisableImplicitConversion(this.disableImplicitConversion);
            }
            catch (SQLException e) {
                this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", this.actionName + " : SQL Exception : " + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), "Error : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.write(this.sessionName, "JdbcActionCode=>prepareDirectBindedFetch", this.actionName + " : OK", 3, this.actionLevel, "INFO");
        return ret;
    }

    private int getSqlBatchSize() {
        if (this.sqlBatchSize == null) {
            try {
                this.sqlBatchSize = this.getIntegerParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_BATCH_SIZE");
            }
            catch (EngineExceptionI e) {
                this.sqlBatchSize = this.sqlServerBatchSize != -1 ? Integer.valueOf(this.sqlServerBatchSize) : this.runtimeContext.DEFAULT_BATCH_SIZE;
            }
        }
        return this.sqlBatchSize;
    }

    public int prepare(ResultSet rs) throws EngineExceptionI {
        this.multiQuery = this.getLocalBooleanBindedParameter(rs, "SQL_MULTI_QUERYS", this.getLocalBooleanBindedParameter(rs, "SQL_MULTI_QUERIES", false));
        this.multiQuerySeparators = this.getLocalStringBindedParameter(rs, "SQL_MULTI_QUERYS_SEPARATORS", ";");
        this.multiQueryExclusionsRules = this.getLocalStringBindedParameter(rs, "SQL_MULTI_QUERYS_EXCLUSION_PATTERNS", "--|\n;/\\*|\\*/;'");
        String tmp = this.getLocalStringBindedParameter(rs, "SQL_DISABLE_NB_ROWS_STATISTIC", "false");
        if (tmp.equals("false")) {
            this.sqlDisableNbRowsStatistic = false;
        } else if (tmp.equals("true")) {
            this.sqlDisableNbRowsStatistic = true;
        } else {
            this.sqlDisableNbRowsStatistic = false;
            try {
                String[] stringArray = tmp.split("[ ,;]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    int i = Integer.parseInt(str.trim());
                    this.sqlDisableNbRowsStatisticPosition.add(i);
                    ++n2;
                }
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        return 0;
    }

    public int prepareExecuteCode() throws EngineExceptionI {
        int ret = 0;
        this.prepare(null);
        this.typeStatistiques = this.getLocalStringBindedParameter(null, "SQL_ACTION_TYPE_STAT", null);
        try {
            this.sqlActionType = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_ACTION_TYPE");
        }
        catch (EngineExceptionI e) {
            this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", this.actionName + Messages.getString("JdbcActionCodeI.56") + e.getMessage(), 1, this.actionLevel, "ERROR");
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.57") + e.getMessage(), "String", false);
            throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.58"), (Throwable)e);
        }
        if (!this.sqlActionType.equals(ACTION_TYPE_DDL_DML)) {
            block23: {
                this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", this.actionName + Messages.getString("JdbcActionCodeI.59") + this.sqlActionType, 2, this.actionLevel, "DEBUG");
                try {
                    this.connectionName = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
                }
                catch (EngineExceptionI e) {
                    this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", this.actionName + Messages.getString("JdbcActionCodeI.60") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.61") + e.getMessage(), "String", false);
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.62"), (Throwable)e);
                }
                try {
                    this.sqlWaitData = this.getBooleanParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_DATA");
                }
                catch (Exception e) {
                    this.logger.debug("unexpected", (Throwable)e);
                }
                try {
                    this.sqlWaitPollint = this.getLongParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_POLL_INTERVAL");
                }
                catch (Exception e) {
                    this.logger.debug("unexpected", (Throwable)e);
                }
                try {
                    this.sqlWaitTimeout = this.getLongParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_TIMEOUT");
                }
                catch (Exception e) {
                    this.logger.debug("unexpected", (Throwable)e);
                }
                if (this.sqlWaitTimeout == -1L) {
                    this.sqlWaitTimeout = Long.MAX_VALUE;
                }
                try {
                    this.sqlWaitNbRows = this.getIntegerParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_NB_ROWS");
                }
                catch (Exception e) {
                    this.logger.debug("unexpected", (Throwable)e);
                }
                try {
                    this.sqlWaitCountSelect = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_WAIT_COUNT_SELECT");
                }
                catch (Exception e) {
                    this.logger.debug("unexpected", (Throwable)e);
                }
                try {
                    String tmp = this.getLocalStringParameter("SQL_DECLARE_NAMED_OBJECTS");
                    if (tmp != null) {
                        this.sqlNamedObjectList = Arrays.asList(tmp.trim().split(";"));
                    }
                }
                catch (Exception e) {
                    this.logger.debug("unexpected", (Throwable)e);
                }
                try {
                    ret = this.prepareSetConnection();
                    if (ret != 0) break block23;
                    this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                    try {
                        ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
                    }
                    catch (SQLException e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    this.binder.setSetDateAsTimestamp(this.setDateAsTimestamp);
                    ret = 0;
                }
                catch (EngineExceptionI e) {
                    this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", this.actionName + Messages.getString("JdbcActionCodeI.63") + e.getMessage(), 1, this.actionLevel, "ERROR");
                    this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), Messages.getString("JdbcActionCodeI.64") + e.getMessage(), "String", false);
                    throw new EngineExceptionI(Messages.getString("JdbcActionCodeI.65"), (Throwable)e);
                }
            }
            this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", this.actionName + Messages.getString("JdbcActionCodeI.66") + this.sqlActionType, 2, this.actionLevel, "DEBUG");
        }
        return ret;
    }

    public int finalizeExecuteCode(boolean withError) throws EngineExceptionI {
        int ret = 0;
        this.doCloseConnection(!withError);
        this.write(this.sessionName, "JdbcActionCode=>finalizeExecuteCode", this.actionName + Messages.getString("JdbcActionCodeI.67") + this.sqlNbRows, 1, this.actionLevel, "INFO");
        this.publishCumulativeStatistiques(true);
        if (this.binder != null) {
            this.binder.clear();
            this.binder = null;
        }
        this.jdbcConnection = null;
        return ret;
    }

    void publishCumulativeStatistiques(boolean last) {
        this.sqlNbRowsTotal += (long)this.sqlNbRows;
        this.sqlNbRows = 0;
        if (!this.sqlDisableNbRowsStatistic && this.sqlActionType != null && !this.sqlActionType.equals(ACTION_TYPE_SELECT)) {
            this.publishStatistic("SQL_NB_ROWS", this.sqlNbRowsTotal, last);
        }
        if (this.typeStatistiques != null) {
            this.publishStatistic("SQL_STAT_" + this.typeStatistiques, this.sqlNbRowsTotal, last);
        }
    }

    public String getDefaultSemaphoreName() {
        String transactionType = "AUTOCOMMIT";
        try {
            transactionType = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_TYPE");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("unexpected", (Throwable)e);
        }
        if (KeyWord.COMMIT_MODE.COMMIT.name().equals(transactionType) || KeyWord.COMMIT_MODE.NOCOMMIT.name().equals(transactionType)) {
            String transactionName = "T1";
            try {
                transactionName = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
            }
            catch (Exception ex) {
                this.logger.debug("unexpected", (Throwable)ex);
            }
            String connectionName = null;
            try {
                connectionName = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
            }
            catch (EngineExceptionI e) {
                this.logger.debug("unexpected", (Throwable)e);
            }
            return connectionName + "/" + transactionName;
        }
        return null;
    }
}

