/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.OSCommandWrapper;
import com.indy.engine.core.common.VariableDataType;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperatingSystemActionCodeI
extends ActionCodeTypeI {
    String strFinalActionCode = "";
    OSCommandWrapper cmdWrapper;
    String workingDir = null;
    String charset = null;
    String launcher;
    private int standatdInputLimit = -1;
    private int errorInputLimit = -1;
    List<Integer> successfulExitedCodes;
    private long timeout = -1L;
    boolean ignoreStderr = false;

    public OperatingSystemActionCodeI() {
        this.actionCodeName = "Operating System";
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (this.cmdWrapper != null) {
            this.cmdWrapper.interrupt();
        }
        if (th != null) {
            th.interrupt();
        }
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.strFinalActionCode = this.getFinalBindedCode(sourceRSet, this.actionTxtCode);
        this.executeSimpleCode();
        return ret;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.workingDir = this.getLocalStringBindedParameter(rSet, "OS_WORKING_DIR", this.runtimeContext.TEMPORARY_FOLDER);
        this.charset = this.getLocalStringBindedParameter(rSet, "OS_CHARSET", Charset.defaultCharset().name());
        this.launcher = this.getLocalStringBindedParameter(rSet, "OS_SHELL_LAUNCHER", null);
        this.standatdInputLimit = this.getLocalIntegerBindedParameter(rSet, "OS_STANDARD_INPUT_LIMIT_SIZE", -1);
        this.errorInputLimit = this.getLocalIntegerBindedParameter(rSet, "OS_ERROR_INPUT_LIMIT_SIZE", -1);
        String successfulReturnCodes = this.getLocalStringBindedParameter(rSet, "OS_SUCCESSFUL_EXIT_CODE", "0");
        this.successfulExitedCodes = new ArrayList<Integer>();
        String[] stringArray = successfulReturnCodes.split("[| ;,]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            try {
                Integer i = Integer.parseInt(str);
                this.successfulExitedCodes.add(i);
            }
            catch (Exception e) {
                throw new EngineExceptionI(Messages.getString("OperatingSystemActionCodeI.0") + str, (Throwable)e);
            }
            ++n2;
        }
        this.timeout = this.getLocalLongBindedParameter(rSet, "OS_TIMEOUT", -1L);
        this.ignoreStderr = this.getLocalBooleanBindedParameter(rSet, "OS_IGNORE_STDERR", false);
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        this.strFinalActionCode = this.actionTxtCode;
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        Integer retCode = null;
        String errorOutput = null;
        String stdOutput = null;
        try {
            if (this.launcher != null) {
                String[] strs = this.launcher.split(" ");
                String[] strs2 = Arrays.copyOf(strs, strs.length + 1);
                strs2[strs2.length - 1] = this.strFinalActionCode;
                this.cmdWrapper = OSCommandWrapper.build(Charset.forName(this.charset), strs2, new File(this.workingDir));
            } else {
                this.cmdWrapper = OSCommandWrapper.build(Charset.forName(this.charset), this.strFinalActionCode.split(" "), new File(this.workingDir));
            }
            this.cmdWrapper.waitForProcess(this.timeout);
            retCode = this.cmdWrapper.getExitValue();
            errorOutput = this.cmdWrapper.getErrorOutput(this.errorInputLimit);
            stdOutput = this.cmdWrapper.getStandardOutput(this.standatdInputLimit);
            if (!stdOutput.isEmpty()) {
                this.publishVariable("OS_RET_MESS", stdOutput, VariableDataType.String.name());
            }
            if (!errorOutput.isEmpty()) {
                this.publishVariable("OS_ERR_MESS", errorOutput, VariableDataType.String.name());
            }
            this.publishVariable("OS_RET_CODE", String.valueOf(retCode), VariableDataType.Integer.name());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), e.getMessage(), VariableDataType.String.name());
            throw new EngineExceptionI((Throwable)e);
        }
        if (!errorOutput.isEmpty() && !this.ignoreStderr) {
            throw new EngineExceptionI(Messages.getString("OperatingSystemActionCodeI.1") + errorOutput);
        }
        if (this.getStoppingAction()) {
            throw new EngineExceptionI(Messages.getString("OperatingSystemActionCodeI.2"));
        }
        if (!this.successfulExitedCodes.contains(retCode)) {
            throw new EngineExceptionI(Messages.getString("OperatingSystemActionCodeI.4") + String.valueOf(retCode) + Messages.getString("OperatingSystemActionCodeI.5") + this.successfulExitedCodes.toString().replace("[", "").replace("]", ""));
        }
        return ret;
    }
}

