/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.AntScp;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Properties;

public class ScpPutActionCodeI
extends AntActionCodeTypeI {
    String scpLocalFile = null;
    String scpLocalDir = null;
    String scpToDir = null;
    String scpExcludes = null;
    String scpIncludes = null;
    Long sshTimeout = null;
    ISecretValue scpHostname = null;
    ISecretValue scpPort = null;
    ISecretValue scpUser = null;
    ISecretValue scpPassword = null;
    Boolean scpTrust = true;
    String scpKnownHosts = null;
    String scpKeyFile = null;
    ISecretValue scpPassPhrase = null;
    Boolean scpUseSFTP = false;
    Boolean scpPreserveFileDate = false;
    ISecretValue proxyPort = null;
    ISecretValue proxyHost = null;
    ISecretValue proxyUser = null;
    ISecretValue proxyPassword = null;
    String proxyProtocol = null;
    private boolean casesensitive;
    private boolean defaultExcludes;
    String additionalConnectionProperties = null;

    public ScpPutActionCodeI() {
        this.actionCodeName = "Scp put File Class";
        this.actionClassName = "ScpPutActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.scpHostname = this.getLocalSecretBindedParameter(rSet, "SSH_HOST", null);
        this.scpUser = this.getLocalSecretBindedParameter(rSet, "SSH_USER", null);
        this.scpToDir = this.getLocalStringBindedParameter(rSet, "SCP_REMOTE_DIR");
        if (this.scpHostname.isNull() || this.scpUser.isNull() || this.scpToDir == null) {
            this.addVariableWithULog(VariableType.CORE_RET_MESS.getName(), Messages.getString("ScpPutActionCodeI.0"), "String", false);
            throw new EngineExceptionI(Messages.getString("ScpPutActionCodeI.1"));
        }
        try {
            this.scpLocalFile = this.getLocalStringBindedParameter(rSet, "SCP_LOCAL_FILE");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("no value for parameter SP_LOCAL_FILE", (Throwable)e);
        }
        this.scpPassword = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD", null));
        this.sshTimeout = this.getLocalLongBindedParameter(rSet, "SSH_TIMEOUT", null);
        this.scpPort = this.getLocalSecretBindedParameter(rSet, "SSH_PORT", null);
        this.scpLocalDir = this.getLocalStringBindedParameter(rSet, "SCP_LOCAL_DIR", null);
        this.scpIncludes = this.getLocalStringBindedParameter(rSet, "SCP_FILE_INCLUDES", "");
        this.scpExcludes = this.getLocalStringBindedParameter(rSet, "SCP_FILE_EXCLUDES", "");
        this.scpTrust = this.getLocalBooleanBindedParameter(rSet, "SSH_TRUST_HOSTS", true);
        this.scpUseSFTP = this.getLocalBooleanBindedParameter(rSet, "SCP_USE_SFTP", false);
        this.scpKnownHosts = this.getLocalStringBindedParameter(rSet, "SSH_KNOWN_HOSTS_FILE", null);
        try {
            this.scpKeyFile = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SSH_PRIVATE_KEY_FILE");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("no value for parameter private key", (Throwable)e);
            try {
                this.scpKeyFile = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SSH_PUBLIC_KEY_FILE");
            }
            catch (EngineExceptionI e1) {
                this.logger.debug("no value for parameter public key", (Throwable)e);
            }
        }
        this.setStandardConnectionParameters(rSet);
        this.scpPassPhrase = this.getLocalSecretBindedParameter(rSet, "SSH_PASSWORD_PHRASE", this.getLocalStringBindedParameter(rSet, "SSH_UNCRYPTED_PASSWORD_PHRASE", ""));
        if (this.scpLocalFile == null && this.scpLocalDir == null) {
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("ScpPutActionCodeI.2"), "String", false);
            throw new EngineExceptionI(Messages.getString("ScpPutActionCodeI.3"));
        }
        this.proxyHost = this.getLocalSecretBindedParameter(rSet, "PROXY_HOST", null);
        this.proxyPort = this.getLocalSecretBindedParameter(rSet, "PROXY_PORT", "-1");
        this.proxyProtocol = this.getLocalStringBindedParameter(rSet, "PROXY_PROTOCOL", null);
        this.proxyUser = this.getLocalSecretBindedParameter(rSet, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rSet, "PROXY_PASSWORD", this.getLocalStringBindedParameter(rSet, "PROXY_UNCRYPTED_PASSWORD", ""));
        this.casesensitive = this.getLocalBooleanParameter("SCP_CASE_SENSITIVE", true);
        this.defaultExcludes = this.getLocalBooleanParameter("SCP_DEFAULT_EXLUDES", true);
        this.scpPreserveFileDate = this.getLocalBooleanBindedParameter(rSet, "SCP_PRESERVE_FILE_DATE", false);
        this.additionalConnectionProperties = this.getLocalStringBindedParameter(rSet, "SSH_ADDITIONAL_CONNECTION_PROPERTIES", null);
        this.write(this.sessionName, this.actionClassName + "=>prepareSimpleExecuteCode", this.actionName + Messages.getString("ScpPutActionCodeI.4"), 3, this.actionLevel, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        String[] lstExcludes;
        String[] lstIncludes;
        int ret = 0;
        final AntScp antScpManager = new AntScp(this.casesensitive, this.defaultExcludes);
        antScpManager.setProject(this.project);
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", Messages.getString("ScpPutActionCodeI.5") + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("ScpPutActionCodeI.6"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
        }
        if (this.sshTimeout != null) {
            antScpManager.setTimeout(this.sshTimeout);
        }
        if (this.scpLocalFile != null) {
            try {
                File f = new File(this.scpLocalFile);
                if (!f.isFile()) {
                    throw new EngineExceptionI(Messages.getString("ScpPutActionCodeI.7"));
                }
            }
            catch (SecurityException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            antScpManager.setFile(this.scpLocalFile);
        }
        File fd = null;
        if (this.scpLocalDir != null) {
            try {
                fd = new File(this.scpLocalDir);
                if (!fd.isDirectory()) {
                    throw new EngineExceptionI(Messages.getString("ScpPutActionCodeI.8"));
                }
                antScpManager.initFileSet();
                antScpManager.getFileSet().setDir(fd);
            }
            catch (SecurityException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        if (this.isRdbmsLinked) {
            try {
                String filePath = this.scpLocalFile;
                String fileName = "";
                fileName = this.scpLocalFile.contains("\\") ? this.scpLocalFile.substring(this.scpLocalFile.lastIndexOf("\\")) : (this.scpLocalFile.contains("/") ? this.scpLocalFile.substring(this.scpLocalFile.lastIndexOf("/")) : this.scpLocalFile);
                File destFile = new File(this.scpLocalFile);
                if (this.scpLocalDir == null) {
                    this.scpLocalDir = this.scpLocalFile.replace(fileName, "");
                }
                this.insertFileInTableFile(1, this.scpLocalDir, fileName, this.scpToDir, fileName, "ScpPut", destFile, fd != null ? fd.lastModified() : -1L);
            }
            catch (EngineExceptionI e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        try {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setRemoteTodir(ScpPutActionCodeI.this.scpUser.getString(context) + (String)(!ScpPutActionCodeI.this.scpPassword.isNull() ? ":" + ScpPutActionCodeI.this.scpPassword.decryptString(context) : "") + "@" + ScpPutActionCodeI.this.scpHostname.getString(context) + ":" + ScpPutActionCodeI.this.scpToDir);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        if (!this.scpIncludes.isEmpty() && (lstIncludes = this.scpIncludes.split(";")).length > 0) {
            int i = 0;
            while (i < lstIncludes.length) {
                antScpManager.setIncludes(lstIncludes[i]);
                ++i;
            }
        }
        if (!this.scpExcludes.isEmpty() && (lstExcludes = this.scpExcludes.split(";")).length > 0) {
            int i = 0;
            while (i < lstExcludes.length) {
                antScpManager.setExcludes(lstExcludes[i]);
                ++i;
            }
        }
        if (!this.scpPort.isNull()) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setPort(Integer.parseInt(ScpPutActionCodeI.this.scpPort.getString(context)));
                    return null;
                }
            });
        }
        antScpManager.setSftp(this.scpUseSFTP);
        antScpManager.setTrust(this.scpTrust);
        antScpManager.setPreserveFileDate(this.scpPreserveFileDate);
        if (this.scpKeyFile != null) {
            antScpManager.setKeyfile(this.scpKeyFile);
        }
        if (this.scpKnownHosts != null) {
            antScpManager.setKnownhosts(this.scpKnownHosts);
        }
        if (!this.scpPassPhrase.isNull()) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setPassphrase(ScpPutActionCodeI.this.scpPassPhrase.decryptString(context));
                    return null;
                }
            });
        }
        if (!this.proxyHost.isNull()) {
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    antScpManager.setProxyHost(ScpPutActionCodeI.this.proxyHost.getString(context));
                    return null;
                }
            });
            this.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    if (ScpPutActionCodeI.this.proxyPort.getInteger(context) != -1) {
                        antScpManager.setProxyPort(ScpPutActionCodeI.this.proxyPort.getInteger(context));
                    }
                    return null;
                }
            });
            if (this.proxyProtocol != null) {
                if (this.proxyProtocol.equals("SOCKS5")) {
                    antScpManager.setProxyProtocol(5);
                } else if (this.proxyProtocol.equals("SOCKS4")) {
                    antScpManager.setProxyProtocol(4);
                } else if (this.proxyProtocol.equals("HTTP")) {
                    antScpManager.setProxyProtocol(1);
                }
            }
            if (this.proxyUser != null) {
                this.secret((ISecretStatement)new ISecretStatement<Object>(){

                    public Object execute(ISecretContext context) throws Throwable {
                        antScpManager.setProxyUser(ScpPutActionCodeI.this.proxyUser.getString(context));
                        antScpManager.setProxyPassword(ScpPutActionCodeI.this.proxyPassword.decryptString(context));
                        return null;
                    }
                });
            }
        }
        if (this.additionalConnectionProperties != null && !this.additionalConnectionProperties.trim().isEmpty()) {
            Properties props = new Properties();
            try {
                props.load(new StringReader(this.additionalConnectionProperties));
            }
            catch (IOException e) {
                throw new EngineExceptionI(Messages.getString("ScpPutActionCodeI.9"), (Throwable)e);
            }
            antScpManager.setAdditionalConnectionProperties(props);
        }
        this.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                antScpManager.execute();
                return null;
            }
        });
        this.publishCumulativeVariable("FILE_NB", String.valueOf(antScpManager.getNbFiles()), "Integer", false);
        return ret;
    }

    public int setDirectBindedFetchParameters(ResultSet rSet) throws EngineExceptionI {
        return this.prepare(rSet);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        int ret = 0;
        this.setDirectBindedFetchParameters(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

