/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.JdbcToXmlActionCodeI;
import com.indy.engine.actionCodes.file.HierarchicalFileStreamWriter;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

public class FileWriterAPI
extends AbstractXmlWriterAPI {
    private String insertMetadata;
    private String metadata;
    private String verifyLength;

    public FileWriterAPI(boolean commit, String encoding, boolean writeXmlDeclaration, String xmlVersion, File outFile, ActionCodeTypeI actionCode, String insertFileMetadata, String fileMetadata, String verifyLength, AbstractXmlWriterAPI.NoDataBehaviour noDataBehaviour, AbstractXmlWriterAPI.FileAlreadyExistsBehaviour fileAlreadyExistsBehaviour) {
        super(commit, encoding, writeXmlDeclaration, xmlVersion, outFile, actionCode, noDataBehaviour, fileAlreadyExistsBehaviour);
        this.insertMetadata = insertFileMetadata;
        this.metadata = fileMetadata;
        this.verifyLength = verifyLength;
    }

    @Override
    public void writeAttribute(JdbcToXmlActionCodeI.IndyAttribute attribute, String strValue, Object value, int sourceType) throws Exception {
        ((HierarchicalFileStreamWriter)this.getXMLStreamWriter()).writeAttribute(attribute.getAlias(), value, sourceType);
    }

    @Override
    public XMLStreamWriter createWriter(File file, boolean hasRawData) throws XMLStreamException {
        XMLInputFactory factory = null;
        try {
            factory = XMLInputFactory.newFactory();
        }
        catch (NoSuchMethodError e) {
            factory = XMLInputFactory.newInstance();
        }
        try {
            HashMap<String, String> inserts = new HashMap<String, String>();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.insertMetadata.getBytes());
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            XMLEventReader xer = factory.createXMLEventReader(bis);
            String key = null;
            while (xer.hasNext()) {
                XMLEvent se;
                XMLEvent event = xer.nextEvent();
                if (event.isStartElement()) {
                    se = event.asStartElement();
                    if (!se.getName().getLocalPart().equals("insert")) continue;
                    key = null;
                    Attribute attr = se.getAttributeByName(new QName("path"));
                    if (attr == null) continue;
                    key = attr.getValue();
                    continue;
                }
                if (event.isCharacters()) {
                    Characters chs = event.asCharacters();
                    if (key == null) continue;
                    inserts.put(key, chs.getData());
                    continue;
                }
                if (!event.isEndElement() || !(se = event.asEndElement()).getName().getLocalPart().equals("insert")) continue;
                key = null;
            }
            return new HierarchicalFileStreamWriter(file, this.metadata, inserts, this.verifyLength);
        }
        catch (FileNotFoundException | UnsupportedEncodingException | SQLException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void closeCurrent() {
    }

    @Override
    public void addRoot() {
    }

    @Override
    public void writeNewLineCharacter() throws Exception {
    }
}

