/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file.jdbc;

import com.indy.engine.actionCodes.file.jdbc.Messages;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.indy.runtime.file.DelimitedFileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

public class DelimitedRecordToResultSet {
    JdbcPreparedStatementToResultSet statement;
    private String rowSeparator;
    private String fieldSeparator;
    private String stringDelimiter;
    private String rowSeparatorReplacment;
    private String stringDelimiterReplacment;
    private SimpleDateFormat timeStampFormat;
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat dateFormat;
    int nbColumns = 1;
    int signPosition = 0;

    public void setRowSeparator(String rowSeparator, String rowSeparatorReplacment) {
        this.rowSeparator = rowSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setStringDelimiter(String stringDelimiter, String stringDelimiterReplacment) {
        this.stringDelimiter = stringDelimiter;
        this.stringDelimiterReplacment = stringDelimiterReplacment;
    }

    public void setTimeStampPattern(String timeStampPattern) {
        this.timeStampFormat = new SimpleDateFormat(timeStampPattern);
    }

    public void setDatePattern(String datePattern) {
        this.dateFormat = new SimpleDateFormat(datePattern);
    }

    public void setTimepattern(String timepattern) {
        this.timeFormat = new SimpleDateFormat(timepattern);
    }

    public NotFetchedResultSetBindI getNotFetchedResultSetBindI() {
        return this.statement.getNotFetchedResultSetBindI();
    }

    public DelimitedRecordToResultSet(String ... ids) throws SQLException {
        this.statement = new JdbcPreparedStatementToResultSet();
        this.statement.setConsumers(false, ids);
    }

    public DelimitedRecordToResultSet(RuntimeContext rc) {
        this.setTimeStampPattern(rc.GLOBAL_DATE_FORMAT);
        this.setDatePattern("yyyy/MM/dd");
        this.setTimepattern("HH:mm:ss.SSS");
    }

    public void setStatement(JdbcPreparedStatementToResultSet statement) {
        this.statement = statement;
    }

    public void addColumn(String columnName, String sqlType, int precision, int scale) throws SQLException {
        this.statement.setColumn(this.nbColumns++, columnName, sqlType, precision);
    }

    public ResultSet getResultSet(String name) throws SQLException {
        return this.statement.getResultSet(name);
    }

    public void write(InputStream is, String encoding) throws SQLException, IOException, ParseException {
        DelimitedFileReader dfr = new DelimitedFileReader(is, encoding);
        dfr.setFieldSeparator(this.fieldSeparator);
        dfr.setRowSeparator(this.rowSeparator, this.rowSeparatorReplacment);
        dfr.setStringDelimiter(this.stringDelimiter, this.stringDelimiterReplacment);
        int columnCount = this.statement.getMetaData().getColumnCount();
        int rowCount = 0;
        while (!dfr.isEndOfFile()) {
            List list = dfr.readLine();
            if (columnCount == 0 && rowCount == 0) {
                int j = 1;
                for (Object str : list) {
                    this.addColumn("F" + j++, "VARCHAR", 255, 0);
                }
                columnCount = this.statement.getMetaData().getColumnCount();
            }
            int indice = 1;
            if (!list.isEmpty()) {
                for (Object str : list) {
                    if (indice <= columnCount) {
                        int type = this.statement.getMetaData().getColumnType(indice);
                        switch (type) {
                            case -7: 
                            case -6: 
                            case 4: 
                            case 5: {
                                if (this.signPosition == 1) {
                                    if (((String)str).endsWith("-")) {
                                        str = "-" + ((String)str).substring(0, ((String)str).length() - 1);
                                    } else if (((String)str).endsWith("+")) {
                                        str = "+" + ((String)str).substring(0, ((String)str).length() - 1);
                                    }
                                }
                                this.statement.setInt(indice, Integer.valueOf((String)str).intValue());
                                break;
                            }
                            case -5: {
                                if (this.signPosition == 1) {
                                    if (((String)str).endsWith("-")) {
                                        str = "-" + ((String)str).substring(0, ((String)str).length() - 1);
                                    } else if (((String)str).endsWith("+")) {
                                        str = "+" + ((String)str).substring(0, ((String)str).length() - 1);
                                    }
                                }
                                this.statement.setLong(indice, Long.valueOf((String)str).longValue());
                                break;
                            }
                            case -16: 
                            case -15: 
                            case -9: 
                            case 1: 
                            case 12: 
                            case 1111: 
                            case 2005: 
                            case 2011: {
                                this.statement.setString(indice, (String)str);
                                break;
                            }
                            case 2: 
                            case 3: {
                                if (this.signPosition == 1) {
                                    if (((String)str).endsWith("-")) {
                                        str = "-" + ((String)str).substring(0, ((String)str).length() - 1);
                                    } else if (((String)str).endsWith("+")) {
                                        str = "+" + ((String)str).substring(0, ((String)str).length() - 1);
                                    }
                                }
                                this.statement.setBigDecimal(indice, BigDecimal.valueOf(Double.valueOf((String)str)));
                                break;
                            }
                            case 8: {
                                if (this.signPosition == 1) {
                                    if (((String)str).endsWith("-")) {
                                        str = "-" + ((String)str).substring(0, ((String)str).length() - 1);
                                    } else if (((String)str).endsWith("+")) {
                                        str = "+" + ((String)str).substring(0, ((String)str).length() - 1);
                                    }
                                }
                                this.statement.setDouble(indice, Double.valueOf((String)str).doubleValue());
                                break;
                            }
                            case 16: {
                                this.statement.setBoolean(indice, Boolean.valueOf((String)str).booleanValue());
                                break;
                            }
                            case 91: {
                                this.statement.setDate(indice, new Date(this.dateFormat.parse((String)str).getTime()));
                                break;
                            }
                            case 92: {
                                this.statement.setTime(indice, new Time(this.timeFormat.parse((String)str).getTime()));
                                break;
                            }
                            case 93: {
                                this.statement.setTimestamp(indice, new Timestamp(this.timeStampFormat.parse((String)str).getTime()));
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                this.statement.setBytes(indice, ((String)str).getBytes());
                                break;
                            }
                            case -8: 
                            case 0: 
                            case 6: 
                            case 7: 
                            case 70: 
                            case 2000: 
                            case 2001: 
                            case 2002: 
                            case 2003: 
                            case 2004: 
                            case 2006: 
                            case 2009: {
                                throw new SQLFeatureNotSupportedException(Messages.getString("DelimitedRecordToResultSet.0") + type + Messages.getString("DelimitedRecordToResultSet.1"));
                            }
                        }
                    }
                    ++indice;
                }
                this.statement.addBatch();
                this.statement.executeBatch();
            }
            ++rowCount;
        }
        this.statement.close();
    }

    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public void setSignPosition(String localStringBindedParameter) {
        this.signPosition = localStringBindedParameter != null && localStringBindedParameter.equals("end") ? 1 : 0;
    }
}

