/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file.jdbc;

import com.indy.engine.actionCodes.SqlFileExportActionCodeI;
import com.indy.engine.actionCodes.file.jdbc.FileWriter;
import com.indy.engine.actionCodes.file.jdbc.Messages;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;

public class FixedWriter
extends FileWriter {
    final String numericPadChar;
    final String stringPadChar;
    boolean localTimeNotSupportedByJdbcDriver;

    public FixedWriter(RuntimeContext rc, DecimalFormat decimalFormat, String numericPadChar, String stringPadChar, String strTimestampFormat, String strDateFormat, String strTimeFormat, Boolean booleanAsNumeric, boolean addRecordNumber) {
        super(rc, booleanAsNumeric, strTimestampFormat, strDateFormat, strTimeFormat, decimalFormat, addRecordNumber);
        this.numericPadChar = numericPadChar;
        this.stringPadChar = stringPadChar;
    }

    String writeFixedValue(ResultSet sourceRSet) throws EngineExceptionI {
        String tmpStr = "";
        try {
            int currentColType = this.currentFieldInfo.colType;
            int currentIndex = this.currentFieldInfo.index;
            switch (currentColType) {
                case -5: {
                    Object val = sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() || val == null ? "" : Long.toString(sourceRSet.getLong(currentIndex));
                    tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.numericPadChar, (int)this.currentFieldInfo.precision);
                    return tmpStr;
                }
                case -7: 
                case 16: {
                    Object val = sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() || val == null ? "" : (this.booleanAsNumeric ? (sourceRSet.getBoolean(currentIndex) ? "1" : "0") : StringOperations.rightPad((String)Boolean.toString(sourceRSet.getBoolean(currentIndex)), (String)this.stringPadChar, (int)5));
                    return tmpStr;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    Object val = sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() || val == null ? "" : sourceRSet.getString(currentIndex);
                    tmpStr = StringOperations.rightPad((String)tmpStr, (String)this.numericPadChar, (int)(this.currentFieldInfo.precision == Integer.MAX_VALUE ? this.currentFieldInfo.columnDisplaySize : this.currentFieldInfo.precision));
                    return tmpStr;
                }
                case 91: {
                    java.util.Date val = this.getDateAsTimeStamp ? sourceRSet.getTimestamp(currentIndex) : sourceRSet.getDate(currentIndex);
                    if (sourceRSet.wasNull() || val == null) {
                        tmpStr = "";
                        tmpStr = this.getDateAsTimeStamp ? StringOperations.rightPad((String)tmpStr, (String)this.stringPadChar, (int)this.strTimestampFormat.length()) : StringOperations.rightPad((String)tmpStr, (String)this.stringPadChar, (int)this.strDateFormat.length());
                    } else if (this.getDateAsTimeStamp) {
                        tmpStr = this.timestampFormat.format(((Timestamp)val).toLocalDateTime());
                        tmpStr = StringOperations.rightPad((String)tmpStr, (String)this.stringPadChar, (int)this.strTimestampFormat.length());
                    } else {
                        tmpStr = this.dateFormat.format(((Date)val).toLocalDate().atStartOfDay());
                        tmpStr = StringOperations.rightPad((String)tmpStr, (String)this.stringPadChar, (int)this.strDateFormat.length());
                    }
                    return tmpStr;
                }
                case 2: 
                case 3: {
                    sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() ? "" : this.decimalFormat.format(sourceRSet.getBigDecimal(currentIndex));
                    tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.numericPadChar, (int)this.currentFieldInfo.precision);
                    return tmpStr;
                }
                case 8: {
                    sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() ? "" : this.decimalFormat.format(sourceRSet.getDouble(currentIndex));
                    tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.numericPadChar, (int)this.currentFieldInfo.precision);
                    return tmpStr;
                }
                case 6: 
                case 7: {
                    sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() ? "" : this.decimalFormat.format(sourceRSet.getFloat(currentIndex));
                    tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.numericPadChar, (int)this.currentFieldInfo.precision);
                    return tmpStr;
                }
                case 4: {
                    Object val = sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() || val == null ? "" : Integer.toString(sourceRSet.getInt(currentIndex));
                    tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.numericPadChar, (int)this.currentFieldInfo.precision);
                    return tmpStr;
                }
                case -6: 
                case 5: {
                    Object val = sourceRSet.getObject(currentIndex);
                    tmpStr = sourceRSet.wasNull() || val == null ? "" : Short.toString(sourceRSet.getShort(currentIndex));
                    tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.numericPadChar, (int)this.currentFieldInfo.precision);
                    return tmpStr;
                }
                case 92: {
                    LocalTime t = this.readTime(sourceRSet, currentIndex);
                    tmpStr = sourceRSet.wasNull() || t == null ? "" : (this.timeFormat == null ? t.toString() : this.timeFormat.format(t));
                    tmpStr = StringOperations.rightPad((String)tmpStr, (String)this.stringPadChar, (int)(this.strTimeFormat != null ? this.strTimeFormat.length() : this.currentFieldInfo.precision));
                    return tmpStr;
                }
                case 93: {
                    Timestamp val = sourceRSet.getTimestamp(currentIndex);
                    if (sourceRSet.wasNull() || val == null) {
                        tmpStr = "";
                    } else {
                        LocalDateTime ts = val.toLocalDateTime();
                        tmpStr = this.timestampFormat.format(ts);
                    }
                    tmpStr = StringOperations.rightPad((String)tmpStr, (String)this.stringPadChar, (int)this.strTimestampFormat.length());
                    return tmpStr;
                }
            }
        }
        catch (NullPointerException e) {
            tmpStr = "";
            tmpStr = StringOperations.leftPad((String)tmpStr, (String)this.stringPadChar, (int)this.currentFieldInfo.precision);
            return tmpStr;
        }
        catch (SQLException e) {
            String currentName = this.currentFieldInfo.name;
            throw new EngineExceptionI(Messages.getString("FixedWriter.0") + currentName, (Throwable)e);
        }
        catch (Exception e) {
            String currentName = this.currentFieldInfo.name;
            throw new EngineExceptionI(Messages.getString("FixedWriter.1") + currentName, (Throwable)e);
        }
        return tmpStr;
    }

    private LocalTime readTime(ResultSet sourceRSet, int currentIndex) throws SQLException {
        LocalTime val;
        block4: {
            if (this.localTimeNotSupportedByJdbcDriver) {
                return this.readTimeLegacy(sourceRSet, currentIndex);
            }
            try {
                val = sourceRSet.getObject(currentIndex, LocalTime.class);
                if (!sourceRSet.wasNull()) break block4;
                return null;
            }
            catch (Exception e) {
                this.localTimeNotSupportedByJdbcDriver = true;
                return this.readTimeLegacy(sourceRSet, currentIndex);
            }
        }
        return val;
    }

    private LocalTime readTimeLegacy(ResultSet sourceRSet, int currentIndex) throws SQLException {
        Time time = sourceRSet.getTime(currentIndex);
        if (time != null && !sourceRSet.wasNull()) {
            return Instant.ofEpochMilli(time.getTime()).atZone(ZoneId.systemDefault()).toLocalTime();
        }
        return null;
    }

    @Override
    public void writeLine(Writer writer, ResultSet sourceRSet, SqlFileExportActionCodeI.FieldInfo[] fieldInfos) throws EngineExceptionI, SQLException, IOException {
        ++this.numRecord;
        this.currentLineSize = 0L;
        SqlFileExportActionCodeI.FieldInfo[] fieldInfoArray = fieldInfos;
        int n = fieldInfos.length;
        int n2 = 0;
        while (n2 < n) {
            SqlFileExportActionCodeI.FieldInfo _currentFieldInfo;
            this.currentFieldInfo = _currentFieldInfo = fieldInfoArray[n2];
            if (this.addRecordNumber) {
                String s = StringOperations.leftPad((String)String.valueOf(this.numRecord), (String)"0", (int)10);
                writer.write(s);
                this.currentLineSize += 12L;
            }
            String str = this.writeFixedValue(sourceRSet);
            this.currentLineSize += (long)str.length();
            writer.write(str);
            ++n2;
        }
    }
}

