/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.xml.unload;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.JdbcToXmlActionCodeI;
import com.indy.engine.actionCodes.xml.unload.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;

public abstract class AbstractXmlWriterAPI {
    static UniqueTimestampGenerator utg = new UniqueTimestampGenerator();
    private static Map<String, XmlTransaction> transactions = new HashMap<String, XmlTransaction>();
    protected XMLStreamWriter xmlw;
    protected OutputStreamWriter osw;
    private File temporaryFile;
    private String temporaryFilePrefix;
    int temporaryFileIndex = 1;
    NoDataBehaviour noDataBehaviour = NoDataBehaviour.raiseException;
    FileAlreadyExistsBehaviour fileAlreadyExistsBehaviour = FileAlreadyExistsBehaviour.replace;
    private boolean commit;
    protected String encoding;
    private boolean writeXmlDeclaration;
    private String xmlVersion;
    private File outFile;
    private ActionCodeTypeI actionCode;
    long nbOpenedElement = 0L;

    protected AbstractXmlWriterAPI(boolean commit, String encoding, boolean writeXmlDeclaration, String xmlVersion, File outFile, ActionCodeTypeI actionCode, NoDataBehaviour noDataBehaviour, FileAlreadyExistsBehaviour fileAreaydExistsBehaviour) {
        this.noDataBehaviour = noDataBehaviour;
        this.fileAlreadyExistsBehaviour = fileAreaydExistsBehaviour;
        this.commit = commit;
        this.encoding = encoding;
        this.writeXmlDeclaration = writeXmlDeclaration;
        this.xmlVersion = xmlVersion;
        this.outFile = outFile;
        this.actionCode = actionCode;
        this.temporaryFilePrefix = outFile.getParent() + "/" + actionCode.getActionContext().getSessionId() + "." + utg.newTimestamp() + ".temp.";
    }

    private void doCose() throws Exception {
        this.getXMLStreamWriter().close();
        this.closeCurrent();
    }

    public void close() throws EngineExceptionI {
        if (this.commit && this.getXMLStreamWriter() != null) {
            try {
                this.doCose();
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public abstract void closeCurrent() throws Exception;

    public boolean startNewDocument(boolean hasRawData) throws XMLStreamException, IOException {
        boolean opening;
        String transactionId;
        String sessionId = this.actionCode.getActionContext().getSessionId();
        XmlTransaction xmlTransac = transactions.get(sessionId + (transactionId = this.outFile.getAbsolutePath()));
        if (xmlTransac == null) {
            this.temporaryFile = new File(this.temporaryFilePrefix + this.temporaryFileIndex++ + "." + this.outFile.getName());
            if (!this.temporaryFile.getParentFile().exists()) {
                this.temporaryFile.getParentFile().mkdirs();
            }
            this.xmlw = this.createWriter(this.temporaryFile, hasRawData);
            if (this.writeXmlDeclaration) {
                this.getXMLStreamWriter().writeStartDocument(this.encoding != null ? this.encoding : Charset.defaultCharset().displayName(), this.xmlVersion);
            }
            opening = true;
        } else {
            opening = false;
            this.xmlw = xmlTransac.xmlw;
        }
        return opening;
    }

    public abstract XMLStreamWriter createWriter(File var1, boolean var2) throws XMLStreamException, IOException;

    public boolean endCurrentDocument(File file) throws Exception {
        boolean ret = false;
        if (this.commit) {
            boolean hasData;
            boolean bl = hasData = this.nbOpenedElement > 0L;
            if (!hasData) {
                this.addRoot();
            }
            this.getXMLStreamWriter().writeEndDocument();
            this.doCose();
            if (this.temporaryFile.exists() && (hasData || this.noDataBehaviour == NoDataBehaviour.createEmptyFile)) {
                boolean toWrite = true;
                if (file.exists()) {
                    if (this.fileAlreadyExistsBehaviour == FileAlreadyExistsBehaviour.raiseException) {
                        throw new EngineExceptionI(Messages.getString("AbstractXmlWriterAPI.0") + file.toString() + Messages.getString("AbstractXmlWriterAPI.1"));
                    }
                    if (this.fileAlreadyExistsBehaviour == FileAlreadyExistsBehaviour.replace) {
                        try {
                            Files.delete(file.toPath());
                        }
                        catch (Exception e) {
                            throw new EngineExceptionI(Messages.getString("AbstractXmlWriterAPI.2") + file.getAbsolutePath());
                        }
                    } else if (this.fileAlreadyExistsBehaviour == FileAlreadyExistsBehaviour.preserve) {
                        toWrite = false;
                    }
                }
                if (toWrite) {
                    int code;
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if ((code = this.renameTo(this.temporaryFile, file)) < 1) {
                        throw new EngineExceptionI(Messages.getString("AbstractXmlWriterAPI.3") + code + ") :" + this.temporaryFile.getAbsolutePath() + Messages.getString("AbstractXmlWriterAPI.4") + file.getAbsolutePath());
                    }
                } else {
                    this.temporaryFile.delete();
                }
                ret = true;
            } else {
                this.temporaryFile.delete();
                if (file.exists()) {
                    try {
                        Files.delete(file.toPath());
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI(Messages.getString("AbstractXmlWriterAPI.2") + file.getAbsolutePath());
                    }
                }
                switch (this.noDataBehaviour) {
                    case deleteExistingFile: {
                        break;
                    }
                    case createEmptyFile: {
                        file.createNewFile();
                        ret = true;
                        break;
                    }
                    case raiseException: {
                        throw new EngineExceptionI(Messages.getString("AbstractXmlWriterAPI.6"));
                    }
                }
            }
        } else {
            String id = this.actionCode.getActionContext().getSessionId();
            String transactionId = this.outFile.getAbsolutePath();
            transactions.put(id + transactionId, new XmlTransaction(id, transactionId, this.getXMLStreamWriter()));
        }
        return ret;
    }

    private int renameTo(File source, File dest) {
        if (!source.renameTo(dest)) {
            try {
                FileUtils.copyFile((File)source, (File)dest);
            }
            catch (IOException io) {
                return -1;
            }
            if (!source.delete()) {
                return -2;
            }
            return 2;
        }
        return 1;
    }

    public abstract void addRoot() throws XMLStreamException;

    public File getOutFile() {
        return this.outFile;
    }

    public void writeAttribute(JdbcToXmlActionCodeI.IndyAttribute attribute, String strValue, Object value, int sourceType) throws Exception {
        if (attribute.getNSUri() != null) {
            if (attribute.getPrefix() != null) {
                this.getXMLStreamWriter().writeAttribute(attribute.getPrefix(), attribute.getNSUri(), attribute.getLocalName(), strValue);
            } else {
                this.getXMLStreamWriter().writeAttribute(attribute.getNSUri(), attribute.getLocalName(), strValue);
            }
        } else {
            this.getXMLStreamWriter().writeAttribute(attribute.getLocalName(), strValue);
        }
    }

    public void writeStartElement(JdbcToXmlActionCodeI.IndyElement element) throws XMLStreamException {
        if (element.getNSUri() != null) {
            if (element.getPrefix() != null) {
                this.writeStartElement(element.getPrefix(), element.getLocalName(), element.getNSUri());
            } else {
                this.getXMLStreamWriter().setDefaultNamespace(element.getNSUri());
                this.writeStartElement(element.getLocalName());
            }
        } else {
            this.writeStartElement(element.getLocalName());
        }
    }

    public void writeText(JdbcToXmlActionCodeI.IndyElement indyElement, String data, Object value, int sourceType) throws Exception {
        if (indyElement.isUseCDATA()) {
            this.getXMLStreamWriter().writeCData(data);
        } else {
            this.getXMLStreamWriter().writeCharacters(data);
        }
    }

    public abstract void writeNewLineCharacter() throws Exception;

    public void incNbOpenedElement(int nbelt) {
        this.nbOpenedElement += (long)nbelt;
    }

    public void writeStartElement(String paramString1, String paramString2, String paramString3) throws XMLStreamException {
        this.getXMLStreamWriter().writeStartElement(paramString1, paramString2, paramString3);
        this.incNbOpenedElement(1);
    }

    public void writeStartElement(String paramString) throws XMLStreamException {
        this.getXMLStreamWriter().writeStartElement(paramString);
        this.incNbOpenedElement(1);
    }

    public void writeStartElement(String paramString1, String paramString2) throws XMLStreamException {
        this.getXMLStreamWriter().writeStartElement(paramString1, paramString2);
        this.incNbOpenedElement(1);
    }

    public void interrupt() {
    }

    public void writeEndElement() throws XMLStreamException {
        this.getXMLStreamWriter().writeEndElement();
    }

    public void writeNamespace(String prefix, String nameSpaceUri) throws XMLStreamException {
        this.getXMLStreamWriter().writeNamespace(prefix, nameSpaceUri);
    }

    public void writeDefaultNamespace(String targetNamespace) throws XMLStreamException {
        this.getXMLStreamWriter().writeDefaultNamespace(targetNamespace);
    }

    public Exception getWrapperException() {
        return null;
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.xmlw;
    }

    public static enum FileAlreadyExistsBehaviour {
        replace,
        raiseException,
        preserve;

    }

    public static enum NoDataBehaviour {
        raiseException,
        createEmptyFile,
        deleteExistingFile;

    }

    static class UniqueTimestampGenerator {
        long currentTimestamp;
        int currentSequence;

        UniqueTimestampGenerator() {
        }

        public synchronized String newTimestamp() {
            long newTimestamp = System.currentTimeMillis();
            if (newTimestamp == this.currentTimestamp) {
                ++this.currentSequence;
            } else {
                this.currentTimestamp = newTimestamp;
                this.currentSequence = 0;
            }
            return this.currentTimestamp + "." + this.currentSequence;
        }
    }

    class XmlTransaction {
        XMLStreamWriter xmlw;
        String sessionId;
        String transactionId;

        public XmlTransaction(String sessionId, String transactionId, XMLStreamWriter xmlw) {
            this.sessionId = sessionId;
            this.transactionId = transactionId;
            this.xmlw = xmlw;
        }
    }
}

