/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook;

import com.indy.osgihook.ExternalJarHook;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Collections;
import org.eclipse.osgi.storage.Storage;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public class CopyFilesTask {
    String fromDir;
    String toDir;
    String[] filePattern;
    boolean recursive = false;
    boolean force = false;
    boolean keepArbo = true;
    String[] excludePattern;
    private BundleFile bundle;
    private String strFilePattern;
    private String strExcludePattern;
    private boolean nocr = false;
    private boolean executable;
    private boolean readable;
    private boolean forcecr;

    public CopyFilesTask(BundleFile b, String fromDir, String params) {
        this.fromDir = fromDir;
        this.bundle = b;
        this.processArgs(params.split(" "));
        ExternalJarHook.logln("\tCopy Files Task");
        ExternalJarHook.logln("\tFrom :" + fromDir);
        ExternalJarHook.logln("\tTo :" + this.toDir);
        ExternalJarHook.logln("\tRecursive ?:" + this.recursive);
        ExternalJarHook.logln("\tKeepHierarchy ?:" + this.keepArbo);
        ExternalJarHook.logln("\tforce ?:" + this.keepArbo);
        ExternalJarHook.logln("\tInclude Pattern :" + this.strFilePattern);
        ExternalJarHook.logln("\tExclude Pattern ?:" + this.strExcludePattern);
        ExternalJarHook.logln("\tNo Carriage Return ?:" + this.nocr);
        ExternalJarHook.logln("\tReadable ?:" + this.readable);
        ExternalJarHook.logln("\tExecutable ?:" + this.executable);
    }

    public void run() {
        if (this.filePattern != null) {
            int i = 0;
            while (i < this.filePattern.length) {
                String file = this.filePattern[i];
                this.copyEntries(file);
                ++i;
            }
        }
    }

    public void copyEntries(String filePattern) {
        ExternalJarHook.logln("\tCopy Entries Start for pattern :" + filePattern);
        this.toDir = this.toDir == null ? "/" : this.toDir;
        this.fromDir = this.fromDir == null ? "/" : this.fromDir;
        try {
            for (String entryPath : Storage.listEntryPaths(Collections.singletonList(this.bundle), (String)this.fromDir, (String)filePattern, (int)(this.recursive ? 1 : 0))) {
                URL o = this.bundle.getEntry(entryPath).getFileURL();
                String file = o.getFile();
                boolean isExcluded = CopyFilesTask.isExcluded(entryPath, this.excludePattern);
                if (!(entryPath.contains("/CVS/") || entryPath.endsWith("/") || isExcluded)) {
                    if (!this.keepArbo && entryPath.contains("/")) {
                        entryPath = entryPath.substring(entryPath.lastIndexOf("/") + 1);
                    }
                    Object strTargetFile = "/" + this.toDir + "/" + entryPath;
                    strTargetFile = ((String)strTargetFile).replaceAll("/+", "/");
                    boolean isProtected = ExternalJarHook.isProtected((String)strTargetFile);
                    File targetFile = new File(ExternalJarHook.stambiaRuntimeDir + (String)strTargetFile);
                    boolean exists = targetFile.exists();
                    if (exists && this.force && !isProtected || !exists) {
                        targetFile.getParentFile().mkdirs();
                        Throwable throwable = null;
                        Object var12_14 = null;
                        try (BufferedInputStream is = new BufferedInputStream(o.openStream());){
                            try {
                                Throwable throwable2 = null;
                                Object var15_20 = null;
                                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));){
                                    if (this.nocr) {
                                        ExternalJarHook.copyWithoutCarriageReturn(is, os);
                                    } else if (this.forcecr) {
                                        ExternalJarHook.copyAddCarriageReturn(is, os);
                                    } else {
                                        ExternalJarHook.copy(is, os);
                                    }
                                    if (this.executable) {
                                        targetFile.setExecutable(true);
                                    }
                                    if (this.readable) {
                                        targetFile.setReadable(true);
                                    }
                                    if (exists) {
                                        ExternalJarHook.logln("\t" + file + " was replaced");
                                        continue;
                                    }
                                    ExternalJarHook.logln("\t" + file + " was copied");
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    if (isProtected) {
                        ExternalJarHook.logln("\t" + file + " is protected");
                        continue;
                    }
                    if (!exists) continue;
                    ExternalJarHook.logln("\t" + file + " was preserved");
                    continue;
                }
                if (!isExcluded) continue;
                ExternalJarHook.logln("\t" + file + " is excluded");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExternalJarHook.logln("\tCopyEntries End");
    }

    public static boolean isExcluded(String file, String[] excludePatterns) {
        if (excludePatterns != null) {
            int i = 0;
            while (i < excludePatterns.length) {
                String excludePattern = excludePatterns[i];
                if (excludePattern != null && !excludePattern.equals("") && ExternalJarHook.comparePattern(file, excludePattern)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void processArgs(String[] args) {
        Object searchForThis = null;
        try {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.toLowerCase().equals("-todir")) {
                    i = this.handleToDirArg(args, i);
                } else if (arg.toLowerCase().equals("-recursive")) {
                    i = this.handleRecursiveArg(args, i);
                } else if (arg.toLowerCase().equals("-replace")) {
                    i = this.handleReplaceArg(args, i);
                } else if (arg.toLowerCase().equals("-nodir")) {
                    i = this.handleKeepHierarchy(args, i);
                } else if (arg.toLowerCase().equals("-pattern")) {
                    i = this.handleIncludePattern(args, i);
                } else if (arg.toLowerCase().equals("-exclude")) {
                    i = this.handleExcludePattern(args, i);
                } else if (arg.toLowerCase().equals("-force") || arg.toLowerCase().equals("-override")) {
                    i = this.handleforceArg(args, i);
                } else if (arg.toLowerCase().equals("-nocr")) {
                    i = this.handleNoCr(args, i);
                } else if (arg.toLowerCase().equals("-forcecr")) {
                    i = this.handleAddCr(args, i);
                } else if (arg.toLowerCase().equals("-readable")) {
                    i = this.handleReadable(args, i);
                } else if (arg.toLowerCase().equals("-executable")) {
                    i = this.handleExecutable(args, i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int handleExecutable(String[] args, int pos) {
        this.executable = true;
        return pos;
    }

    private int handleReadable(String[] args, int pos) {
        this.readable = true;
        return pos;
    }

    private int handleforceArg(String[] args, int pos) {
        this.force = true;
        return pos;
    }

    private int handleNoCr(String[] args, int pos) throws Exception {
        this.nocr = true;
        return pos;
    }

    private int handleAddCr(String[] args, int pos) throws Exception {
        this.forcecr = true;
        return pos;
    }

    private int handleIncludePattern(String[] args, int pos) throws Exception {
        try {
            String value;
            this.strFilePattern = value = args[++pos];
            this.filePattern = value.split(";");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new Exception("You must specify a include pattern when using the -pattern argument");
        }
        return pos;
    }

    private int handleExcludePattern(String[] args, int pos) throws Exception {
        try {
            String value;
            this.strExcludePattern = value = args[++pos];
            this.excludePattern = value.split(";");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new Exception("You must specify an exlude pattern when using the -exclude argument");
        }
        return pos;
    }

    private int handleKeepHierarchy(String[] args, int pos) throws Exception {
        this.keepArbo = false;
        return pos;
    }

    private int handleReplaceArg(String[] args, int pos) throws Exception {
        this.force = true;
        return pos;
    }

    private int handleRecursiveArg(String[] args, int pos) throws Exception {
        this.recursive = true;
        return pos;
    }

    private int handleToDirArg(String[] args, int pos) throws Exception {
        try {
            this.toDir = args[++pos];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new Exception("You must specify a target Dir when using the -toDir argument");
        }
        return pos;
    }
}

