/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MappingType implements Enumerator
{
    SOURCE(0, "Source", "Source"),
    TARGET(1, "Target", "Target"),
    MAPPING(2, "Mapping", "Mapping"),
    CONSTRAINT(3, "Constraint", "Constraint"),
    JOIN(4, "Join", "Join"),
    FILTER(5, "Filter", "Filter"),
    VARIABLE(6, "Variable", "Variable"),
    SOURCE_MAPPING(7, "SourceMapping", "SourceMapping"),
    TARGET_MAPPING(8, "TargetMapping", "TargetMapping"),
    STAGING(9, "Staging", "Staging"),
    SERDE_OUTPUT(10, "SerdeOutput", "SerdeOutput"),
    SERDE_INPUT(11, "SerdeInput", "SerdeInput");

    public static final int SOURCE_VALUE = 0;
    public static final int TARGET_VALUE = 1;
    public static final int MAPPING_VALUE = 2;
    public static final int CONSTRAINT_VALUE = 3;
    public static final int JOIN_VALUE = 4;
    public static final int FILTER_VALUE = 5;
    public static final int VARIABLE_VALUE = 6;
    public static final int SOURCE_MAPPING_VALUE = 7;
    public static final int TARGET_MAPPING_VALUE = 8;
    public static final int STAGING_VALUE = 9;
    public static final int SERDE_OUTPUT_VALUE = 10;
    public static final int SERDE_INPUT_VALUE = 11;
    private static final MappingType[] VALUES_ARRAY;
    public static final List<MappingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MappingType[]{SOURCE, TARGET, MAPPING, CONSTRAINT, JOIN, FILTER, VARIABLE, SOURCE_MAPPING, TARGET_MAPPING, STAGING, SERDE_OUTPUT, SERDE_INPUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MappingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MappingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MappingType getByName(String name) {
        if ("SOURCE_MAPPING".equalsIgnoreCase(name)) {
            return SOURCE_MAPPING;
        }
        if ("TARGET_MAPPING".equalsIgnoreCase(name)) {
            return TARGET_MAPPING;
        }
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MappingType result = VALUES_ARRAY[i];
            if (result.getName().equalsIgnoreCase(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MappingType get(int value) {
        switch (value) {
            case 0: {
                return SOURCE;
            }
            case 1: {
                return TARGET;
            }
            case 2: {
                return MAPPING;
            }
            case 3: {
                return CONSTRAINT;
            }
            case 4: {
                return JOIN;
            }
            case 5: {
                return FILTER;
            }
            case 6: {
                return VARIABLE;
            }
            case 7: {
                return SOURCE_MAPPING;
            }
            case 8: {
                return TARGET_MAPPING;
            }
            case 9: {
                return STAGING;
            }
            case 10: {
                return SERDE_OUTPUT;
            }
            case 11: {
                return SERDE_INPUT;
            }
        }
        return null;
    }

    private MappingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

