/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModeType implements Enumerator
{
    SEQUENTIAL(0, "Sequential", "Sequential"),
    PARALLELIZE(1, "Parallelize", "Parallelize");

    public static final int SEQUENTIAL_VALUE = 0;
    public static final int PARALLELIZE_VALUE = 1;
    private static final ModeType[] VALUES_ARRAY;
    public static final List<ModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModeType[]{SEQUENTIAL, PARALLELIZE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModeType get(int value) {
        switch (value) {
            case 0: {
                return SEQUENTIAL;
            }
            case 1: {
                return PARALLELIZE;
            }
        }
        return null;
    }

    private ModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

