/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.common.editor.input;

import com.indy.ui.common.utils.IBaseLabelProviderViewer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class ConnectionData
implements IBaseLabelProviderViewer,
Comparable<ConnectionData> {
    private String connectionLabel;
    private Integer transaction;
    private Map<String, Integer> statut;
    private Map<String, String> errorMsg;
    private Map<String, String> parameter;
    private String configurationName;
    public static final int TEST_OK = 1;
    public static final int TEST_ERROR = 0;
    public static final String TEST_ALL_CONNECTION = "";

    public ConnectionData(String connectionLabel, Integer transaction, Map<String, String> parameter, String configurationName) {
        this.connectionLabel = connectionLabel;
        this.transaction = transaction;
        this.statut = new HashMap<String, Integer>();
        this.errorMsg = new HashMap<String, String>();
        this.parameter = parameter;
        this.configurationName = configurationName;
    }

    public void addRuntimeError(String runtimeName, String message) {
        this.errorMsg.put(runtimeName, message);
    }

    public String getRuntimeErrorMsg(String runtimeName) {
        return this.errorMsg.get(runtimeName);
    }

    public ConnectionData(boolean forTestAllCtx) {
        this.connectionLabel = TEST_ALL_CONNECTION;
        this.transaction = 0;
        this.statut = null;
    }

    public String getConnectionLabel() {
        return this.connectionLabel;
    }

    public Integer getTransaction() {
        return this.transaction;
    }

    public Integer getRuntimeStatut(String runtimeName) {
        return this.statut.get(runtimeName);
    }

    public void addRuntimeStatut(String runtimeName, Integer statut) {
        this.statut.put(runtimeName, statut);
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public Map<String, Integer> getStatut() {
        return this.statut;
    }

    @Override
    public String getText() {
        return this.connectionLabel;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    @Override
    public int compareTo(ConnectionData o) {
        return this.connectionLabel.compareTo(o.connectionLabel);
    }
}

