/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation.custom.edit;

import com.indy.ui.custom.out.common.properties.AbstractKeyValueControl;
import com.stambia.md.impl.StringToStringMapEntryImpl;
import com.stambia.md.util.MdFactoryHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.viewers.ILabelProvider;

public class KeyValueControl
extends AbstractKeyValueControl {
    private EMap<String, String> entries = new BasicEMap();

    public KeyValueControl(ILabelProvider labelProvider, AbstractKeyValueControl.IKeyValueProvider keyProvider) {
        super(labelProvider, keyProvider);
    }

    public EMap<String, String> getResult() {
        return this.entries;
    }

    protected String getKeyLabel(Object data) {
        return (String)((Map.Entry)data).getKey();
    }

    protected String getValueLabel(Object data) {
        String s = (String)((Map.Entry)data).getValue();
        if (s == null) {
            return "";
        }
        return s;
    }

    protected void handleDownItem(Object o) {
        int index = this.entries.indexOf(o);
        if (index >= 0 && index < this.entries.size() - 1) {
            Object old = this.entries.get(index + 1);
            this.entries.set(index + 1, (Object)((Map.Entry)o));
            this.entries.set(index, (Object)((Map.Entry)old));
        }
    }

    protected void handleUpItem(Object o) {
        int index = this.entries.indexOf(o);
        if (index > 0) {
            Object old = this.entries.get(index - 1);
            this.entries.set(index - 1, (Object)((Map.Entry)o));
            this.entries.set(index, (Object)((Map.Entry)old));
        }
    }

    protected void handleRemoveItem(List l) {
        this.entries.removeAll((Collection)l);
    }

    protected void handleAddItem(Object o) {
        String[] obj = (String[])o;
        StringToStringMapEntryImpl entry = MdFactoryHelper.createStringToStringMapEntry();
        entry.setKey(obj[0]);
        entry.setValue(obj[1]);
        int i = this.entries.indexOfKey((Object)obj[0]);
        if (i != -1) {
            this.entries.set(i, (Object)entry);
        } else {
            this.entries.add((Object)entry);
        }
    }

    public Object initializeInput(Object data) {
        this.entries.clear();
        if (data instanceof EMap) {
            EMap map = (EMap)data;
            for (Map.Entry e : map) {
                StringToStringMapEntryImpl entry = MdFactoryHelper.createStringToStringMapEntry();
                entry.setKey((String)e.getKey());
                entry.setValue((String)e.getValue());
                this.entries.add((Object)entry);
            }
        }
        return this.entries;
    }
}

