/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.impact.commands;

import com.indy.ui.custom.out.Util;
import com.indy.ui.impact.views.DependencyView;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DependenciesHandler
extends AbstractHandler {
    private Map<String, URI> getDependancies2(Collection<IFile> visitedFile) {
        ICacheService.IDependenciesGraphAnalyzer analyzer = (ICacheService.IDependenciesGraphAnalyzer)E4InjectorHelper.getService(ICacheService.IDependenciesGraphAnalyzer.class);
        ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        HashSet<String> ids = new HashSet<String>();
        for (IFile f : visitedFile) {
            URI uri = Util.convertIFileToEMFURI((IFile)f);
            String id = cacheService.getSourceId(uri);
            if (id == null) continue;
            ids.add(id);
        }
        return analyzer.getRequiredModelsURI(ids);
    }

    private Object[] doSearch(ISelection s) {
        Visitor visitor = new Visitor();
        for (Object o : ((IStructuredSelection)s).toList()) {
            try {
                ((IResource)o).accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        HashSet<URI> selectedFiles = new HashSet<URI>();
        Map<String, URI> requirements = this.getDependancies2(visitor.visitedFiles);
        selectedFiles.addAll(requirements.values());
        selectedFiles.remove(null);
        HashSet<IProject> mapProjects = new HashSet<IProject>();
        for (URI u : new HashSet(selectedFiles)) {
            Object f;
            if (!"map".equals(u.fileExtension()) || (f = Util.convertEMFURIToFile((URI)u)) == null || !f.getProject().exists() || !f.getProject().isOpen()) continue;
            mapProjects.add(f.getProject());
        }
        if (!mapProjects.isEmpty()) {
            final HashSet tpcFiles = new HashSet();
            mapProjects.add(ResourcesPlugin.getWorkspace().getRoot().getProject("global"));
            for (IProject p : mapProjects) {
                if (!p.isOpen()) continue;
                try {
                    p.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 2) {
                                if ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName())) {
                                    return false;
                                }
                            } else if (resource.getType() == 1 && "tpc".equals(resource.getFileExtension())) {
                                tpcFiles.add((IFile)resource);
                            }
                            return true;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (IFile tpc : tpcFiles) {
                Map<String, URI> tpcRequirement = this.getDependancies2(Collections.singleton(tpc));
                if (Collections.disjoint(tpcRequirement.values(), selectedFiles)) continue;
                selectedFiles.add(Util.convertIFileToEMFURI((IFile)tpc));
                selectedFiles.addAll(tpcRequirement.values());
                selectedFiles.remove(null);
                requirements.putAll(tpcRequirement);
            }
        }
        ICacheService.IDependenciesGraphAnalyzer analyzer = (ICacheService.IDependenciesGraphAnalyzer)E4InjectorHelper.getService(ICacheService.IDependenciesGraphAnalyzer.class);
        Map missing = analyzer.getPotentialModelURIForMissing(requirements.keySet());
        ArrayList<Object[]> input = new ArrayList<Object[]>();
        for (String k : missing.keySet()) {
            Collection c = (Collection)missing.get(k);
            Object[] row = new Object[2];
            if (c == null || c.isEmpty()) {
                row[0] = k;
                row[1] = "";
                input.add(row);
                continue;
            }
            for (URI u : c) {
                row = new Object[]{k, u};
                input.add(row);
            }
        }
        return new Object[]{selectedFiles, input};
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = this.getSelection(event);
        if (s instanceof IStructuredSelection) {
            Object[] res = this.doSearch(s);
            try {
                DependencyView v = (DependencyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.indy.ui.impact.views.DependencyView");
                v.setInput(res[0], res[1]);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private ISelection getSelection(ExecutionEvent event) {
        if (!"org.eclipse.ui.navigator.ProjectExplorer".equals(HandlerUtil.getActivePartId((ExecutionEvent)event))) {
            IViewReference ref = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("org.eclipse.ui.navigator.ProjectExplorer");
            IWorkbenchPart p = ref.getPart(false);
            if (p != null) {
                return p.getSite().getSelectionProvider().getSelection();
            }
            return null;
        }
        return HandlerUtil.getCurrentSelection((ExecutionEvent)event);
    }

    private class Visitor
    implements IResourceVisitor {
        List<IFile> visitedFiles = new ArrayList<IFile>();

        private Visitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (!resource.getProject().isOpen()) {
                return false;
            }
            if (resource.getType() == 2 && ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName()))) {
                return false;
            }
            if (resource.getType() == 1 && resource.getFileExtension() != null) {
                if (resource.getFileExtension().equals("map") || resource.getFileExtension().equals("proc") || resource.getFileExtension().equals("tech") || resource.getFileExtension().equals("md") || resource.getFileExtension().equals("tpc") || resource.getFileExtension().equals("tech_ext")) {
                    this.visitedFiles.add((IFile)resource);
                    return true;
                }
            } else if (resource.getType() == 4 || resource.getType() == 2) {
                return true;
            }
            return false;
        }
    }
}

