/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.impact.commands.ui;

import com.indy.ui.custom.out.Util;
import com.indy.ui.impact.Activator;
import com.indy.ui.impact.Messages;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonViewer;

public class DuplicateManagerUI {
    private CommonViewer duplicatedViewer;
    private CommonViewer duplicateViewer;
    private FormToolkit toolkit;
    private HashMap<IResource, List<IResource>> input;
    private Composite container;

    private Control createViewers(Composite parent) {
        Composite c = this.toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).applyTo(c);
        Label l = this.toolkit.createLabel(c, Messages.DuplicateManagerUI_4);
        GridDataFactory.swtDefaults().applyTo((Control)l);
        l = this.toolkit.createLabel(c, Messages.DuplicateManagerUI_5);
        GridDataFactory.swtDefaults().applyTo((Control)l);
        this.duplicatedViewer = new CommonViewer("org.eclipse.ui.navigator.ProjectExplorer", c, 2816);
        GridDataFactory.fillDefaults().applyTo(this.duplicatedViewer.getControl());
        this.duplicatedViewer.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.jdt.java.ui.javaContent"}, true);
        this.duplicatedViewer.getNavigatorContentService().update();
        this.duplicatedViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DuplicateManagerUI.this.duplicateViewer.refresh();
                DuplicateManagerUI.this.duplicateViewer.expandAll();
            }
        });
        this.duplicatedViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return DuplicateManagerUI.this.input.keySet().contains(element);
                }
                if (element instanceof IContainer) {
                    return this.checkFolder((IContainer)element);
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean checkFolder(IContainer f) {
                if (f.getName().equals("indy.build")) return false;
                if (f.getName().equals("indy.diagram")) {
                    return false;
                }
                try {
                    IResource[] iResourceArray = f.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource m = iResourceArray[n2];
                        if (m instanceof IFile && DuplicateManagerUI.this.input.keySet().contains(m)) {
                            return true;
                        }
                        if (m instanceof IContainer && this.checkFolder((IContainer)m)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
        this.duplicateViewer = new CommonViewer("org.eclipse.ui.navigator.ProjectExplorer", c, 2816);
        this.duplicateViewer.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.jdt.java.ui.javaContent"}, true);
        this.duplicateViewer.getNavigatorContentService().update();
        this.duplicateViewer.addDoubleClickListener(new IDoubleClickListener(){
            Control formerControl;

            public void doubleClick(DoubleClickEvent event) {
                IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
                try {
                    if (this.formerControl != null) {
                        this.formerControl.dispose();
                        this.formerControl = null;
                    }
                    CompareConfiguration conf = new CompareConfiguration();
                    conf.setLeftLabel(Messages.DuplicateManagerUI_14);
                    conf.setRightLabel(Messages.DuplicateManagerUI_15);
                    conf.setLeftEditable(false);
                    conf.setRightEditable(false);
                    CompareEditorInput compareInput = new CompareEditorInput(conf){

                        protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IFile cur = (IFile)((IStructuredSelection)(this).DuplicateManagerUI.this.duplicatedViewer.getSelection()).getFirstElement();
                            IFile duplicate = (IFile)((IStructuredSelection)(this).DuplicateManagerUI.this.duplicateViewer.getSelection()).getFirstElement();
                            ResourceNode left = new ResourceNode((IResource)cur);
                            ResourceNode right = new ResourceNode((IResource)duplicate);
                            Differencer d = new Differencer();
                            Object res = d.findDifferences(false, monitor, null, null, (Object)left, (Object)right);
                            return res;
                        }
                    };
                    compareInput.run(monitor);
                    ((StackLayout)DuplicateManagerUI.this.container.getLayout()).topControl = this.formerControl = compareInput.createContents(DuplicateManagerUI.this.container);
                    if (compareInput.getCompareResult() == null) {
                        Label l = DuplicateManagerUI.this.toolkit.createLabel(DuplicateManagerUI.this.container, Messages.DuplicateManagerUI_16);
                        ((StackLayout)DuplicateManagerUI.this.container.getLayout()).topControl = l;
                    }
                    DuplicateManagerUI.this.container.layout(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.duplicateViewer.addFilter(new ViewerFilter(){

            public boolean isDuplicate(IFile f) {
                return DuplicateManagerUI.this.input.get(((IStructuredSelection)DuplicateManagerUI.this.duplicatedViewer.getSelection()).getFirstElement()).contains(f);
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (DuplicateManagerUI.this.duplicatedViewer.getSelection().isEmpty()) {
                    return false;
                }
                if (element instanceof IFile) {
                    return this.isDuplicate((IFile)element);
                }
                if (element instanceof IContainer) {
                    return this.checkFolder((IContainer)element);
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean checkFolder(IContainer f) {
                if (f.getName().equals("indy.build")) return false;
                if (f.getName().equals("indy.diagram")) {
                    return false;
                }
                try {
                    IResource[] iResourceArray = f.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource m = iResourceArray[n2];
                        if (m instanceof IFile && this.isDuplicate((IFile)m)) {
                            return true;
                        }
                        if (m instanceof IContainer && this.checkFolder((IContainer)m)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
        GridDataFactory.fillDefaults().grab(false, true).applyTo(this.duplicateViewer.getControl());
        this.duplicatedViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.duplicateViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        return c;
    }

    private void initInput() {
        this.input = new HashMap();
        Map map = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDuplicatedResources();
        for (URI uri : map.keySet()) {
            IFile k = Util.convertEMFURIToFile((URI)uri);
            if (k == null) continue;
            List<IResource> l = this.input.get(k);
            if (l == null) {
                l = new ArrayList<IResource>();
                this.input.put((IResource)k, l);
            }
            for (URI u : (List)map.get(uri)) {
                IFile v = Util.convertEMFURIToFile((URI)u);
                if (v == null) continue;
                l.add((IResource)v);
            }
        }
    }

    public void open() {
        this.initInput();
        if (this.toolkit == null) {
            this.toolkit = new FormToolkit(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
        }
        DuplicateDialog dial = new DuplicateDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dial.open();
    }

    public void dispose() {
        this.toolkit.dispose();
        this.toolkit = null;
    }

    private class DuplicateDialog
    extends Dialog {
        public DuplicateDialog(Shell sh) {
            super(sh);
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            this.getShell().setSize(800, 600);
            this.getShell().setText(Messages.DuplicateManagerUI_0);
            DuplicateManagerUI.this.duplicatedViewer.expandAll();
            DuplicateManagerUI.this.duplicateViewer.expandAll();
        }

        protected Control createDialogArea(Composite parent) {
            Control c = DuplicateManagerUI.this.createViewers(parent);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
            DuplicateManagerUI.this.container = DuplicateManagerUI.this.toolkit.createComposite((Composite)c);
            DuplicateManagerUI.this.container.setLayout((Layout)new StackLayout());
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)DuplicateManagerUI.this.container);
            DuplicateManagerUI.this.duplicateViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty() || ((IResource)((IStructuredSelection)event.getSelection()).getFirstElement()).getType() != 1) {
                        DuplicateDialog.this.getButton(0).setEnabled(false);
                    } else {
                        DuplicateDialog.this.getButton(0).setEnabled(true);
                    }
                }
            });
            return c;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button b = this.getButton(0);
            b.setText(Messages.DuplicateManagerUI_1);
            b.setEnabled(false);
            this.getButton(1).setText(Messages.DuplicateManagerUI_2);
        }

        protected void okPressed() {
            ICacheService cacheService = (ICacheService)PlatformUI.getWorkbench().getService(ICacheService.class);
            if (cacheService != null) {
                IFile r = (IFile)((IStructuredSelection)DuplicateManagerUI.this.duplicatedViewer.getSelection()).getFirstElement();
                URI curURI = Util.convertIFileToEMFURI((IFile)r);
                r = (IFile)((IStructuredSelection)DuplicateManagerUI.this.duplicateViewer.getSelection()).getFirstElement();
                URI replacementURI = Util.convertIFileToEMFURI((IFile)r);
                try {
                    ((ICacheService.IWorkspaceSynchronizer)E4InjectorHelper.getService(ICacheService.IWorkspaceSynchronizer.class)).handleReplace(curURI, replacementURI);
                    DuplicateManagerUI.this.initInput();
                    DuplicateManagerUI.this.duplicatedViewer.refresh();
                    DuplicateManagerUI.this.duplicatedViewer.expandAll();
                    DuplicateManagerUI.this.duplicateViewer.refresh();
                    DuplicateManagerUI.this.duplicateViewer.expandAll();
                    DuplicateManagerUI.this.duplicatedViewer.setSelection((ISelection)new StructuredSelection((Object)r));
                    DuplicateManagerUI.this.duplicatedViewer.reveal((Object)r);
                }
                catch (Exception ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.impact", "Failed to replace by duplicate", (Throwable)ex));
                }
            }
        }
    }
}

