/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.action;

import com.semarchy.xdi.engine.common.CommonUtils;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlRootElement(name="actionConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionConfiguration {
    private static Logger logger = LogManager.getLogger(ActionConfiguration.class);
    @XmlElement(name="action")
    private List<Action> actions;
    boolean already = false;
    static Map<String, Map<String, String>> overrideProperties = new HashMap<String, Map<String, String>>();

    public static ActionConfiguration getActionConfiguration(File file) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            ActionConfiguration actionConfiguration = ActionConfiguration.getActionConfiguration(is);
            return actionConfiguration;
        }
    }

    public static ActionConfiguration getActionConfiguration(InputStream is) throws TransformerFactoryConfigurationError {
        return (ActionConfiguration)JAXB.unmarshal((InputStream)is, ActionConfiguration.class);
    }

    public static ActionConfiguration getActionConfiguration(Node node) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        return (ActionConfiguration)JAXB.unmarshal((Reader)isr, ActionConfiguration.class);
    }

    public static String getOverloadValue(String className, String property) {
        Map<String, String> map = overrideProperties.get(className);
        if (map != null) {
            return map.get(property);
        }
        return null;
    }

    public void configure() {
        if (!this.already) {
            this.already = true;
            if (this.actions != null) {
                for (Action action : this.actions) {
                    if (action.className == null) continue;
                    Map<String, String> map = overrideProperties.get(action.className);
                    if (map == null) {
                        map = new HashMap<String, String>();
                        overrideProperties.put(action.className, map);
                    }
                    if (action.properties == null) continue;
                    for (ActionProperty prop : action.properties) {
                        map.put(prop.name, prop.value);
                    }
                }
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Action {
        @XmlAttribute(name="className", required=true)
        private String className;
        @XmlElement(name="property")
        private List<ActionProperty> properties;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ActionProperty {
        @XmlAttribute(name="name", required=true)
        private String name;
        @XmlAttribute(name="value", required=false)
        private String value;
    }
}

