/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.compiler.impl;

import com.indy.engine.common.compiler.impl.Messages;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class StambiaJavaCompilerTools {
    static String computeClassName(String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + "." + className;
    }

    static String getClassPathFromURLClassLoader(ClassLoader classLoader, boolean deeply) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append(".");
        StambiaJavaCompilerTools._getClassPath(buffer, classLoader, deeply);
        return buffer.toString();
    }

    private static void _getClassPath(StringBuffer buffer, ClassLoader classLoader, boolean deeply) throws Exception {
        if (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                String separator = System.getProperty("path.separator");
                URL[] uRLArray = urls;
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    File file = new File(url.toURI());
                    buffer.append(separator).append(file.getAbsolutePath());
                    ++n2;
                }
            }
            if (deeply) {
                StambiaJavaCompilerTools._getClassPath(buffer, classLoader.getParent(), deeply);
            }
        }
    }

    static List<URL> getURLsFromDir(File dir, boolean deeply, String ... extensions) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    boolean ok = true;
                    if (extensions != null && extensions.length > 0) {
                        ok = false;
                        String[] stringArray = extensions;
                        int n3 = extensions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String extension = stringArray[n4];
                            if (file.getName().endsWith(extension)) {
                                ok = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (ok) {
                        list.add(file.toURI().toURL());
                    }
                } else {
                    list.addAll(StambiaJavaCompilerTools.getURLsFromDir(file, deeply, extensions));
                }
                ++n2;
            }
        }
        return list;
    }

    static URLClassLoader createURLClassLoaderFromDir(ClassLoader parentClassLoader, File dir, boolean deeply, String ... extensions) throws Exception {
        File list = dir;
        if (!list.isDirectory()) {
            throw new Exception(Messages.getString("StambiaJavaCompilerTools.0") + dir.getName() + Messages.getString("StambiaJavaCompilerTools.1"));
        }
        List<URL> urls = StambiaJavaCompilerTools.getURLsFromDir(dir, deeply, extensions);
        URL[] _urls = new URL[urls.size()];
        urls.toArray(_urls);
        if (parentClassLoader != null) {
            return new URLClassLoader(_urls, parentClassLoader);
        }
        return new URLClassLoader(_urls);
    }

    static String[] extractPackageAndClassName(String qualifiedName) {
        String[] ret = new String[2];
        int index = qualifiedName.lastIndexOf(".");
        if (index == -1) {
            ret[0] = null;
            ret[1] = qualifiedName;
        } else {
            ret[0] = qualifiedName.substring(0, index);
            ret[1] = qualifiedName.substring(index + 1);
        }
        return ret;
    }
}

