/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.xml;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class XMLSerializer {
    XMLStreamWriter writer;
    String attributePrefix;
    String nillablePrefix;
    String xsiPrefix = "xsi";
    static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    boolean isRoot = true;

    XMLSerializer(XMLStreamWriter writer, String attributePrefix, String nillablePrefix) {
        this.writer = writer;
        this.attributePrefix = attributePrefix;
        this.nillablePrefix = nillablePrefix;
    }

    void serialize(Object node, String parentKey) throws XMLStreamException {
        if (node instanceof String) {
            String s = (String)node;
            this.serialize(s, parentKey);
        } else if (node instanceof Map) {
            Map m = (Map)node;
            this.serialize(m, parentKey);
        } else if (node instanceof List) {
            List l = (List)node;
            this.serialize(l, parentKey);
        } else {
            String nodeToWrite = null;
            if (node != null) {
                nodeToWrite = node.toString();
            }
            this.serialize(nodeToWrite, parentKey);
        }
    }

    void writeStartElement(String key) throws XMLStreamException {
        if (key != null) {
            this.writer.writeStartElement(key);
            if (this.isRoot) {
                this.isRoot = false;
                this.writer.writeNamespace(this.xsiPrefix, XSI_URI);
            }
        }
    }

    void writeEndElement(String key) throws XMLStreamException {
        if (key != null) {
            this.writer.writeEndElement();
        }
    }

    void serialize(String value, String parentKey) throws XMLStreamException {
        boolean isNillable = parentKey.startsWith(this.nillablePrefix);
        if (isNillable) {
            parentKey = parentKey.substring(this.nillablePrefix.length());
        }
        if (value != null) {
            this.writeStartElement(parentKey);
            this.writer.writeCharacters(value);
            this.writeEndElement(parentKey);
        } else if (isNillable) {
            this.writeStartElement(parentKey);
            this.writer.writeAttribute(this.xsiPrefix, XSI_URI, "nil", "true");
            this.writeEndElement(parentKey);
        }
    }

    void serialize(Map<String, Object> node, String parentKey) throws XMLStreamException {
        this.writeStartElement(parentKey);
        for (Map.Entry<String, Object> entry : node.entrySet()) {
            String key = entry.getKey();
            Object child = entry.getValue();
            if (key.startsWith(this.attributePrefix)) {
                if (child == null) continue;
                this.writer.writeAttribute(key.substring(this.attributePrefix.length()), child.toString());
                continue;
            }
            this.serialize(child, key);
        }
        this.writeEndElement(parentKey);
    }

    void serialize(List<Object> node, String parentKey) throws XMLStreamException {
        int i = 0;
        while (i < node.size()) {
            Object child = node.get(i);
            this.serialize(child, parentKey);
            ++i;
        }
    }
}

