/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc;

import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.engine.core.jdbc.IResultSetsKeyPairComparator;
import com.indy.runtime.api.ICellReader;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ResultSetsKeyPairComparator
implements IResultSetsKeyPairComparator {
    private ResultSet resultSetLeft;
    private ResultSet resultSetRight;
    private List<ICellReader<ResultSet>> cellReadersLeft;
    private List<ICellReader<ResultSet>> cellReadersRight;
    private boolean getDateAsTimestampLeft = false;
    private boolean getDateAsTimestampRight = false;

    public ResultSetsKeyPairComparator(ResultSet left, ResultSet right) {
        this.resultSetLeft = left;
        this.resultSetRight = right;
        this.cellReadersLeft = new ArrayList<ICellReader<ResultSet>>();
        this.cellReadersRight = new ArrayList<ICellReader<ResultSet>>();
    }

    public void declareKeyPairByPosition(int columnPositionLeft, int columnPositionRight) throws EngineExceptionI {
        try {
            CellMapProperties cellMapPropertiesLeft = new CellMapProperties();
            cellMapPropertiesLeft.sourceIndex = columnPositionLeft;
            cellMapPropertiesLeft.sourceName = this.resultSetLeft.getMetaData().getColumnLabel(columnPositionLeft);
            cellMapPropertiesLeft.sourceType = this.resultSetLeft.getMetaData().getColumnType(columnPositionLeft);
            JdbcReaderProperties sourcePropertiesLeft = new JdbcReaderProperties();
            sourcePropertiesLeft.setDateAsTimestamp(this.getDateAsTimestampLeft);
            this.cellReadersLeft.add((ICellReader<ResultSet>)JdbcConverter.getResultSetCellReader((CellMapProperties)cellMapPropertiesLeft, (JdbcReaderProperties)sourcePropertiesLeft));
            CellMapProperties cellMapPropertiesRight = new CellMapProperties();
            cellMapPropertiesRight.sourceIndex = columnPositionRight;
            cellMapPropertiesRight.sourceName = this.resultSetRight.getMetaData().getColumnLabel(columnPositionRight);
            cellMapPropertiesRight.sourceType = this.resultSetRight.getMetaData().getColumnType(columnPositionRight);
            JdbcReaderProperties sourcePropertiesRight = new JdbcReaderProperties();
            sourcePropertiesRight.setDateAsTimestamp(this.getDateAsTimestampRight);
            this.cellReadersRight.add((ICellReader<ResultSet>)JdbcConverter.getResultSetCellReader((CellMapProperties)cellMapPropertiesRight, (JdbcReaderProperties)sourcePropertiesRight));
            if (cellMapPropertiesLeft.sourceType != cellMapPropertiesRight.sourceType) {
                throw new EngineExceptionI("Cannot compare two columns with different JDBC Types");
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public boolean compare() throws EngineExceptionI {
        boolean ret = true;
        int index = 0;
        while (index < this.cellReadersLeft.size()) {
            if (ret) {
                ret = this.compareValues(index);
            }
            ++index;
        }
        return ret;
    }

    private boolean compareValues(int index) throws EngineExceptionI {
        Object valueRight;
        Object valueLeft;
        try {
            valueLeft = this.cellReadersLeft.get(index).read((Object)this.resultSetLeft);
            valueRight = this.cellReadersRight.get(index).read((Object)this.resultSetRight);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        if (valueLeft == null && valueRight == null) {
            return true;
        }
        if (valueLeft == null || valueRight == null) {
            return false;
        }
        if (valueLeft instanceof byte[] && valueRight instanceof byte[]) {
            return Arrays.equals((byte[])valueLeft, (byte[])valueRight);
        }
        return valueLeft.equals(valueRight);
    }

    public void configureGetDateAsTimestampLeft(boolean getDateAsTimestampLeft) {
        this.getDateAsTimestampLeft = getDateAsTimestampLeft;
    }

    public void configureGetDateAsTimestampRight(boolean getDateAsTimestampRight) {
        this.getDateAsTimestampRight = getDateAsTimestampRight;
    }

    public void declareKeyPairByHomonymy(String colName) throws EngineExceptionI {
        this.declareKeyPairByName(colName, colName);
    }

    public void declareKeyPairByName(String colNameLeft, String colNameRight) throws EngineExceptionI {
        int rightPos;
        int leftPos;
        try {
            if (this.resultSetLeft == null) {
                throw new EngineExceptionI("Left ResultSet must be declared first");
            }
            leftPos = this.resultSetLeft.findColumn(colNameLeft);
            if (this.resultSetRight == null) {
                throw new EngineExceptionI("Right ResultSet must be declared first");
            }
            rightPos = this.resultSetRight.findColumn(colNameRight);
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        this.declareKeyPairByPosition(leftPos, rightPos);
    }
}

