/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.engine.common;

import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.FunctionType;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.engine.common.HttpClientWrapper;
import com.semarchy.xdi.engine.common.Messages;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EngineFactory {
    public static final String JSON_METHOD_NAME = "method";
    public static final String JSON_PARAMETER_TYPES = "parametersTypes";
    public static final String JSON_PARAMETER_VALUES = "params";
    private static final Logger LOGGER = LogManager.getLogger(EngineFactory.class);
    private static final HttpClientWrapper clientWrapper = new HttpClientWrapper();
    public static final String FUNCTION_THREAD = FunctionType.getAllThreads.name();
    public static final String FUNCTION_CLIENT_RMI = FunctionType.getConnectedClient.name();
    public static final String FUNCTION_GET_DELIVERY_PARAMS = FunctionType.getDeliveryParams.name();
    public static final String FUNCTION_GET_INETADDRESS = FunctionType.getInetAddress.name();
    public static final String FUNCTION_MONITORING_SUMMARY = FunctionType.getMonitoringSummary.name();
    public static final String FUNCTION_TEST_CONNECTION = FunctionType.testConnection.name();
    public static final String FUNCTION_TEST_DELIVERY_CONNECTION = FunctionType.testDeliveryConnection.name();
    public static final String HTTP_REQUEST_HEADER_SESSION_ID = "com.indy.engine.common.EngineFactory.sessionId";

    public static LocalSession getEngine(String host, int port, Map<String, String> credentials, int enableSSL) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("enableSSL", enableSSL);
        return EngineFactory.getEngine(host, port, properties, credentials);
    }

    public static LocalSession getEngine(String host, int port, Map<String, String> credentials) throws Exception {
        return EngineFactory.getEngine(host, port, null, credentials);
    }

    public static LocalSession getEngine(String host, int port, Map<String, Object> properties, Map<String, String> credentials) throws Exception {
        Protocol protocol = null;
        String protocolAsString = (String)(properties != null ? properties.get("protocol") : null);
        if (protocolAsString == null) {
            if (host.startsWith("https://")) {
                protocol = Protocol.https;
            } else if (host.startsWith("http://")) {
                protocol = Protocol.http;
            } else {
                if (host.startsWith("rmi://") || host.startsWith("rmis://")) {
                    throw new Exception(Messages.getString("EngineFactory.5"));
                }
                protocol = Protocol.auto;
            }
        } else {
            protocol = Protocol.valueOf(protocolAsString);
        }
        URL url = protocol == Protocol.auto ? new URL("http://" + host + "/client/1") : new URL(host + "/client/1");
        url = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        LocalSession ls = EngineFactory.getHttpEngine(url, credentials);
        IEngineClient engine = ls.getRemoteObject();
        if (engine == null) {
            throw new Exception(Messages.getString("EngineFactory.1"));
        }
        ls.getRemoteObject().isConnected();
        return ls;
    }

    private static LocalSession getHttpEngine(final URL url, Map<String, String> credentials) throws Exception {
        String user = credentials != null ? credentials.get("user") : null;
        String encoded = null;
        if (user != null) {
            String password = credentials.getOrDefault("password", credentials.get("uncryptedPassword"));
            encoded = DatatypeConverter.printBase64Binary((byte[])(user + ":" + password).getBytes());
        }
        final String auth = encoded != null ? "Basic " + encoded : null;
        final String sessionID = UUID.randomUUID().toString();
        IEngineClient ret = (IEngineClient)Proxy.newProxyInstance(IEngineClient.class.getClassLoader(), new Class[]{IEngineClient.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try (InputStream is = null;){
                    Object object;
                    block39: {
                        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(url.toURI()).header(EngineFactory.HTTP_REQUEST_HEADER_SESSION_ID, sessionID).header("Accept-Encoding", "deflate");
                        if (auth != null) {
                            requestBuilder.header("Authorization", auth);
                        }
                        Map<String, Object> request = this.parseRequest(method, args);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        JsonNode.serialize(request, (OutputStream)baos, (String)StandardCharsets.UTF_8.name());
                        String requestAsString = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                        if (method.getName().equals("putDelivery") || method.getName().equals("initSessionWithStream")) {
                            requestBuilder.header("Params-In-Header", requestAsString);
                            is = (InputStream)args[0];
                        } else {
                            is = new ByteArrayInputStream(requestAsString.getBytes(StandardCharsets.UTF_8));
                        }
                        InputStream finalIs = is;
                        HttpResponse<InputStream> response = EngineFactory.clientWrapper.httpClient.send(requestBuilder.POST(HttpRequest.BodyPublishers.ofInputStream(() -> finalIs)).build(), HttpResponse.BodyHandlers.ofInputStream());
                        Map<String, Boolean> map = Map.of("PARSE_BSON_DATATYPE", true, "INTEGER_AS_INTEGER_OR_LONG", true);
                        if (response.statusCode() >= 400) {
                            Throwable throwable = null;
                            Object var13_17 = null;
                            try {
                                BufferedInputStream stream = new BufferedInputStream(response.body());
                                try {
                                    StringBuilder buf = new StringBuilder();
                                    Throwable throwable2 = null;
                                    Object var17_26 = null;
                                    try (Scanner scanner = new Scanner(stream);){
                                        scanner.useDelimiter("\\A");
                                        while (scanner.hasNext()) {
                                            buf.append(scanner.next());
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                    throw new IOException(buf.toString());
                                }
                                catch (Throwable throwable4) {
                                    if (stream != null) {
                                        ((InputStream)stream).close();
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                throw throwable;
                            }
                        }
                        Throwable throwable = null;
                        Object var13_19 = null;
                        InputStream stream = response.body();
                        try {
                            object = JsonUtils.jsonNodeToObject((InputStream)stream, (String)StandardCharsets.UTF_8.name(), map);
                            if (stream == null) break block39;
                        }
                        catch (Throwable throwable6) {
                            try {
                                try {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    if (throwable == null) {
                                        throwable = throwable7;
                                    } else if (throwable != throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (InterruptedException t) {
                                Thread.currentThread().interrupt();
                                LOGGER.error("Runtime client invocation interrupted", (Throwable)t);
                                throw t;
                            }
                        }
                        stream.close();
                    }
                    return object;
                }
            }

            private Map<String, Object> parseRequest(Method method, Object[] args) {
                HashMap<String, Object> request = new HashMap<String, Object>();
                request.put(EngineFactory.JSON_METHOD_NAME, method.getName());
                ArrayList<String> parametersTypes = new ArrayList<String>();
                Class<?>[] classArray = method.getParameterTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    parametersTypes.add(c.getName());
                    ++n2;
                }
                request.put(EngineFactory.JSON_PARAMETER_TYPES, parametersTypes);
                if (args != null) {
                    ArrayList<Object> params = new ArrayList<Object>();
                    Object[] objectArray = args;
                    int n3 = args.length;
                    n = 0;
                    while (n < n3) {
                        Object obj = objectArray[n];
                        if (!(obj instanceof InputStream)) {
                            params.add(obj);
                        }
                        ++n;
                    }
                    request.put(EngineFactory.JSON_PARAMETER_VALUES, params);
                }
                return request;
            }
        });
        return new LocalSession(url.getHost(), url.getPort(), Boolean.valueOf(url.toString().startsWith("https")), Boolean.valueOf(true), ret, new RemoteSessionInfo(sessionID, url.getHost(), user));
    }

    public static enum Protocol {
        http,
        https,
        auto;

    }
}

