/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;
import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceImpl;
import com.semarchy.xdi.runtime.connection.jdbc.JdbcParameters;
import com.semarchy.xdi.runtime.connection.jdbc.Messages;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DriverManagerDataSourceImpl
extends AbstractDataSourceImpl {
    private PrintWriter printWriter;

    public DriverManagerDataSourceImpl(JdbcParameters jdbcParameters) {
        super(jdbcParameters);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (this.printWriter == null) {
            throw new UnsupportedOperationException(Messages.getString("jdbc.notPrintWriter"));
        }
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("jdbc.notImplemented"));
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        JdbcParameters jdbcParameters = this.getJdbcParameters();
        return this.getConnection(jdbcParameters.getUsername(), jdbcParameters.getPassword());
    }

    private Connection doConnect(Driver driver, Properties properties) throws SQLException {
        JdbcParameters jdbcParameters = this.getJdbcParameters();
        try {
            return driver.connect(jdbcParameters.getUrl(), properties);
        }
        catch (SQLException e) {
            throw jdbcParameters.hasSecrets() ? new SQLException((Throwable)new SecretStatementException()) : e;
        }
    }

    public Driver instanciateDriver() throws Exception {
        ClassLoader cl = this.getJDBCClassLoader();
        String driverName = this.getJdbcParameters().getDriver();
        try {
            Class<?> clazz = Class.forName(driverName, true, cl);
            return (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            throw new Exception(String.format(Messages.getString("JdbcDataSource.2"), cl, driverName), ex);
        }
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        Driver driver = null;
        JdbcParameters jdbcParameters = this.getJdbcParameters();
        try {
            driver = this.instanciateDriver();
            Properties mergedProps = new Properties();
            mergedProps.putAll((Map<?, ?>)jdbcParameters.getProperties());
            if (username != null) {
                mergedProps.setProperty("user", jdbcParameters.evaluateSecuredExternalValues(username));
            }
            if (password != null) {
                mergedProps.setProperty("password", jdbcParameters.evaluateSecuredExternalValues(password));
            }
            Connection conn = this.doConnect(driver, mergedProps);
            conn.setAutoCommit(jdbcParameters.isAutocommit());
            List<String> initSqls = jdbcParameters.getConnectionInitSqls();
            if (!initSqls.isEmpty()) {
                try (Statement stmt = null;){
                    stmt = conn.createStatement();
                    for (String sql : initSqls) {
                        stmt.execute(sql);
                    }
                }
            }
            return conn;
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    protected void refreshCredentials() {
    }
}

